/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.DarknetPeerNode;
import freenet.node.PeerNodeStatus;

public class DarknetPeerNodeStatus
extends PeerNodeStatus {
    private final String name;
    private final boolean burstOnly;
    private final boolean listening;
    private final boolean disabled;
    private final String privateDarknetCommentNote;
    private DarknetPeerNode.FRIEND_TRUST trustLevel;
    private DarknetPeerNode.FRIEND_VISIBILITY ourVisibility;
    private DarknetPeerNode.FRIEND_VISIBILITY theirVisibility;
    private DarknetPeerNode.FRIEND_VISIBILITY overallVisibility;

    public DarknetPeerNodeStatus(DarknetPeerNode peerNode, boolean noHeavy) {
        super(peerNode, noHeavy);
        this.name = peerNode.getName();
        this.burstOnly = peerNode.isBurstOnly();
        this.listening = peerNode.isListenOnly();
        this.disabled = peerNode.isDisabled();
        this.privateDarknetCommentNote = peerNode.getPrivateDarknetCommentNote();
        this.trustLevel = peerNode.getTrustLevel();
        this.ourVisibility = peerNode.getOurVisibility();
        this.theirVisibility = peerNode.getTheirVisibility();
        this.overallVisibility = this.ourVisibility.isStricterThan(this.theirVisibility) ? this.ourVisibility : this.theirVisibility;
    }

    public DarknetPeerNode.FRIEND_TRUST getTrustLevel() {
        return this.trustLevel;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBurstOnly() {
        return this.burstOnly;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isListening() {
        return this.listening;
    }

    public String getPrivateDarknetCommentNote() {
        return this.privateDarknetCommentNote;
    }

    @Override
    public String toString() {
        return this.name + ' ' + super.toString();
    }

    public DarknetPeerNode.FRIEND_VISIBILITY getOurVisibility() {
        return this.ourVisibility;
    }

    public DarknetPeerNode.FRIEND_VISIBILITY getTheirVisibility() {
        if (this.theirVisibility == null) {
            return DarknetPeerNode.FRIEND_VISIBILITY.NO;
        }
        return this.theirVisibility;
    }

    public DarknetPeerNode.FRIEND_VISIBILITY getOverallVisibility() {
        return this.overallVisibility;
    }
}

