/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.Global;
import freenet.crypt.SHA256;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.support.math.MersenneTwister;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.Random;

public class ClientKSK
extends InsertableClientSSK {
    private static final long serialVersionUID = 1L;
    final String keyword;

    private ClientKSK(String keyword, byte[] pubKeyHash, DSAPublicKey pubKey, DSAPrivateKey privKey, byte[] keywordHash) throws MalformedURLException {
        super(keyword, pubKeyHash, pubKey, privKey, keywordHash, (byte)2);
        this.keyword = keyword;
    }

    protected ClientKSK() {
        this.keyword = null;
    }

    @Override
    public FreenetURI getURI() {
        return new FreenetURI("KSK", this.keyword);
    }

    public static InsertableClientSSK create(FreenetURI uri) {
        if (!uri.getKeyType().equals("KSK")) {
            throw new IllegalArgumentException();
        }
        return ClientKSK.create(uri.getDocName());
    }

    public static ClientKSK create(String keyword) {
        MessageDigest md256 = SHA256.getMessageDigest();
        try {
            byte[] keywordHash;
            try {
                keywordHash = md256.digest(keyword.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            MersenneTwister mt = new MersenneTwister(keywordHash);
            DSAPrivateKey privKey = new DSAPrivateKey(Global.DSAgroupBigA, (Random)((Object)mt));
            DSAPublicKey pubKey = new DSAPublicKey(Global.DSAgroupBigA, privKey);
            byte[] pubKeyHash = md256.digest(pubKey.asBytes());
            try {
                ClientKSK clientKSK = new ClientKSK(keyword, pubKeyHash, pubKey, privKey, keywordHash);
                return clientKSK;
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
        }
        finally {
            SHA256.returnMessageDigest(md256);
        }
    }
}

