/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.HashResult;
import freenet.crypt.HashType;
import freenet.support.Logger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class MultiHashInputStream
extends FilterInputStream {
    private Digester[] digesters;
    private long readBytes;

    public MultiHashInputStream(InputStream proxy, long generateHashes) {
        super(proxy);
        ArrayList<Digester> digesters = new ArrayList<Digester>();
        for (HashType type : HashType.values()) {
            if ((generateHashes & (long)type.bitmask) != (long)type.bitmask) continue;
            try {
                digesters.add(new Digester(type));
            }
            catch (NoSuchAlgorithmException e) {
                Logger.error(this, "Algorithm not available: " + (Object)((Object)type));
            }
        }
        this.digesters = digesters.toArray(new Digester[digesters.size()]);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int ret = this.in.read(buf, off, len);
        if (ret <= 0) {
            return ret;
        }
        for (Digester d : this.digesters) {
            d.digest.update(buf, off, ret);
        }
        this.readBytes += (long)ret;
        return ret;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret < 0) {
            return ret;
        }
        byte[] b = new byte[]{(byte)ret};
        for (Digester d : this.digesters) {
            d.digest.update(b, 0, 1);
        }
        ++this.readBytes;
        return ret;
    }

    @Override
    public long skip(long length) throws IOException {
        byte[] buf = new byte[(int)Math.min(32768L, length)];
        long skipped = 0L;
        while (length > 0L) {
            int x = this.read(buf, 0, (int)Math.min((long)buf.length, length));
            if (x == -1) {
                return skipped;
            }
            skipped += (long)x;
            length -= (long)x;
        }
        return skipped;
    }

    public HashResult[] getResults() {
        HashResult[] results = new HashResult[this.digesters.length];
        for (int i = 0; i < this.digesters.length; ++i) {
            results[i] = this.digesters[i].getResult();
        }
        this.digesters = null;
        return results;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    class Digester {
        HashType hashType;
        MessageDigest digest;

        Digester(HashType hashType) throws NoSuchAlgorithmException {
            this.hashType = hashType;
            this.digest = hashType.get();
        }

        HashResult getResult() {
            HashResult result = new HashResult(this.hashType, this.digest.digest());
            this.hashType.recycle(this.digest);
            this.digest = null;
            return result;
        }
    }
}

