/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.JceLoader;
import freenet.node.FSParseException;
import freenet.support.Base64;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class ECDSA {
    public final Curves curve;
    private final KeyPair key;

    public ECDSA(Curves curve) {
        this.curve = curve;
        this.key = curve.keygen.generateKeyPair();
    }

    public ECDSA(SimpleFieldSet sfs, Curves curve) throws FSParseException {
        byte[] pub = null;
        byte[] pri = null;
        try {
            pub = Base64.decode(sfs.get("pub"));
            if (pub.length > curve.modulusSize) {
                throw new InvalidKeyException();
            }
            ECPublicKey pubK = ECDSA.getPublicKey(pub, curve);
            pri = Base64.decode(sfs.get("pri"));
            PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(pri);
            KeyFactory kf = KeyFactory.getInstance("EC", curve.kfProvider);
            ECPrivateKey privK = (ECPrivateKey)kf.generatePrivate(ks);
            this.key = new KeyPair(pubK, privK);
        }
        catch (Exception e) {
            throw new FSParseException(e);
        }
        this.curve = curve;
    }

    public byte[] sign(byte[] ... data) {
        byte[] result = null;
        try {
            while (true) {
                Signature sig = Signature.getInstance(this.curve.defaultHashAlgorithm.replace("ECDSA", "ECDDSA"), JceLoader.BouncyCastle);
                sig.initSign(this.key.getPrivate());
                for (byte[] d : data) {
                    sig.update(d);
                }
                result = sig.sign();
                if (result.length > this.curve.maxSigSize) {
                    Logger.error(this, "DER encoded signature used " + result.length + " bytes, more than expected " + this.curve.maxSigSize + " - re-signing...");
                    continue;
                }
                break;
            }
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(this, "NoSuchAlgorithmException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            Logger.error(this, "InvalidKeyException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (SignatureException e) {
            Logger.error(this, "SignatureException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return result;
    }

    public byte[] signToNetworkFormat(byte[] ... data) {
        int targetLength;
        byte[] plainsig = this.sign(data);
        if (plainsig.length != (targetLength = this.curve.maxSigSize)) {
            byte[] newData = new byte[targetLength];
            if (plainsig.length >= targetLength) {
                throw new IllegalStateException("Too long!");
            }
            System.arraycopy(plainsig, 0, newData, 0, plainsig.length);
            plainsig = newData;
        }
        return plainsig;
    }

    public boolean verify(byte[] signature, byte[] ... data) {
        return ECDSA.verify(this.curve, this.getPublicKey(), signature, data);
    }

    public boolean verify(byte[] signature, int sigoffset, int siglen, byte[] ... data) {
        return ECDSA.verify(this.curve, this.getPublicKey(), signature, sigoffset, siglen, data);
    }

    public static boolean verify(Curves curve, ECPublicKey key, byte[] signature, byte[] ... data) {
        return ECDSA.verify(curve, key, signature, 0, signature.length, data);
    }

    private static int actualSignatureLength(byte[] signature, int sigOff, int sigLen) throws SignatureException {
        if (sigLen < 2 || signature[sigOff] != 48) {
            throw new SignatureException("Not a sequence");
        }
        int length = signature[1 + sigOff] & 0xFF;
        if (length == 128) {
            throw new SignatureException("Indefinite length");
        }
        if (length <= 127) {
            return length + 2;
        }
        int size = length & 0x7F;
        if (size > 4) {
            throw new SignatureException("Header too big");
        }
        if (sigLen < size + 2) {
            throw new SignatureException("Header out of bounds");
        }
        length = 0;
        for (int i = 0; i < size; ++i) {
            length <<= 8;
            length += signature[i + sigOff + 2] & 0xFF;
        }
        if (length < 0) {
            throw new SignatureException("Negative sequence length");
        }
        if (length > sigLen - 2 - size) {
            throw new SignatureException("Sequence out of bounds");
        }
        return length + 2 + size;
    }

    public static boolean verify(Curves curve, ECPublicKey key, byte[] signature, int sigoffset, int siglen, byte[] ... data) {
        if (key == null || curve == null || signature == null || data == null) {
            return false;
        }
        boolean result = false;
        try {
            Signature sig = Signature.getInstance(curve.defaultHashAlgorithm, curve.sigProvider);
            sig.initVerify(key);
            for (byte[] d : data) {
                sig.update(d);
            }
            siglen = ECDSA.actualSignatureLength(signature, sigoffset, siglen);
            result = sig.verify(signature, sigoffset, siglen);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(ECDSA.class, "NoSuchAlgorithmException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            Logger.error(ECDSA.class, "InvalidKeyException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (SignatureException e) {
            Logger.error(ECDSA.class, "SignatureException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return result;
    }

    public ECPublicKey getPublicKey() {
        return (ECPublicKey)this.key.getPublic();
    }

    public static ECPublicKey getPublicKey(byte[] data, Curves curve) {
        ECPublicKey remotePublicKey = null;
        try {
            X509EncodedKeySpec ks = new X509EncodedKeySpec(data);
            KeyFactory kf = KeyFactory.getInstance("EC", curve.kfProvider);
            remotePublicKey = (ECPublicKey)kf.generatePublic(ks);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(ECDSA.class, "NoSuchAlgorithmException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            Logger.error(ECDSA.class, "InvalidKeySpecException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return remotePublicKey;
    }

    public SimpleFieldSet asFieldSet(boolean includePrivate) {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        SimpleFieldSet fsCurve = new SimpleFieldSet(true);
        fsCurve.putSingle("pub", Base64.encode(this.key.getPublic().getEncoded()));
        if (includePrivate) {
            fsCurve.putSingle("pri", Base64.encode(this.key.getPrivate().getEncoded()));
        }
        fs.put(this.curve.name(), fsCurve);
        return fs;
    }

    public static enum Curves {
        P256("secp256r1", "SHA256withECDSA", 91, 72),
        P384("secp384r1", "SHA384withECDSA", 120, 104),
        P521("secp521r1", "SHA512withECDSA", 158, 139);

        public final ECGenParameterSpec spec;
        private final KeyPairGenerator keygen;
        public final String defaultHashAlgorithm;
        public final int modulusSize;
        public final int maxSigSize;
        protected final Provider kgProvider;
        protected final Provider kfProvider;
        protected final Provider sigProvider;

        private static KeyPair selftest(KeyPairGenerator kg, KeyFactory kf, int modulusSize) throws InvalidKeySpecException {
            KeyPair key = kg.generateKeyPair();
            PublicKey pub = key.getPublic();
            PrivateKey pk = key.getPrivate();
            byte[] pubkey = pub.getEncoded();
            byte[] pkey = pk.getEncoded();
            if (pubkey.length > modulusSize || pubkey.length == 0) {
                throw new Error("Unexpected pubkey length: " + pubkey.length + "!=" + modulusSize);
            }
            PublicKey pub2 = kf.generatePublic(new X509EncodedKeySpec(pubkey));
            if (!Arrays.equals(pub2.getEncoded(), pubkey)) {
                throw new Error("Pubkey encoding mismatch");
            }
            PrivateKey pk2 = kf.generatePrivate(new PKCS8EncodedKeySpec(pkey));
            return key;
        }

        private static void selftest_sign(KeyPair key, Signature sig) throws SignatureException, InvalidKeyException {
            sig.initSign(key.getPrivate());
            byte[] sign = sig.sign();
            sig.initVerify(key.getPublic());
            boolean verified = sig.verify(sign);
            if (!verified) {
                throw new Error("Verification failed");
            }
        }

        private Curves(String name, String defaultHashAlgorithm, int modulusSize, int maxSigSize) {
            this.spec = new ECGenParameterSpec(name);
            Signature sig = null;
            KeyFactory kf = null;
            KeyPairGenerator kg = null;
            JceLoader.BouncyCastle.toString();
            try {
                KeyPair key = null;
                try {
                    kg = KeyPairGenerator.getInstance("EC");
                    kf = KeyFactory.getInstance("EC");
                    kg.initialize(this.spec);
                    key = Curves.selftest(kg, kf, modulusSize);
                }
                catch (Throwable e) {
                    Logger.warning((Object)this, "default KeyPairGenerator provider (" + (kg != null ? kg.getProvider() : null) + ") is broken, falling back to BouncyCastle", e);
                    kg = KeyPairGenerator.getInstance("EC", JceLoader.BouncyCastle);
                    kf = KeyFactory.getInstance("EC", JceLoader.BouncyCastle);
                    kg.initialize(this.spec);
                    key = Curves.selftest(kg, kf, modulusSize);
                }
                try {
                    sig = Signature.getInstance(defaultHashAlgorithm);
                    Curves.selftest_sign(key, sig);
                }
                catch (Throwable e) {
                    Logger.warning((Object)this, "default Signature provider (" + (sig != null ? sig.getProvider() : null) + ") is broken or incompatible with KeyPairGenerator, falling back to BouncyCastle", e);
                    kg = KeyPairGenerator.getInstance("EC", JceLoader.BouncyCastle);
                    kf = KeyFactory.getInstance("EC", JceLoader.BouncyCastle);
                    kg.initialize(this.spec);
                    key = kg.generateKeyPair();
                    sig = Signature.getInstance(defaultHashAlgorithm, JceLoader.BouncyCastle);
                    Curves.selftest_sign(key, sig);
                }
            }
            catch (NoSuchAlgorithmException e) {
                Logger.error(ECDSA.class, "NoSuchAlgorithmException : " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            catch (InvalidAlgorithmParameterException e) {
                Logger.error(ECDSA.class, "InvalidAlgorithmParameterException : " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            catch (InvalidKeyException e) {
                throw new Error(e);
            }
            catch (InvalidKeySpecException e) {
                throw new Error(e);
            }
            catch (SignatureException e) {
                throw new Error(e);
            }
            this.kgProvider = kg.getProvider();
            this.kfProvider = kf.getProvider();
            this.sigProvider = sig.getProvider();
            this.keygen = kg;
            this.defaultHashAlgorithm = defaultHashAlgorithm;
            this.modulusSize = modulusSize;
            this.maxSigSize = maxSigSize;
            Logger.normal((Object)this, name + ": using " + this.kgProvider + " for KeyPairGenerator(EC)");
            Logger.normal((Object)this, name + ": using " + this.kfProvider + " for KeyFactory(EC)");
            Logger.normal((Object)this, name + ": using " + this.sigProvider + " for Signature(" + defaultHashAlgorithm + ")");
        }

        public synchronized KeyPair generateKeyPair() {
            return this.keygen.generateKeyPair();
        }

        public SimpleFieldSet getSFS(ECPublicKey pub) {
            SimpleFieldSet ecdsaSFS = new SimpleFieldSet(true);
            SimpleFieldSet curveSFS = new SimpleFieldSet(true);
            curveSFS.putSingle("pub", Base64.encode(pub.getEncoded()));
            ecdsaSFS.put(this.name(), curveSFS);
            return ecdsaSFS;
        }

        public String toString() {
            return this.spec.getName();
        }
    }
}

