/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.io.AddressTracker;
import freenet.io.AddressTrackerItem;
import freenet.io.InetAddressAddressTrackerItem;
import freenet.io.PeerAddressTrackerItem;
import freenet.io.comm.UdpSocketHandler;
import freenet.l10n.NodeL10n;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.support.HTMLNode;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class ConnectivityToadlet
extends Toadlet {
    private final Node node;
    public static final String PATH = "/connectivity/";

    protected ConnectivityToadlet(HighLevelSimpleClient client, Node node) {
        super(client);
        this.node = node;
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        PageMaker pageMaker = ctx.getPageMaker();
        PageNode page = pageMaker.getPageNode(NodeL10n.getBase().getString("ConnectivityToadlet.title"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(ctx.getAlertManager().createSummary());
        }
        HTMLNode portInfobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        portInfobox.addChild("div", "class", "infobox-header", this.l10nConn("nodePortsTitle"));
        HTMLNode portInfoboxContent = portInfobox.addChild("div", "class", "infobox-content");
        HTMLNode portInfoList = portInfoboxContent.addChild("ul");
        SimpleFieldSet fproxyConfig = this.node.config.get("fproxy").exportFieldSet(true);
        SimpleFieldSet fcpConfig = this.node.config.get("fcp").exportFieldSet(true);
        SimpleFieldSet tmciConfig = this.node.config.get("console").exportFieldSet(true);
        portInfoList.addChild("li", NodeL10n.getBase().getString("DarknetConnectionsToadlet.darknetFnpPort", new String[]{"port"}, new String[]{Integer.toString(this.node.getFNPPort())}));
        int opennetPort = this.node.getOpennetFNPPort();
        if (opennetPort > 0) {
            portInfoList.addChild("li", NodeL10n.getBase().getString("DarknetConnectionsToadlet.opennetFnpPort", new String[]{"port"}, new String[]{Integer.toString(opennetPort)}));
        }
        try {
            if (fproxyConfig.getBoolean("enabled", false)) {
                portInfoList.addChild("li", NodeL10n.getBase().getString("DarknetConnectionsToadlet.fproxyPort", new String[]{"port"}, new String[]{Integer.toString(fproxyConfig.getInt("port"))}));
            } else {
                portInfoList.addChild("li", this.l10nConn("fproxyDisabled"));
            }
            if (fcpConfig.getBoolean("enabled", false)) {
                portInfoList.addChild("li", NodeL10n.getBase().getString("DarknetConnectionsToadlet.fcpPort", new String[]{"port"}, new String[]{Integer.toString(fcpConfig.getInt("port"))}));
            } else {
                portInfoList.addChild("li", this.l10nConn("fcpDisabled"));
            }
            if (tmciConfig.getBoolean("enabled", false)) {
                portInfoList.addChild("li", NodeL10n.getBase().getString("DarknetConnectionsToadlet.tmciPort", new String[]{"port"}, new String[]{Integer.toString(tmciConfig.getInt("port"))}));
            } else {
                portInfoList.addChild("li", this.l10nConn("tmciDisabled"));
            }
        }
        catch (FSParseException fSParseException) {
            // empty catch block
        }
        this.node.ipDetector.addConnectionTypeBox(contentNode);
        UdpSocketHandler[] handlers = this.node.getPacketSocketHandlers();
        HTMLNode summaryContent = pageMaker.getInfobox("#", NodeL10n.getBase().getString("ConnectivityToadlet.summaryTitle"), contentNode, "connectivity-summary", true);
        HTMLNode table = summaryContent.addChild("table", "border", "0");
        for (UdpSocketHandler handler : handlers) {
            AddressTracker tracker = handler.getAddressTracker();
            HTMLNode row = table.addChild("tr");
            row.addChild("td", handler.getTitle());
            row.addChild("td", AddressTracker.statusString(tracker.getPortForwardStatus()));
        }
        if (ctx.isAdvancedModeEnabled()) {
            String noreply = this.l10n("noreply");
            String local = this.l10n("local");
            String remote = this.l10n("remote");
            long now = System.currentTimeMillis();
            for (UdpSocketHandler handler : handlers) {
                AddressTracker tracker = handler.getAddressTracker();
                HTMLNode portsContent = pageMaker.getInfobox("#", NodeL10n.getBase().getString("ConnectivityToadlet.byPortTitle", new String[]{"port", "status", "tunnelLength"}, new String[]{handler.getTitle(), AddressTracker.statusString(tracker.getPortForwardStatus()), TimeUtil.formatTime(tracker.getLongestSendReceiveGap())}), contentNode, "connectivity-port", false);
                PeerAddressTrackerItem[] items = tracker.getPeerAddressTrackerItems();
                table = portsContent.addChild("table");
                HTMLNode row = table.addChild("tr");
                row.addChild("th", this.l10n("addressTitle"));
                row.addChild("th", this.l10n("sentReceivedTitle"));
                row.addChild("th", this.l10n("localRemoteTitle"));
                row.addChild("th", this.l10n("firstSendLeadTime"));
                row.addChild("th", this.l10n("firstReceiveLeadTime"));
                for (int j = 0; j < 5; ++j) {
                    row.addChild("th", " ");
                }
                for (PeerAddressTrackerItem item : items) {
                    row = table.addChild("tr");
                    row.addChild("td", item.peer.toString());
                    row.addChild("td", item.packetsSent() + "/ " + item.packetsReceived());
                    row.addChild("td", item.packetsReceived() == 0L ? noreply : (item.weSentFirst() ? local : remote));
                    row.addChild("td", TimeUtil.formatTime(item.timeFromStartupToFirstSentPacket()));
                    row.addChild("td", TimeUtil.formatTime(item.timeFromStartupToFirstReceivedPacket()));
                    AddressTrackerItem.Gap[] gaps = item.getGaps();
                    for (int k = 0; k < 5; ++k) {
                        row.addChild("td", gaps[k].receivedPacketAt == 0L ? "" : TimeUtil.formatTime(gaps[k].gapLength) + " @ " + TimeUtil.formatTime(now - gaps[k].receivedPacketAt) + " ago");
                    }
                }
                portsContent = pageMaker.getInfobox("#", NodeL10n.getBase().getString("ConnectivityToadlet.byIPTitle", new String[]{"ip", "status", "tunnelLength"}, new String[]{handler.getTitle(), AddressTracker.statusString(tracker.getPortForwardStatus()), TimeUtil.formatTime(tracker.getLongestSendReceiveGap())}), contentNode, "connectivity-ip", false);
                InetAddressAddressTrackerItem[] ipItems = tracker.getInetAddressTrackerItems();
                table = portsContent.addChild("table");
                row = table.addChild("tr");
                row.addChild("th", this.l10n("addressTitle"));
                row.addChild("th", this.l10n("sentReceivedTitle"));
                row.addChild("th", this.l10n("localRemoteTitle"));
                row.addChild("th", this.l10n("firstSendLeadTime"));
                row.addChild("th", this.l10n("firstReceiveLeadTime"));
                for (int j = 0; j < 5; ++j) {
                    row.addChild("th", " ");
                }
                for (InetAddressAddressTrackerItem item : ipItems) {
                    row = table.addChild("tr");
                    row.addChild("td", item.addr.toString());
                    row.addChild("td", item.packetsSent() + "/ " + item.packetsReceived());
                    row.addChild("td", item.packetsReceived() == 0L ? noreply : (item.weSentFirst() ? local : remote));
                    row.addChild("td", TimeUtil.formatTime(item.timeFromStartupToFirstSentPacket()));
                    row.addChild("td", TimeUtil.formatTime(item.timeFromStartupToFirstReceivedPacket()));
                    AddressTrackerItem.Gap[] gaps = item.getGaps();
                    for (int k = 0; k < 5; ++k) {
                        row.addChild("td", gaps[k].receivedPacketAt == 0L ? "" : TimeUtil.formatTime(gaps[k].gapLength) + " @ " + TimeUtil.formatTime(now - gaps[k].receivedPacketAt) + " ago");
                    }
                }
            }
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private String l10nConn(String string) {
        return NodeL10n.getBase().getString("DarknetConnectionsToadlet." + string);
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("ConnectivityToadlet." + key);
    }

    @Override
    public String path() {
        return PATH;
    }
}

