/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.async.BinaryBlobWriter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.CompatibilityAnalyser;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentClientCallback;
import freenet.client.async.PersistentJob;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.EnterFiniteCooldownEvent;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileCompatibilityModeEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.clients.fcp.AllDataMessage;
import freenet.clients.fcp.ClientGetMessage;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.CompatibilityMode;
import freenet.clients.fcp.DataFoundMessage;
import freenet.clients.fcp.DownloadRequestStatus;
import freenet.clients.fcp.EnterFiniteCooldown;
import freenet.clients.fcp.ExpectedDataLength;
import freenet.clients.fcp.ExpectedHashes;
import freenet.clients.fcp.ExpectedMIME;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPConnectionOutputHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.GetFailedMessage;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.NotAllowedException;
import freenet.clients.fcp.PersistentGet;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.clients.fcp.PersistentRequestRemovedMessage;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.clients.fcp.RequestIdentifier;
import freenet.clients.fcp.RequestStatus;
import freenet.clients.fcp.RequestStatusCache;
import freenet.clients.fcp.SendingToNetworkMessage;
import freenet.clients.fcp.SimpleProgressMessage;
import freenet.crypt.ChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.crypt.HashResult;
import freenet.keys.FreenetURI;
import freenet.node.NodeClientCore;
import freenet.support.CurrentTimeUTC;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.BucketTools;
import freenet.support.io.FileBucket;
import freenet.support.io.NativeThread;
import freenet.support.io.NullBucket;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ClientGet
extends ClientRequest
implements ClientGetCallback,
ClientEventListener,
PersistentClientCallback {
    private static final long serialVersionUID = 1L;
    private final FetchContext fctx;
    private final ClientGetter getter;
    private final ReturnType returnType;
    private final File targetFile;
    private Bucket returnBucketDirect;
    private final boolean binaryBlob;
    private final String extensionCheck;
    private final Bucket initialMetadata;
    private static final int VERBOSITY_SPLITFILE_PROGRESS = 1;
    private static final int VERBOSITY_SENT_TO_NETWORK = 2;
    private static final int VERBOSITY_COMPATIBILITY_MODE = 4;
    private static final int VERBOSITY_EXPECTED_HASHES = 8;
    private static final int VERBOSITY_EXPECTED_TYPE = 32;
    private static final int VERBOSITY_EXPECTED_SIZE = 64;
    private static final int VERBOSITY_ENTER_FINITE_COOLDOWN = 128;
    private boolean succeeded;
    private long foundDataLength = -1L;
    private String foundDataMimeType;
    private GetFailedMessage getFailedMessage;
    private transient SimpleProgressMessage progressPending;
    private boolean sentToNetwork;
    private CompatibilityAnalyser compatMode;
    private ExpectedHashes expectedHashes;
    private static volatile boolean logMINOR;
    private static Map<Short, ReturnType> returnTypeByCode;
    private static final long CLIENT_DETAIL_MAGIC = 7427662184943854324L;
    private static final int CLIENT_DETAIL_VERSION = 1;

    public ClientGet(PersistentRequestClient globalClient, FreenetURI uri, boolean dsOnly, boolean ignoreDS, boolean filterData, int maxSplitfileRetries, int maxNonSplitfileRetries, long maxOutputLength, ReturnType returnType, boolean persistRebootOnly, String identifier, int verbosity, short prioClass, File returnFilename, String charset, boolean writeToClientCache, boolean realTimeFlag, boolean binaryBlob, NodeClientCore core) throws IdentifierCollisionException, NotAllowedException, IOException {
        super(uri, identifier, verbosity, charset, null, globalClient, prioClass, persistRebootOnly ? ClientRequest.Persistence.REBOOT : ClientRequest.Persistence.FOREVER, realTimeFlag, null, true);
        this.fctx = core.clientContext.getDefaultPersistentFetchContext();
        this.fctx.eventProducer.addEventListener(this);
        this.fctx.localRequestOnly = dsOnly;
        this.fctx.ignoreStore = ignoreDS;
        this.fctx.maxNonSplitfileRetries = maxNonSplitfileRetries;
        this.fctx.maxSplitfileBlockRetries = maxSplitfileRetries;
        this.fctx.filterData = filterData;
        this.fctx.maxOutputLength = maxOutputLength;
        this.fctx.maxTempLength = maxOutputLength;
        this.fctx.canWriteClientCache = writeToClientCache;
        this.compatMode = new CompatibilityAnalyser();
        RandomAccessBucket ret = null;
        this.returnType = returnType;
        this.binaryBlob = binaryBlob;
        String extensionCheck = null;
        if (returnType == ReturnType.DISK) {
            String name;
            int idx;
            this.targetFile = returnFilename;
            if (!core.allowDownloadTo(returnFilename)) {
                throw new NotAllowedException();
            }
            if (this.targetFile.exists()) {
                if (this.targetFile.length() == 0L) {
                    this.targetFile.delete();
                    Logger.error(this, "Target file already exists but is zero length, deleting...");
                }
                if (this.targetFile.exists()) {
                    throw new IOException("Target filename exists already: " + this.targetFile);
                }
            }
            ret = new FileBucket(returnFilename, false, true, false, false);
            if (filterData && (idx = (name = returnFilename.getName()).lastIndexOf(46)) != -1 && ++idx != name.length()) {
                extensionCheck = name.substring(idx);
            }
        } else if (returnType == ReturnType.NONE) {
            this.targetFile = null;
            ret = new NullBucket();
        } else {
            this.targetFile = null;
            ret = null;
        }
        this.extensionCheck = extensionCheck;
        this.initialMetadata = null;
        this.getter = this.makeGetter(core, ret);
    }

    public ClientGet(FCPConnectionHandler handler, ClientGetMessage message, NodeClientCore core) throws IdentifierCollisionException, MessageInvalidException {
        super(message.uri, message.identifier, message.verbosity, message.charset, handler, message.priorityClass, message.persistence, message.realTimeFlag, message.clientToken, message.global);
        this.fctx = core.clientContext.getDefaultPersistentFetchContext();
        this.fctx.eventProducer.addEventListener(this);
        this.fctx.localRequestOnly = message.dsOnly;
        this.fctx.ignoreStore = message.ignoreDS;
        this.fctx.maxNonSplitfileRetries = message.maxRetries;
        this.fctx.maxSplitfileBlockRetries = message.maxRetries;
        this.fctx.maxOutputLength = message.maxSize;
        this.fctx.maxTempLength = message.maxTempSize;
        this.fctx.canWriteClientCache = message.writeToClientCache;
        this.fctx.filterData = message.filterData;
        this.fctx.ignoreUSKDatehints = message.ignoreUSKDatehints;
        this.compatMode = new CompatibilityAnalyser();
        if (message.allowedMIMETypes != null) {
            this.fctx.allowedMIMETypes = new HashSet<String>();
            for (String mime : message.allowedMIMETypes) {
                this.fctx.allowedMIMETypes.add(mime);
            }
        }
        this.returnType = message.returnType;
        this.binaryBlob = message.binaryBlob;
        RandomAccessBucket ret = null;
        String extensionCheck = null;
        if (this.returnType == ReturnType.DISK) {
            String name;
            int idx;
            this.targetFile = message.diskFile;
            if (!core.allowDownloadTo(this.targetFile)) {
                throw new MessageInvalidException(24, "Not allowed to download to " + this.targetFile, this.identifier, this.global);
            }
            if (!handler.allowDDAFrom(this.targetFile, true)) {
                throw new MessageInvalidException(25, "Not allowed to download to " + this.targetFile + ". You might need to do a " + "TestDDARequest" + " first.", this.identifier, this.global);
            }
            ret = new FileBucket(this.targetFile, false, true, false, false);
            if (this.fctx.filterData && (idx = (name = this.targetFile.getName()).lastIndexOf(46)) != -1 && ++idx != name.length()) {
                extensionCheck = name.substring(idx);
            }
        } else if (this.returnType == ReturnType.NONE) {
            this.targetFile = null;
            ret = new NullBucket();
        } else {
            this.targetFile = null;
            ret = null;
        }
        this.extensionCheck = extensionCheck;
        this.initialMetadata = message.getInitialMetadata();
        try {
            this.getter = this.makeGetter(core, ret);
        }
        catch (IOException e) {
            Logger.error(this, "Cannot create bucket for temporary storage: " + e, (Throwable)e);
            throw new MessageInvalidException(17, "Cannot create bucket for temporary storage (out of disk space?): " + e, this.identifier, this.global);
        }
    }

    private ClientGetter makeGetter(Bucket ret) throws IOException {
        return this.makeGetter(null, ret);
    }

    private ClientGetter makeGetter(NodeClientCore core, Bucket ret) throws IOException {
        if (this.binaryBlob && ret == null) {
            ret = core.clientContext.getBucketFactory(this.persistence == ClientRequest.Persistence.FOREVER).makeBucket(this.fctx.maxOutputLength);
        }
        return new ClientGetter(this, this.uri, this.fctx, this.priorityClass, this.binaryBlob ? new NullBucket() : ret, this.binaryBlob ? new BinaryBlobWriter(ret) : null, false, this.initialMetadata, this.extensionCheck);
    }

    protected ClientGet() {
        this.fctx = null;
        this.getter = null;
        this.returnType = null;
        this.targetFile = null;
        this.binaryBlob = false;
        this.extensionCheck = null;
        this.initialMetadata = null;
    }

    @Override
    void register(boolean noTags) throws IdentifierCollisionException {
        if (this.client != null) assert (this.persistence == this.client.persistence);
        if (this.persistence != ClientRequest.Persistence.CONNECTION) {
            this.client.register(this);
        }
        if (this.persistence != ClientRequest.Persistence.CONNECTION && !noTags) {
            FCPMessage msg = this.persistentTagMessage();
            this.client.queueClientRequestMessage(msg, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ClientContext context) {
        try {
            RequestStatusCache cache;
            Object msg;
            ClientGet clientGet = this;
            synchronized (clientGet) {
                if (this.finished) {
                    return;
                }
            }
            this.getter.start(context);
            if (this.persistence != ClientRequest.Persistence.CONNECTION && !this.finished) {
                msg = this.persistentTagMessage();
                this.client.queueClientRequestMessage((FCPMessage)msg, 0);
            }
            msg = this;
            synchronized (msg) {
                this.started = true;
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStarted(this.identifier, true);
            }
        }
        catch (FetchException e) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.started = true;
            }
            this.onFailure(e, null);
        }
        catch (Throwable t) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.started = true;
            }
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, t), null);
        }
    }

    @Override
    public void onLostConnection(ClientContext context) {
        if (this.persistence == ClientRequest.Persistence.CONNECTION) {
            this.cancel(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(FetchResult result, ClientGetter state) {
        Logger.minor(this, "Succeeded: " + this.identifier);
        Bucket data = this.binaryBlob ? state.getBlobBucket() : result.asBucket();
        ClientGet clientGet = this;
        synchronized (clientGet) {
            if (this.succeeded) {
                Logger.error(this, "onSuccess called twice for " + this + " (" + this.identifier + ')');
                return;
            }
            this.started = true;
            this.foundDataMimeType = !this.binaryBlob ? result.getMimeType() : "application/x-freenet-binary-blob";
            this.completionTime = System.currentTimeMillis();
            this.progressPending = null;
            this.foundDataLength = data.size();
            this.succeeded = true;
            this.finished = true;
            if (this.returnType == ReturnType.DIRECT) {
                this.returnBucketDirect = data;
            }
        }
        this.trySendDataFoundOrGetFailed(null, null);
        this.trySendAllDataMessage(null, null);
        this.finish();
        if (this.client != null) {
            this.client.notifySuccess(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuccessForMigration(ClientContext context, long completionTime, Bucket data) throws ResumeFailedException {
        ClientGet clientGet = this;
        synchronized (clientGet) {
            this.succeeded = true;
            this.started = true;
            this.finished = true;
            this.completionTime = completionTime;
            if (this.returnType != ReturnType.NONE) {
                if (this.returnType == ReturnType.DISK) {
                    if (!this.targetFile.exists() || this.targetFile.length() != this.foundDataLength) {
                        throw new ResumeFailedException("Success but target file doesn't exist or isn't valid");
                    }
                } else if (this.returnType == ReturnType.DIRECT) {
                    this.returnBucketDirect = data;
                    if (this.returnBucketDirect.size() != this.foundDataLength) {
                        throw new ResumeFailedException("Success but temporary data bucket doesn't exist or isn't valid");
                    }
                }
            }
        }
    }

    private void trySendDataFoundOrGetFailed(FCPConnectionOutputHandler handler, String listRequestIdentifier) {
        FCPMessage msg = this.succeeded ? new DataFoundMessage(this.foundDataLength, this.foundDataMimeType, this.identifier, this.global, this.startupTime, this.completionTime != 0L ? this.completionTime : System.currentTimeMillis()) : this.getFailedMessage;
        if (handler == null && this.persistence == ClientRequest.Persistence.CONNECTION) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(FCPMessage.withListRequestIdentifier(msg, listRequestIdentifier));
        } else {
            this.client.queueClientRequestMessage(FCPMessage.withListRequestIdentifier(msg, listRequestIdentifier), 0);
        }
    }

    private synchronized AllDataMessage getAllDataMessage() {
        if (this.returnType != ReturnType.DIRECT) {
            return null;
        }
        AllDataMessage msg = new AllDataMessage(this.returnBucketDirect, this.identifier, this.global, this.startupTime, this.completionTime, this.foundDataMimeType);
        if (this.persistence == ClientRequest.Persistence.CONNECTION) {
            msg.setFreeOnSent();
        }
        return msg;
    }

    private void trySendAllDataMessage(FCPConnectionOutputHandler handler, String listRequestIdentifier) {
        FCPMessage allData;
        if (this.persistence == ClientRequest.Persistence.CONNECTION && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null && (allData = FCPMessage.withListRequestIdentifier(this.getAllDataMessage(), listRequestIdentifier)) != null) {
            handler.queue(allData);
        }
    }

    private void queueProgressMessageInner(FCPMessage msg, FCPConnectionOutputHandler handler, int verbosityMask) {
        if (this.persistence == ClientRequest.Persistence.CONNECTION && handler == null) {
            handler = this.origHandler.outputHandler;
        }
        if (handler != null) {
            handler.queue(msg);
        } else {
            this.client.queueClientRequestMessage(msg, verbosityMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPendingMessages(FCPConnectionOutputHandler handler, String listRequestIdentifier, boolean includePersistentRequest, boolean includeData, boolean onlyData) {
        ExpectedHashes expectedHashes;
        CompatibilityMode cmsg;
        if (!onlyData) {
            if (includePersistentRequest) {
                FCPMessage msg = this.persistentTagMessage();
                handler.queue(FCPMessage.withListRequestIdentifier(msg, listRequestIdentifier));
            }
            if (this.progressPending != null) {
                handler.queue(FCPMessage.withListRequestIdentifier(this.progressPending, listRequestIdentifier));
            }
            if (this.sentToNetwork) {
                handler.queue(FCPMessage.withListRequestIdentifier(new SendingToNetworkMessage(this.identifier, this.global), listRequestIdentifier));
            }
            if (this.finished) {
                this.trySendDataFoundOrGetFailed(handler, listRequestIdentifier);
            }
        } else if (this.returnType != ReturnType.DIRECT) {
            ProtocolErrorMessage msg = new ProtocolErrorMessage(36, false, "No AllData", this.identifier, this.global);
            handler.queue(msg);
            return;
        }
        if (includeData) {
            this.trySendAllDataMessage(handler, listRequestIdentifier);
        }
        ExpectedMIME mimeMsg = null;
        ExpectedDataLength lengthMsg = null;
        ClientGet clientGet = this;
        synchronized (clientGet) {
            cmsg = new CompatibilityMode(this.identifier, this.global, this.compatMode);
            expectedHashes = this.expectedHashes;
            if (this.foundDataMimeType != null) {
                mimeMsg = new ExpectedMIME(this.identifier, this.global, this.foundDataMimeType);
            }
            if (this.foundDataLength > 0L) {
                lengthMsg = new ExpectedDataLength(this.identifier, this.global, this.foundDataLength);
            }
        }
        handler.queue(FCPMessage.withListRequestIdentifier(cmsg, listRequestIdentifier));
        if (expectedHashes != null) {
            handler.queue(FCPMessage.withListRequestIdentifier(expectedHashes, listRequestIdentifier));
        }
        if (mimeMsg != null) {
            handler.queue(FCPMessage.withListRequestIdentifier(mimeMsg, listRequestIdentifier));
        }
        if (lengthMsg != null) {
            handler.queue(FCPMessage.withListRequestIdentifier(lengthMsg, listRequestIdentifier));
        }
    }

    private FCPMessage persistentTagMessage() {
        return new PersistentGet(this.identifier, this.uri, this.verbosity, this.priorityClass, this.returnType, this.persistence, this.targetFile, this.clientToken, this.client.isGlobalQueue, this.started, this.fctx.maxNonSplitfileRetries, this.binaryBlob, this.fctx.maxOutputLength, this.isRealTime());
    }

    private boolean isRealTime() {
        if (this.lowLevelClient == null) {
            Logger.error(this, "lowLevelClient == null", (Throwable)new Exception("error"));
            return false;
        }
        return this.lowLevelClient.realTimeFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(FetchException e, ClientGetter state) {
        if (this.finished) {
            return;
        }
        ClientGet clientGet = this;
        synchronized (clientGet) {
            if (e.expectedSize != 0L) {
                this.foundDataLength = e.expectedSize;
            }
            if (e.getExpectedMimeType() != null) {
                this.foundDataMimeType = e.getExpectedMimeType();
            }
            this.succeeded = false;
            this.getFailedMessage = new GetFailedMessage(e, this.identifier, this.global);
            this.finished = true;
            this.started = true;
            this.completionTime = System.currentTimeMillis();
        }
        if (logMINOR) {
            Logger.minor(this, "Caught " + e, (Throwable)e);
        }
        this.trySendDataFoundOrGetFailed(null, null);
        this.finish();
        if (this.client != null) {
            this.client.notifyFailure(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestWasRemoved(ClientContext context) {
        if (!this.finished) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                this.succeeded = false;
                this.finished = true;
                FetchException cancelled = new FetchException(FetchException.FetchExceptionMode.CANCELLED);
                this.getFailedMessage = new GetFailedMessage(cancelled, this.identifier, this.global);
            }
            this.trySendDataFoundOrGetFailed(null, null);
        }
        PersistentRequestRemovedMessage msg = new PersistentRequestRemovedMessage(this.getIdentifier(), this.global);
        if (this.persistence != ClientRequest.Persistence.CONNECTION) {
            this.client.queueClientRequestMessage(msg, 0);
        }
        this.freeData();
        super.requestWasRemoved(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(ClientEvent ce, ClientContext context) {
        FCPMessage progress;
        int verbosityMask;
        if (logMINOR) {
            Logger.minor(this, "Receiving " + ce + " on " + this);
        }
        if (ce instanceof SplitfileProgressEvent) {
            RequestStatusCache cache;
            verbosityMask = 1;
            ClientGet clientGet = this;
            synchronized (clientGet) {
                progress = this.progressPending = new SimpleProgressMessage(this.identifier, this.global, (SplitfileProgressEvent)ce);
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                cache.updateStatus(this.identifier, this.progressPending.getEvent());
            }
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
        } else if (ce instanceof SendingToNetworkEvent) {
            verbosityMask = 2;
            ClientGet cache = this;
            synchronized (cache) {
                this.sentToNetwork = true;
            }
            if ((this.verbosity & verbosityMask) == 0) {
                return;
            }
            progress = new SendingToNetworkMessage(this.identifier, this.global);
        } else {
            if (ce instanceof SplitfileCompatibilityModeEvent) {
                this.handleCompatibilityMode((SplitfileCompatibilityModeEvent)ce, context);
                return;
            }
            if (ce instanceof ExpectedHashesEvent) {
                ExpectedHashesEvent event = (ExpectedHashesEvent)ce;
                ClientGet clientGet = this;
                synchronized (clientGet) {
                    if (this.expectedHashes != null) {
                        Logger.error(this, "Got a new ExpectedHashes", (Throwable)new Exception("debug"));
                        return;
                    }
                    this.expectedHashes = new ExpectedHashes(event, this.identifier, this.global);
                    progress = this.expectedHashes;
                }
                verbosityMask = 8;
                if ((this.verbosity & verbosityMask) == 0) {
                    return;
                }
            } else if (ce instanceof ExpectedMIMEEvent) {
                RequestStatusCache cache;
                ExpectedMIMEEvent event = (ExpectedMIMEEvent)ce;
                ClientGet clientGet = this;
                synchronized (clientGet) {
                    this.foundDataMimeType = event.expectedMIMEType;
                }
                if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                    cache.updateExpectedMIME(this.identifier, this.foundDataMimeType);
                }
                verbosityMask = 32;
                progress = new ExpectedMIME(this.identifier, this.global, event.expectedMIMEType);
                if ((this.verbosity & verbosityMask) == 0) {
                    return;
                }
            } else if (ce instanceof ExpectedFileSizeEvent) {
                ExpectedFileSizeEvent event = (ExpectedFileSizeEvent)ce;
                Object cache = this;
                synchronized (cache) {
                    this.foundDataLength = event.expectedSize;
                }
                if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                    ((RequestStatusCache)cache).updateExpectedDataLength(this.identifier, this.foundDataLength);
                }
                if ((this.verbosity & (verbosityMask = 64)) == 0) {
                    return;
                }
                progress = new ExpectedDataLength(this.identifier, this.global, event.expectedSize);
            } else if (ce instanceof EnterFiniteCooldownEvent) {
                verbosityMask = 128;
                if ((this.verbosity & verbosityMask) == 0) {
                    return;
                }
                EnterFiniteCooldownEvent event = (EnterFiniteCooldownEvent)ce;
                progress = new EnterFiniteCooldown(this.identifier, this.global, event.wakeupTime);
            } else {
                Logger.error(this, "Unknown event " + ce);
                return;
            }
        }
        this.queueProgressMessageInner(progress, null, verbosityMask);
    }

    private void handleCompatibilityMode(final SplitfileCompatibilityModeEvent ce, ClientContext context) {
        if (this.persistence == ClientRequest.Persistence.FOREVER && context.jobRunner.hasLoaded()) {
            try {
                context.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        ClientGet.this.innerHandleCompatibilityMode(ce, context);
                        return false;
                    }
                }, NativeThread.HIGH_PRIORITY);
            }
            catch (PersistenceDisabledException persistenceDisabledException) {}
        } else {
            this.innerHandleCompatibilityMode(ce, context);
        }
    }

    private void innerHandleCompatibilityMode(SplitfileCompatibilityModeEvent ce, ClientContext context) {
        RequestStatusCache cache;
        this.compatMode.merge(ce.minCompatibilityMode, ce.maxCompatibilityMode, ce.splitfileCryptoKey, ce.dontCompress, ce.bottomLayer);
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            cache.updateDetectedCompatModes(this.identifier, this.compatMode.getModes(), this.compatMode.getCryptoKey(), this.compatMode.dontCompress());
        }
        if ((this.verbosity & 4) != 0) {
            this.queueProgressMessageInner(new CompatibilityMode(this.identifier, this.global, this.compatMode), null, 4);
        }
    }

    @Override
    protected ClientRequester getClientRequest() {
        return this.getter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeData() {
        Bucket data;
        ClientGet clientGet = this;
        synchronized (clientGet) {
            data = this.returnBucketDirect;
            this.returnBucketDirect = null;
        }
        if (data != null) {
            data.free();
        }
        if (this.initialMetadata != null) {
            this.initialMetadata.free();
        }
    }

    @Override
    public boolean hasSucceeded() {
        return this.succeeded;
    }

    public boolean isDirect() {
        return this.returnType == ReturnType.DIRECT;
    }

    public boolean isToDisk() {
        return this.returnType == ReturnType.DISK;
    }

    public FreenetURI getURI() {
        return this.uri;
    }

    public long getDataSize() {
        if (this.foundDataLength > 0L) {
            return this.foundDataLength;
        }
        return -1L;
    }

    public String getMIMEType() {
        if (this.foundDataMimeType != null) {
            return this.foundDataMimeType;
        }
        return null;
    }

    public File getDestFilename() {
        return this.targetFile;
    }

    @Override
    public double getSuccessFraction() {
        if (this.progressPending != null) {
            return this.progressPending.getFraction();
        }
        return -1.0;
    }

    @Override
    public double getTotalBlocks() {
        if (this.progressPending != null) {
            return this.progressPending.getTotalBlocks();
        }
        return 1.0;
    }

    @Override
    public double getMinBlocks() {
        if (this.progressPending != null) {
            return this.progressPending.getMinBlocks();
        }
        return 1.0;
    }

    @Override
    public double getFailedBlocks() {
        if (this.progressPending != null) {
            return this.progressPending.getFailedBlocks();
        }
        return 0.0;
    }

    @Override
    public double getFatalyFailedBlocks() {
        if (this.progressPending != null) {
            return this.progressPending.getFatalyFailedBlocks();
        }
        return 0.0;
    }

    @Override
    public double getFetchedBlocks() {
        if (this.progressPending != null) {
            return this.progressPending.getFetchedBlocks();
        }
        return 0.0;
    }

    public InsertContext.CompatibilityMode[] getCompatibilityMode() {
        return this.compatMode.getModes();
    }

    public boolean getDontCompress() {
        return this.compatMode.dontCompress();
    }

    public byte[] getOverriddenSplitfileCryptoKey() {
        return this.compatMode.getCryptoKey();
    }

    @Override
    public String getFailureReason(boolean longDescription) {
        if (this.getFailedMessage == null) {
            return null;
        }
        String s = this.getFailedMessage.getShortFailedMessage();
        if (longDescription && this.getFailedMessage.extraDescription != null) {
            s = s + ": " + this.getFailedMessage.extraDescription;
        }
        return s;
    }

    GetFailedMessage getFailureMessage() {
        if (this.getFailedMessage == null) {
            return null;
        }
        return this.getFailedMessage;
    }

    public FetchException.FetchExceptionMode getFailureReasonCode() {
        if (this.getFailedMessage == null) {
            return null;
        }
        return this.getFailedMessage.code;
    }

    @Override
    public boolean isTotalFinalized() {
        if (this.finished && this.succeeded) {
            return true;
        }
        if (this.progressPending == null) {
            return false;
        }
        return this.progressPending.isTotalFinalized();
    }

    public Bucket getBucket() {
        return this.makeBucket(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket makeBucket(boolean readOnly) {
        if (this.returnType == ReturnType.DIRECT) {
            ClientGet clientGet = this;
            synchronized (clientGet) {
                return this.returnBucketDirect;
            }
        }
        if (this.returnType == ReturnType.DISK) {
            return new FileBucket(this.targetFile, readOnly, false, false, false);
        }
        return null;
    }

    @Override
    public boolean canRestart() {
        if (!this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.identifier);
            return false;
        }
        if (this.succeeded) {
            Logger.minor(this, "Cannot restart because succeeded for " + this.identifier);
            return false;
        }
        return this.getter.canRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restart(ClientContext context, boolean disableFilterData) {
        Object cache;
        if (!this.canRestart()) {
            return false;
        }
        FreenetURI redirect = null;
        ClientGet clientGet = this;
        synchronized (clientGet) {
            this.finished = false;
            if (this.persistence == ClientRequest.Persistence.FOREVER && this.getFailedMessage != null) {
                if (this.getFailedMessage.redirectURI != null) {
                    redirect = this.getFailedMessage.redirectURI;
                }
            } else if (this.getFailedMessage != null) {
                redirect = this.getFailedMessage.redirectURI;
            }
            this.getFailedMessage = null;
            this.progressPending = null;
            this.compatMode = new CompatibilityAnalyser();
            this.expectedHashes = null;
            this.started = false;
            if (disableFilterData) {
                this.fctx.filterData = false;
            }
        }
        if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
            ((RequestStatusCache)cache).updateStarted(this.identifier, redirect);
        }
        try {
            if (this.getter.restart(redirect, this.fctx.filterData, context)) {
                cache = this;
                synchronized (cache) {
                    if (redirect != null) {
                        this.uri = redirect;
                    }
                    this.started = true;
                }
            }
            if (this.client != null && (cache = this.client.getRequestStatusCache()) != null) {
                ((RequestStatusCache)cache).updateStarted(this.identifier, true);
            }
            return true;
        }
        catch (FetchException e) {
            this.onFailure(e, null);
            return false;
        }
    }

    public synchronized boolean hasPermRedirect() {
        return this.getFailedMessage != null && this.getFailedMessage.redirectURI != null;
    }

    public boolean filterData() {
        return this.fctx.filterData;
    }

    @Override
    synchronized RequestStatus getStatus() {
        Bucket shadow;
        boolean totalFinalized = false;
        int total = 0;
        int min = 0;
        int fetched = 0;
        int fatal = 0;
        int failed = 0;
        Date latestSuccess = CurrentTimeUTC.get();
        Date latestFailure = null;
        if (this.progressPending != null) {
            totalFinalized = this.progressPending.isTotalFinalized();
            total = (int)this.progressPending.getTotalBlocks();
            min = (int)this.progressPending.getMinBlocks();
            fetched = (int)this.progressPending.getFetchedBlocks();
            latestSuccess = this.progressPending.getLatestSuccess();
            fatal = (int)this.progressPending.getFatalyFailedBlocks();
            failed = (int)this.progressPending.getFailedBlocks();
            latestFailure = this.progressPending.getLatestFailure();
        }
        if (this.finished && this.succeeded) {
            totalFinalized = true;
        }
        FetchException.FetchExceptionMode failureCode = null;
        String failureReasonShort = null;
        String failureReasonLong = null;
        if (this.getFailedMessage != null) {
            failureCode = this.getFailedMessage.code;
            failureReasonShort = this.getFailedMessage.getShortFailedMessage();
            failureReasonShort = this.getFailedMessage.getLongFailedMessage();
        }
        String mimeType = this.foundDataMimeType;
        long dataSize = this.foundDataLength;
        File target = this.getDestFilename();
        if (target != null) {
            target = new File(target.getPath());
        }
        Bucket bucket = shadow = this.finished && this.succeeded ? this.getBucket() : null;
        if (shadow != null) {
            if (dataSize != shadow.size()) {
                Logger.error(this, "Size of downloaded data has changed: " + dataSize + " -> " + shadow.size() + " on " + shadow);
                shadow = null;
            } else {
                shadow = shadow.createShadow();
            }
        }
        boolean filterData = this.fctx.filterData;
        boolean overriddenDataType = this.fctx.overrideMIME != null || this.fctx.charset != null;
        return new DownloadRequestStatus(this.identifier, this.persistence, this.started, this.finished, this.succeeded, total, min, fetched, latestSuccess, fatal, failed, latestFailure, totalFinalized, this.priorityClass, failureCode, mimeType, dataSize, target, this.getCompatibilityMode(), this.getOverriddenSplitfileCryptoKey(), this.getURI(), failureReasonShort, failureReasonLong, overriddenDataType, shadow, filterData, this.getDontCompress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getClientDetail(DataOutputStream dos, ChecksumChecker checker) throws IOException {
        if (this.persistence != ClientRequest.Persistence.FOREVER) {
            return;
        }
        super.getClientDetail(dos, checker);
        dos.writeLong(7427662184943854324L);
        dos.writeInt(1);
        dos.writeUTF(this.uri.toString());
        dos.writeShort(this.returnType.code);
        if (this.returnType == ReturnType.DISK) {
            dos.writeUTF(this.targetFile.toString());
        }
        dos.writeBoolean(this.binaryBlob);
        try (DataOutputStream innerDOS = new DataOutputStream(checker.checksumWriterWithLength(dos, new ArrayBucketFactory()));){
            this.fctx.writeTo(innerDOS);
        }
        if (this.extensionCheck != null) {
            dos.writeBoolean(true);
            dos.writeUTF(this.extensionCheck);
        } else {
            dos.writeBoolean(false);
        }
        if (this.initialMetadata != null) {
            dos.writeBoolean(true);
            this.initialMetadata.storeTo(innerDOS);
        } else {
            dos.writeBoolean(false);
        }
        ClientGet clientGet = this;
        synchronized (clientGet) {
            if (this.finished) {
                dos.writeBoolean(this.succeeded);
                this.writeTransientProgressFields(dos);
                if (this.succeeded) {
                    if (this.returnType == ReturnType.DIRECT) {
                        innerDOS = new DataOutputStream(checker.checksumWriterWithLength(dos, new ArrayBucketFactory()));
                        try {
                            this.returnBucketDirect.storeTo(innerDOS);
                        }
                        finally {
                            innerDOS.close();
                        }
                    }
                } else {
                    innerDOS = new DataOutputStream(checker.checksumWriterWithLength(dos, new ArrayBucketFactory()));
                    try {
                        this.getFailedMessage.writeTo(innerDOS);
                    }
                    finally {
                        innerDOS.close();
                    }
                }
                return;
            }
        }
        innerDOS = new DataOutputStream(checker.checksumWriterWithLength(dos, new ArrayBucketFactory()));
        try {
            if (this.getter.writeTrivialProgress(innerDOS)) {
                this.writeTransientProgressFields(innerDOS);
            }
        }
        finally {
            innerDOS.close();
        }
    }

    public static ClientRequest restartFrom(DataInputStream dis, RequestIdentifier reqID, ClientContext context, ChecksumChecker checker) throws StorageFormatException, IOException, ResumeFailedException {
        return new ClientGet(dis, reqID, context, checker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientGet(DataInputStream dis, RequestIdentifier reqID, ClientContext context, ChecksumChecker checker) throws IOException, StorageFormatException, ResumeFailedException {
        super(dis, reqID, context);
        DataInputStream innerDIS;
        ClientGetter getter = null;
        long magic = dis.readLong();
        if (magic != 7427662184943854324L) {
            throw new StorageFormatException("Bad magic for request");
        }
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version " + version);
        }
        String s = dis.readUTF();
        try {
            this.uri = new FreenetURI(s);
        }
        catch (MalformedURLException e) {
            throw new StorageFormatException("Bad URI");
        }
        short r = dis.readShort();
        try {
            this.returnType = ReturnType.getByCode(r);
        }
        catch (IllegalArgumentException e) {
            throw new StorageFormatException("Bad return type " + r);
        }
        this.targetFile = this.returnType == ReturnType.DISK ? new File(dis.readUTF()) : null;
        this.binaryBlob = dis.readBoolean();
        FetchContext fctx = null;
        try {
            innerDIS = new DataInputStream(checker.checksumReaderWithLength(dis, context.tempBucketFactory, 65536L));
            try {
                fctx = new FetchContext(innerDIS);
            }
            catch (IOException e) {
                Logger.error(this, "Unable to read fetch settings, will use default settings: " + e, (Throwable)e);
            }
            finally {
                innerDIS.close();
            }
        }
        catch (ChecksumFailedException e) {
            Logger.error(this, "Unable to read fetch settings, will use default settings");
        }
        if (fctx == null) {
            fctx = context.getDefaultPersistentFetchContext();
        }
        this.fctx = fctx;
        fctx.eventProducer.addEventListener(this);
        this.extensionCheck = dis.readBoolean() ? dis.readUTF() : null;
        this.initialMetadata = dis.readBoolean() ? BucketTools.restoreFrom(dis, context.persistentFG, context.persistentFileTracker, context.getPersistentMasterSecret()) : null;
        if (this.finished) {
            this.succeeded = dis.readBoolean();
            this.readTransientProgressFields(dis);
            if (this.succeeded) {
                if (this.returnType == ReturnType.DIRECT) {
                    try {
                        innerDIS = new DataInputStream(checker.checksumReaderWithLength(dis, context.tempBucketFactory, 65536L));
                        try {
                            this.returnBucketDirect = BucketTools.restoreFrom(innerDIS, context.persistentFG, context.persistentFileTracker, context.getPersistentMasterSecret());
                        }
                        catch (IOException e) {
                            Logger.error(this, "Failed to restore completed download-to-temp-space request, restarting instead");
                            this.returnBucketDirect = null;
                            this.succeeded = false;
                            this.finished = false;
                        }
                        finally {
                            innerDIS.close();
                        }
                    }
                    catch (ChecksumFailedException e) {
                        Logger.error(this, "Failed to restore completed download-to-temp-space request, restarting instead");
                        this.returnBucketDirect = null;
                        this.succeeded = false;
                        this.finished = false;
                    }
                    catch (StorageFormatException e) {
                        Logger.error(this, "Failed to restore completed download-to-temp-space request, restarting instead");
                        this.returnBucketDirect = null;
                        this.succeeded = false;
                        this.finished = false;
                    }
                }
            } else {
                try {
                    innerDIS = new DataInputStream(checker.checksumReaderWithLength(dis, context.tempBucketFactory, 65536L));
                    try {
                        this.getFailedMessage = new GetFailedMessage(innerDIS, reqID, this.foundDataLength, this.foundDataMimeType);
                        this.started = true;
                    }
                    catch (IOException e) {
                        Logger.error(this, "Unable to restore reason for failure, restarting request : " + e, (Throwable)e);
                        this.finished = false;
                        this.getFailedMessage = null;
                    }
                    finally {
                        innerDIS.close();
                    }
                }
                catch (ChecksumFailedException e) {
                    Logger.error(this, "Unable to restore reason for failure, restarting request");
                    this.finished = false;
                    this.getFailedMessage = null;
                }
            }
        } else {
            getter = this.makeGetter(this.makeBucket(false));
            try {
                innerDIS = new DataInputStream(checker.checksumReaderWithLength(dis, context.tempBucketFactory, 65536L));
                try {
                    if (getter.resumeFromTrivialProgress(innerDIS, context)) {
                        this.readTransientProgressFields(innerDIS);
                    }
                }
                catch (IOException e) {
                    Logger.error(this, "Unable to restore splitfile, restarting: " + e);
                }
                finally {
                    innerDIS.close();
                }
            }
            catch (ChecksumFailedException e) {
                Logger.error(this, "Unable to restore splitfile, restarting (checksum failed)");
            }
        }
        if (this.compatMode == null) {
            this.compatMode = new CompatibilityAnalyser();
        }
        if (getter == null) {
            getter = this.makeGetter(this.makeBucket(false));
        }
        this.getter = getter;
    }

    private void readTransientProgressFields(DataInputStream dis) throws IOException, StorageFormatException {
        this.foundDataLength = dis.readLong();
        this.foundDataMimeType = dis.readBoolean() ? dis.readUTF() : null;
        this.compatMode = new CompatibilityAnalyser(dis);
        HashResult[] hashes = HashResult.readHashes(dis);
        this.expectedHashes = hashes == null || hashes.length == 0 ? null : new ExpectedHashes(hashes, this.identifier, this.global);
    }

    private synchronized void writeTransientProgressFields(DataOutputStream dos) throws IOException {
        dos.writeLong(this.foundDataLength);
        if (this.foundDataMimeType != null) {
            dos.writeBoolean(true);
            dos.writeUTF(this.foundDataMimeType);
        } else {
            dos.writeBoolean(false);
        }
        this.compatMode.writeTo(dos);
        HashResult.write(this.expectedHashes == null ? null : this.expectedHashes.hashes, dos);
    }

    @Override
    protected void innerResume(ClientContext context) throws ResumeFailedException {
        if (this.returnBucketDirect != null) {
            this.returnBucketDirect.onResume(context);
        }
        if (this.initialMetadata != null) {
            this.initialMetadata.onResume(context);
        }
        if (this.foundDataLength <= 0L) {
            this.foundDataLength = this.getter.expectedSize();
        }
        if (this.foundDataMimeType == null) {
            this.foundDataMimeType = this.getter.expectedMIME();
        }
    }

    @Override
    RequestIdentifier.RequestType getType() {
        return RequestIdentifier.RequestType.GET;
    }

    @Override
    public boolean fullyResumed() {
        return this.getter != null && this.getter.resumedFetcher();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        returnTypeByCode = new HashMap<Short, ReturnType>();
    }

    public static enum ReturnType {
        DIRECT(0),
        NONE(1),
        DISK(2),
        CHUNKED(3);

        final short code;

        private ReturnType(short code) {
            if (returnTypeByCode.containsKey(code)) {
                throw new Error("Duplicate");
            }
            returnTypeByCode.put(code, this);
            this.code = code;
        }

        public static ReturnType getByCode(short x) {
            ReturnType u = (ReturnType)((Object)returnTypeByCode.get(x));
            if (u == null) {
                throw new IllegalArgumentException();
            }
            return u;
        }
    }
}

