/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.FetchException;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.l10n.NodeL10n;
import freenet.support.HTMLEncoder;

public class UnknownContentTypeException
extends UnsafeContentTypeException {
    private static final long serialVersionUID = -1L;
    final String type;
    final String encodedType;

    public UnknownContentTypeException(String typeName) {
        this.type = typeName;
        this.encodedType = HTMLEncoder.encode(this.type);
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getHTMLEncodedTitle() {
        return UnknownContentTypeException.l10n("title", "type", this.encodedType);
    }

    @Override
    public String getRawTitle() {
        return UnknownContentTypeException.l10n("title", "type", this.type);
    }

    @Override
    public String getMessage() {
        return UnknownContentTypeException.l10n("explanation", "type", this.type);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("UnknownContentTypeException." + key, pattern, value);
    }

    @Override
    public FetchException.FetchExceptionMode getFetchErrorCode() {
        return FetchException.FetchExceptionMode.CONTENT_VALIDATION_UNKNOWN_MIME;
    }
}

