/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.NullClientCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.USKCallback;
import freenet.client.async.USKFetcher;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherTag;
import freenet.client.async.USKFetcherWrapper;
import freenet.client.async.USKRetriever;
import freenet.client.async.USKRetrieverCallback;
import freenet.client.async.USKSparseProxyCallback;
import freenet.clients.http.FProxyToadlet;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestClientBuilder;
import freenet.support.Executor;
import freenet.support.LRUMap;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NullBucket;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;

public class USKManager {
    private static volatile boolean logDEBUG;
    private static volatile boolean logMINOR;
    static RequestClient rcRT;
    static RequestClient rcBulk;
    final Map<USK, Long> latestKnownGoodByClearUSK;
    final Map<USK, Long> latestSlotByClearUSK;
    final Map<USK, USKCallback[]> subscribersByClearUSK;
    final Map<USK, USKFetcher> backgroundFetchersByClearUSK;
    final LRUMap<USK, USKFetcher> temporaryBackgroundFetchersLRU;
    final WeakHashMap<USK, Long> temporaryBackgroundFetchersPrefetch;
    final FetchContext backgroundFetchContext;
    final FetchContext backgroundFetchContextIgnoreDBR;
    final FetchContext realFetchContext;
    final Executor executor;
    private ClientContext context;
    static final long PREFETCH_DELAY;
    private final Runnable prefetchChecker = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logDEBUG) {
                Logger.debug(this, "Running prefetch checker...");
            }
            ArrayList<USK> toFetch = null;
            long now = System.currentTimeMillis();
            boolean empty = true;
            USKManager uSKManager = USKManager.this;
            synchronized (uSKManager) {
                for (Map.Entry<USK, Long> entry : USKManager.this.temporaryBackgroundFetchersPrefetch.entrySet()) {
                    empty = false;
                    if (entry.getValue() > 0L && now - entry.getValue() >= PREFETCH_DELAY) {
                        if (toFetch == null) {
                            toFetch = new ArrayList<USK>();
                        }
                        USK clear = entry.getKey();
                        long l = USKManager.this.lookupLatestSlot(clear);
                        if (USKManager.this.lookupKnownGood(clear) < l) {
                            toFetch.add(clear.copy(l));
                        }
                        entry.setValue(-1L);
                        continue;
                    }
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not prefetching: " + entry.getKey() + " : " + entry.getValue());
                }
            }
            if (toFetch == null) {
                return;
            }
            for (final USK key : toFetch) {
                final long l = key.suggestedEdition;
                if (logMINOR) {
                    Logger.minor(this, "Prefetching content for background fetch for edition " + l + " on " + key);
                }
                FetchContext fctx = new FetchContext(USKManager.this.realFetchContext, 0);
                ClientGetter get = new ClientGetter(new ClientGetCallback(){

                    @Override
                    public void onFailure(FetchException e, ClientGetter state) {
                        if (e.newURI != null) {
                            if (logMINOR) {
                                Logger.minor(this, "Prefetch succeeded with redirect for " + key);
                            }
                            USKManager.this.updateKnownGood(key, l, USKManager.this.context);
                            return;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Prefetch failed later: " + e + " for " + key, (Throwable)e);
                        }
                    }

                    @Override
                    public void onSuccess(FetchResult result, ClientGetter state) {
                        if (logMINOR) {
                            Logger.minor(this, "Prefetch succeeded for " + key);
                        }
                        result.asBucket().free();
                        USKManager.this.updateKnownGood(key, l, USKManager.this.context);
                    }

                    @Override
                    public void onResume(ClientContext context) {
                    }

                    @Override
                    public RequestClient getRequestClient() {
                        return rcBulk;
                    }
                }, key.getURI().sskForUSK(), fctx, 3, new NullBucket(), null, null);
                try {
                    get.start(USKManager.this.context);
                }
                catch (FetchException e) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Prefetch failed: " + e, (Throwable)e);
                }
            }
            if (!empty) {
                USKManager.this.schedulePrefetchChecker();
            }
        }
    };

    public USKManager(NodeClientCore core) {
        HighLevelSimpleClient client = core.makeClient((short)3, false, false);
        client.setMaxIntermediateLength(FProxyToadlet.MAX_LENGTH_NO_PROGRESS);
        client.setMaxLength(FProxyToadlet.MAX_LENGTH_NO_PROGRESS);
        this.backgroundFetchContext = client.getFetchContext();
        this.backgroundFetchContext.followRedirects = false;
        this.backgroundFetchContextIgnoreDBR = this.backgroundFetchContext.clone();
        this.backgroundFetchContextIgnoreDBR.ignoreUSKDatehints = true;
        this.realFetchContext = client.getFetchContext();
        this.latestKnownGoodByClearUSK = new TreeMap<USK, Long>(USK.FAST_COMPARATOR);
        this.latestSlotByClearUSK = new TreeMap<USK, Long>(USK.FAST_COMPARATOR);
        this.subscribersByClearUSK = new TreeMap<USK, USKCallback[]>(USK.FAST_COMPARATOR);
        this.backgroundFetchersByClearUSK = new TreeMap<USK, USKFetcher>(USK.FAST_COMPARATOR);
        this.temporaryBackgroundFetchersLRU = LRUMap.createSafeMap(USK.FAST_COMPARATOR);
        this.temporaryBackgroundFetchersPrefetch = new WeakHashMap();
        this.executor = core.getExecutor();
    }

    public void init(ClientContext context) {
        this.context = context;
    }

    public synchronized long lookupKnownGood(USK usk) {
        Long l = this.latestKnownGoodByClearUSK.get(usk.clearCopy());
        if (l != null) {
            return l;
        }
        return -1L;
    }

    public synchronized long lookupLatestSlot(USK usk) {
        Long l = this.latestSlotByClearUSK.get(usk.clearCopy());
        if (l != null) {
            return l;
        }
        return -1L;
    }

    public USKFetcherTag getFetcher(USK usk, FetchContext ctx, boolean keepLast, boolean persistent, boolean realTime, USKFetcherCallback callback, boolean ownFetchContext, ClientContext context, boolean checkStoreOnly) {
        return USKFetcherTag.create(usk, callback, persistent, realTime, ctx, keepLast, 0, ownFetchContext, checkStoreOnly || ctx.localRequestOnly);
    }

    USKFetcher getFetcher(USK usk, FetchContext ctx, ClientRequester requester, boolean keepLastData, boolean checkStoreOnly) {
        return new USKFetcher(usk, this, ctx, requester, 3, false, keepLastData, checkStoreOnly);
    }

    public USKFetcherTag getFetcherForInsertDontSchedule(USK usk, short prioClass, USKFetcherCallback cb, RequestClient client, ClientContext context, boolean persistent, boolean ignoreUSKDatehints) {
        FetchContext fctx = ignoreUSKDatehints ? this.backgroundFetchContextIgnoreDBR : this.backgroundFetchContext;
        return this.getFetcher(usk, persistent ? new FetchContext(fctx, 0) : fctx, true, client.persistent(), client.realTimeFlag(), cb, true, context, false);
    }

    public void hintUpdate(USK usk, long edition, ClientContext context) {
        if (edition < this.lookupLatestSlot(usk)) {
            return;
        }
        FreenetURI uri = usk.copy(edition).getURI().sskForUSK();
        ClientGetter get = new ClientGetter(new NullClientCallback(rcBulk), uri, new FetchContext(this.backgroundFetchContext, 0), 3, new NullBucket(), null, null);
        try {
            get.start(context);
        }
        catch (FetchException fetchException) {
            // empty catch block
        }
    }

    public void hintUpdate(FreenetURI uri, ClientContext context) throws MalformedURLException {
        this.hintUpdate(uri, context, (short)3);
    }

    public void hintUpdate(FreenetURI uri, ClientContext context, short priority) throws MalformedURLException {
        block5: {
            if (uri.getSuggestedEdition() < this.lookupLatestSlot(USK.create(uri))) {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring hint because edition is " + uri.getSuggestedEdition() + " but latest is " + this.lookupLatestSlot(USK.create(uri)));
                }
                return;
            }
            uri = uri.sskForUSK();
            if (logMINOR) {
                Logger.minor(this, "Doing hint fetch for " + uri);
            }
            ClientGetter get = new ClientGetter(new NullClientCallback(rcBulk), uri, new FetchContext(this.backgroundFetchContext, 0), priority, new NullBucket(), null, null);
            try {
                get.start(context);
            }
            catch (FetchException e) {
                if (!logMINOR) break block5;
                Logger.minor(this, "Cannot start hint fetch for " + uri + " : " + e, (Throwable)e);
            }
        }
    }

    public void hintCheck(FreenetURI uri, final Object token, ClientContext context, short priority, final HintCallback cb) throws MalformedURLException {
        final FreenetURI origURI = uri;
        if (uri.isUSK()) {
            uri = uri.sskForUSK();
        }
        if (logMINOR) {
            Logger.minor(this, "Doing hint fetch for " + uri);
        }
        ClientGetter get = new ClientGetter(new ClientGetCallback(){

            @Override
            public void onSuccess(FetchResult result, ClientGetter state) {
                cb.success(origURI, token);
            }

            @Override
            public void onFailure(FetchException e, ClientGetter state) {
                if (e.isDataFound()) {
                    cb.success(origURI, token);
                } else if (e.isDNF()) {
                    cb.dnf(origURI, token, e);
                } else {
                    cb.failed(origURI, token, e);
                }
            }

            @Override
            public void onResume(ClientContext context) {
            }

            @Override
            public RequestClient getRequestClient() {
                return rcBulk;
            }
        }, uri, new FetchContext(this.backgroundFetchContext, 0), priority, new NullBucket(), null, null);
        try {
            get.start(context);
        }
        catch (FetchException e) {
            if (logMINOR) {
                Logger.minor(this, "Cannot start hint fetch for " + uri + " : " + e, (Throwable)e);
            }
            if (e.isDataFound()) {
                cb.success(origURI, token);
            }
            if (e.isDNF()) {
                cb.dnf(origURI, token, e);
            }
            cb.failed(origURI, token, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTemporaryBackgroundFetcher(USK usk, ClientContext context, FetchContext fctx, boolean prefetchContent, boolean realTimeFlag) {
        USK clear = usk.clearCopy();
        USKFetcher sched = null;
        ArrayList<USKFetcher> toCancel = null;
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            USKFetcher f = this.temporaryBackgroundFetchersLRU.get(clear);
            if (f == null) {
                sched = f = new USKFetcher(usk, this, fctx.ignoreUSKDatehints ? this.backgroundFetchContextIgnoreDBR : this.backgroundFetchContext, new USKFetcherWrapper(usk, 3, realTimeFlag ? rcRT : rcBulk), 3, false, false, false);
                this.temporaryBackgroundFetchersLRU.push(clear, f);
            } else {
                f.addHintEdition(usk.suggestedEdition);
            }
            if (prefetchContent) {
                long fetchTime = -1L;
                long slot = this.lookupLatestSlot(clear);
                long good = this.lookupKnownGood(clear);
                if (slot > -1L && good != slot) {
                    fetchTime = System.currentTimeMillis();
                }
                this.temporaryBackgroundFetchersPrefetch.put(clear, fetchTime);
                if (logMINOR) {
                    Logger.minor(this, "Prefetch: set " + fetchTime + " for " + clear);
                }
                this.schedulePrefetchChecker();
            }
            this.temporaryBackgroundFetchersLRU.push(clear, f);
            while (this.temporaryBackgroundFetchersLRU.size() > NodeClientCore.getMaxBackgroundUSKFetchers()) {
                USKFetcher fetcher = this.temporaryBackgroundFetchersLRU.popValue();
                this.temporaryBackgroundFetchersPrefetch.remove(fetcher.getOriginalUSK().clearCopy());
                if (!fetcher.hasSubscribers()) {
                    if (toCancel == null) {
                        toCancel = new ArrayList<USKFetcher>(2);
                    }
                    toCancel.add(fetcher);
                    continue;
                }
                if (!logMINOR) continue;
                Logger.minor(this, "Allowing temporary background fetcher to continue as it has subscribers... " + fetcher);
            }
        }
        final ArrayList<USKFetcher> cancelled = toCancel;
        final USKFetcher scheduleMe = sched;
        if (cancelled != null || sched != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (cancelled != null) {
                        for (int i = 0; i < cancelled.size(); ++i) {
                            USKFetcher fetcher = (USKFetcher)cancelled.get(i);
                            fetcher.cancel(USKManager.this.context);
                        }
                    }
                    if (scheduleMe != null) {
                        scheduleMe.schedule(USKManager.this.context);
                    }
                }
            });
        }
    }

    private void schedulePrefetchChecker() {
        this.context.ticker.queueTimedJob(this.prefetchChecker, "Check for USKs to prefetch", PREFETCH_DELAY, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateKnownGood(USK origUSK, final long number, final ClientContext context) {
        USKCallback[] callbacks;
        if (logMINOR) {
            Logger.minor(this, "Updating (known good) " + origUSK.getURI() + " : " + number);
        }
        USK clear = origUSK.clearCopy();
        boolean newSlot = false;
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            Long l = this.latestKnownGoodByClearUSK.get(clear);
            if (logMINOR) {
                Logger.minor(this, "Old known good: " + l);
            }
            if (l == null || number > l) {
                l = number;
                this.latestKnownGoodByClearUSK.put(clear, l);
                if (logMINOR) {
                    Logger.minor(this, "Put " + number);
                }
            } else {
                return;
            }
            l = this.latestSlotByClearUSK.get(clear);
            if (logMINOR) {
                Logger.minor(this, "Old slot: " + l);
            }
            if (l == null || number > l) {
                l = number;
                this.latestSlotByClearUSK.put(clear, l);
                if (logMINOR) {
                    Logger.minor(this, "Put " + number);
                }
                newSlot = true;
            }
            callbacks = this.subscribersByClearUSK.get(clear);
        }
        if (callbacks != null) {
            final USK usk = origUSK.copy(number);
            final boolean newSlotToo = newSlot;
            for (final USKCallback callback : callbacks) {
                context.mainExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFoundEdition(number, usk, context, false, (short)-1, null, true, newSlotToo);
                    }
                }, "USKManager callback executor for " + callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSlot(USK origUSK, final long number, final ClientContext context) {
        USKCallback[] callbacks;
        if (logMINOR) {
            Logger.minor(this, "Updating (slot) " + origUSK.getURI() + " : " + number);
        }
        USK clear = origUSK.clearCopy();
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            Long l = this.latestSlotByClearUSK.get(clear);
            if (logMINOR) {
                Logger.minor(this, "Old slot: " + l);
            }
            if (l == null || number > l) {
                l = number;
                this.latestSlotByClearUSK.put(clear, l);
                if (logMINOR) {
                    Logger.minor(this, "Put " + number);
                }
            } else {
                return;
            }
            callbacks = this.subscribersByClearUSK.get(clear);
            if (this.temporaryBackgroundFetchersPrefetch.containsKey(clear)) {
                this.temporaryBackgroundFetchersPrefetch.put(clear, System.currentTimeMillis());
                this.schedulePrefetchChecker();
            }
        }
        if (callbacks != null) {
            final USK usk = origUSK.copy(number);
            for (final USKCallback callback : callbacks) {
                context.mainExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFoundEdition(number, usk, context, false, (short)-1, null, false, false);
                    }
                }, "USKManager callback executor for " + callback);
            }
        }
    }

    public USKSparseProxyCallback subscribeSparse(USK origUSK, USKCallback cb, boolean ignoreUSKDatehints, RequestClient client) {
        USKSparseProxyCallback proxy = new USKSparseProxyCallback(cb, origUSK);
        this.subscribe(origUSK, proxy, true, ignoreUSKDatehints, client);
        return proxy;
    }

    public USKSparseProxyCallback subscribeSparse(USK origUSK, USKCallback cb, RequestClient client) {
        return this.subscribeSparse(origUSK, cb, false, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(USK origUSK, USKCallback cb, boolean runBackgroundFetch, boolean ignoreUSKDatehints, RequestClient client) {
        if (logMINOR) {
            Logger.minor(this, "Subscribing to " + origUSK + " for " + cb);
        }
        if (client.persistent()) {
            throw new UnsupportedOperationException("USKManager subscriptions cannot be persistent");
        }
        USKFetcher sched = null;
        long ed = origUSK.suggestedEdition;
        if (ed < 0L) {
            Logger.error(this, "Subscribing to USK with negative edition number: " + ed);
            ed = -ed;
        }
        long curEd = this.lookupLatestSlot(origUSK);
        long goodEd = this.lookupKnownGood(origUSK);
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            USK clear = origUSK.clearCopy();
            USKCallback[] callbacks = this.subscribersByClearUSK.get(clear);
            if (callbacks == null) {
                callbacks = new USKCallback[]{cb};
            } else {
                boolean mustAdd = true;
                for (USKCallback callback : callbacks) {
                    if (callback != cb) continue;
                    if (curEd <= ed && goodEd <= ed) {
                        return;
                    }
                    mustAdd = false;
                }
                if (mustAdd) {
                    callbacks = Arrays.copyOf(callbacks, callbacks.length + 1);
                    callbacks[callbacks.length - 1] = cb;
                }
            }
            this.subscribersByClearUSK.put(clear, callbacks);
            if (runBackgroundFetch) {
                USKFetcher f = this.backgroundFetchersByClearUSK.get(clear);
                if (f == null) {
                    sched = f = new USKFetcher(origUSK, this, ignoreUSKDatehints ? this.backgroundFetchContextIgnoreDBR : this.backgroundFetchContext, new USKFetcherWrapper(origUSK, 3, client), 3, true, false, false);
                    this.backgroundFetchersByClearUSK.put(clear, f);
                }
                f.addSubscriber(cb, origUSK.suggestedEdition);
            }
        }
        if (goodEd > ed) {
            cb.onFoundEdition(goodEd, origUSK.copy(curEd), this.context, false, (short)-1, null, true, curEd > ed);
        } else if (curEd > ed) {
            cb.onFoundEdition(curEd, origUSK.copy(curEd), this.context, false, (short)-1, null, false, false);
        }
        final USKFetcher fetcher = sched;
        if (fetcher != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (logMINOR) {
                        Logger.minor(this, "Starting " + fetcher);
                    }
                    fetcher.schedule(USKManager.this.context);
                }
            }, "USKManager.schedule for " + fetcher);
        }
    }

    public void subscribe(USK origUSK, USKCallback cb, boolean runBackgroundFetch, RequestClient client) {
        this.subscribe(origUSK, cb, runBackgroundFetch, false, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(USK origUSK, USKCallback cb) {
        USKFetcher toCancel = null;
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            USK clear = origUSK.clearCopy();
            USKCallback[] callbacks = this.subscribersByClearUSK.get(clear);
            if (callbacks == null) {
                if (logMINOR) {
                    Logger.minor(this, "No longer subscribed");
                }
                return;
            }
            int j = 0;
            for (USKCallback c : callbacks) {
                if (c == null || c == cb) continue;
                callbacks[j++] = c;
            }
            USKCallback[] newCallbacks = Arrays.copyOf(callbacks, j);
            if (newCallbacks.length > 0) {
                this.subscribersByClearUSK.put(clear, newCallbacks);
            } else {
                this.subscribersByClearUSK.remove(clear);
            }
            USKFetcher f = this.backgroundFetchersByClearUSK.get(clear);
            if (f != null) {
                f.removeSubscriber(cb, this.context);
                if (!f.hasSubscribers()) {
                    toCancel = f;
                    this.backgroundFetchersByClearUSK.remove(clear);
                }
            }
        }
        if (toCancel != null) {
            toCancel.cancel(this.context);
        } else if (logMINOR) {
            Logger.minor(this, "Not found unsubscribing: " + cb + " for " + origUSK);
        }
    }

    public USKRetriever subscribeContent(USK origUSK, USKRetrieverCallback cb, boolean runBackgroundFetch, FetchContext fctx, short prio, RequestClient client) {
        USKRetriever ret;
        USKCallback toSub = ret = new USKRetriever(fctx, prio, client, cb, origUSK);
        if (logMINOR) {
            Logger.minor(this, "Subscribing to " + origUSK + " for " + cb);
        }
        if (runBackgroundFetch) {
            USKSparseProxyCallback proxy = new USKSparseProxyCallback(ret, origUSK);
            ret.setProxy(proxy);
            toSub = proxy;
        }
        this.subscribe(origUSK, toSub, runBackgroundFetch, fctx.ignoreUSKDatehints, client);
        return ret;
    }

    public USKRetriever subscribeContentCustom(USK origUSK, USKRetrieverCallback cb, FetchContext fctx, short prio, RequestClient client) {
        USKRetriever ret;
        USKCallback toSub = ret = new USKRetriever(fctx, prio, client, cb, origUSK);
        if (logMINOR) {
            Logger.minor(this, "Subscribing to " + origUSK + " for " + cb);
        }
        USKSparseProxyCallback proxy = new USKSparseProxyCallback(ret, origUSK);
        ret.setProxy(proxy);
        toSub = proxy;
        this.subscribe(origUSK, toSub, false, client);
        USKFetcher f = new USKFetcher(origUSK, this, fctx, new USKFetcherWrapper(origUSK, prio, client), 3, true, false, false);
        ret.setFetcher(f);
        return ret;
    }

    public void unsubscribeContent(USK origUSK, USKRetriever ret, boolean runBackgroundFetch) {
        ret.unsubscribe(this);
    }

    public int getBackgroundFetcherByUSKSize() {
        return this.backgroundFetchersByClearUSK.size();
    }

    public int getTemporaryBackgroundFetchersLRU() {
        return this.temporaryBackgroundFetchersLRU.size();
    }

    public void onFinished(USKFetcher fetcher) {
        this.onFinished(fetcher, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinished(USKFetcher fetcher, boolean ignoreError) {
        USK orig = fetcher.getOriginalUSK();
        USK clear = orig.clearCopy();
        USKManager uSKManager = this;
        synchronized (uSKManager) {
            if (this.backgroundFetchersByClearUSK.get(clear) == fetcher) {
                this.backgroundFetchersByClearUSK.remove(clear);
                if (!ignoreError) {
                    Logger.error(this, "onCancelled for " + fetcher + " - was still registered, how did this happen??", (Throwable)new Exception("debug"));
                }
            }
            if (this.temporaryBackgroundFetchersLRU.get(clear) == fetcher) {
                this.temporaryBackgroundFetchersLRU.removeKey(clear);
                this.temporaryBackgroundFetchersPrefetch.remove(clear);
            }
        }
    }

    public boolean persistent() {
        return false;
    }

    ClientContext getContext() {
        return this.context;
    }

    public void checkUSK(FreenetURI uri, boolean persistent, boolean isMetadata) {
        try {
            FreenetURI uu;
            if (uri.isSSK() && uri.isSSKForUSK()) {
                uu = uri.setMetaString(null).uskForSSK();
            } else if (uri.isUSK()) {
                uu = uri;
            } else {
                return;
            }
            USK usk = USK.create(uu);
            if (!isMetadata) {
                this.context.uskManager.updateKnownGood(usk, uu.getSuggestedEdition(), this.context);
            } else {
                this.context.uskManager.updateSlot(usk, uu.getSuggestedEdition(), this.context);
            }
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Caught " + e, (Throwable)e);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
    }

    static {
        rcRT = new RequestClientBuilder().realTime().build();
        rcBulk = new RequestClientBuilder().build();
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        PREFETCH_DELAY = TimeUnit.SECONDS.toMillis(60L);
    }

    public static interface HintCallback {
        public void success(FreenetURI var1, Object var2);

        public void dnf(FreenetURI var1, Object var2, FetchException var3);

        public void failed(FreenetURI var1, Object var2, FetchException var3);
    }
}

