/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.awt.geom.GeneralPath;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.KerningTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.VerticalHeaderTable;
import org.apache.fontbox.ttf.VerticalMetricsTable;
import org.apache.fontbox.ttf.VerticalOriginTable;
import org.apache.fontbox.util.BoundingBox;

public class TrueTypeFont
implements FontBoxFont,
Closeable {
    private float version;
    private int numberOfGlyphs = -1;
    private int unitsPerEm = -1;
    protected Map<String, TTFTable> tables = new HashMap<String, TTFTable>();
    private final TTFDataStream data;
    private Map<String, Integer> postScriptNames;

    TrueTypeFont(TTFDataStream tTFDataStream) {
        this.data = tTFDataStream;
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    public float getVersion() {
        return this.version;
    }

    void setVersion(float f) {
        this.version = f;
    }

    void addTable(TTFTable tTFTable) {
        this.tables.put(tTFTable.getTag(), tTFTable);
    }

    public Collection<TTFTable> getTables() {
        return this.tables.values();
    }

    public Map<String, TTFTable> getTableMap() {
        return this.tables;
    }

    public synchronized byte[] getTableBytes(TTFTable tTFTable) throws IOException {
        long l = this.data.getCurrentPosition();
        this.data.seek(tTFTable.getOffset());
        byte[] byArray = this.data.read((int)tTFTable.getLength());
        this.data.seek(l);
        return byArray;
    }

    protected synchronized TTFTable getTable(String string) throws IOException {
        TTFTable tTFTable = this.tables.get(string);
        if (tTFTable != null && !tTFTable.getInitialized()) {
            this.readTable(tTFTable);
        }
        return tTFTable;
    }

    public NamingTable getNaming() throws IOException {
        return (NamingTable)this.getTable("name");
    }

    public PostScriptTable getPostScript() throws IOException {
        return (PostScriptTable)this.getTable("post");
    }

    public OS2WindowsMetricsTable getOS2Windows() throws IOException {
        return (OS2WindowsMetricsTable)this.getTable("OS/2");
    }

    public MaximumProfileTable getMaximumProfile() throws IOException {
        return (MaximumProfileTable)this.getTable("maxp");
    }

    public HeaderTable getHeader() throws IOException {
        return (HeaderTable)this.getTable("head");
    }

    public HorizontalHeaderTable getHorizontalHeader() throws IOException {
        return (HorizontalHeaderTable)this.getTable("hhea");
    }

    public HorizontalMetricsTable getHorizontalMetrics() throws IOException {
        return (HorizontalMetricsTable)this.getTable("hmtx");
    }

    public IndexToLocationTable getIndexToLocation() throws IOException {
        return (IndexToLocationTable)this.getTable("loca");
    }

    public GlyphTable getGlyph() throws IOException {
        return (GlyphTable)this.getTable("glyf");
    }

    public CmapTable getCmap() throws IOException {
        return (CmapTable)this.getTable("cmap");
    }

    public VerticalHeaderTable getVerticalHeader() throws IOException {
        return (VerticalHeaderTable)this.getTable("vhea");
    }

    public VerticalMetricsTable getVerticalMetrics() throws IOException {
        return (VerticalMetricsTable)this.getTable("vmtx");
    }

    public VerticalOriginTable getVerticalOrigin() throws IOException {
        return (VerticalOriginTable)this.getTable("VORG");
    }

    public KerningTable getKerning() throws IOException {
        return (KerningTable)this.getTable("kern");
    }

    public InputStream getOriginalData() throws IOException {
        return this.data.getOriginalData();
    }

    void readTable(TTFTable tTFTable) throws IOException {
        long l = this.data.getCurrentPosition();
        this.data.seek(tTFTable.getOffset());
        tTFTable.read(this, this.data);
        this.data.seek(l);
    }

    public int getNumberOfGlyphs() throws IOException {
        if (this.numberOfGlyphs == -1) {
            MaximumProfileTable maximumProfileTable = this.getMaximumProfile();
            this.numberOfGlyphs = maximumProfileTable != null ? maximumProfileTable.getNumGlyphs() : 0;
        }
        return this.numberOfGlyphs;
    }

    public int getUnitsPerEm() throws IOException {
        if (this.unitsPerEm == -1) {
            HeaderTable headerTable = this.getHeader();
            this.unitsPerEm = headerTable != null ? headerTable.getUnitsPerEm() : 0;
        }
        return this.unitsPerEm;
    }

    public int getAdvanceWidth(int n) throws IOException {
        HorizontalMetricsTable horizontalMetricsTable = this.getHorizontalMetrics();
        if (horizontalMetricsTable != null) {
            return horizontalMetricsTable.getAdvanceWidth(n);
        }
        return 250;
    }

    public int getAdvanceHeight(int n) throws IOException {
        VerticalMetricsTable verticalMetricsTable = this.getVerticalMetrics();
        if (verticalMetricsTable != null) {
            return verticalMetricsTable.getAdvanceHeight(n);
        }
        return 250;
    }

    @Override
    public String getName() throws IOException {
        if (this.getNaming() != null) {
            return this.getNaming().getPostScriptName();
        }
        return null;
    }

    private synchronized void readPostScriptNames() throws IOException {
        if (this.postScriptNames == null && this.getPostScript() != null) {
            String[] stringArray = this.getPostScript().getGlyphNames();
            if (stringArray != null) {
                this.postScriptNames = new HashMap<String, Integer>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.postScriptNames.put(stringArray[i], i);
                }
            } else {
                this.postScriptNames = new HashMap<String, Integer>();
            }
        }
    }

    public CmapSubtable getUnicodeCmap() throws IOException {
        return this.getUnicodeCmap(true);
    }

    public CmapSubtable getUnicodeCmap(boolean bl) throws IOException {
        CmapTable cmapTable = this.getCmap();
        if (cmapTable == null) {
            if (bl) {
                throw new IOException("The TrueType font does not contain a 'cmap' table");
            }
            return null;
        }
        CmapSubtable cmapSubtable = cmapTable.getSubtable(0, 4);
        if (cmapSubtable == null) {
            cmapSubtable = cmapTable.getSubtable(0, 3);
        }
        if (cmapSubtable == null) {
            cmapSubtable = cmapTable.getSubtable(3, 1);
        }
        if (cmapSubtable == null) {
            cmapSubtable = cmapTable.getSubtable(3, 0);
        }
        if (cmapSubtable == null) {
            if (bl) {
                throw new IOException("The TrueType font does not contain a Unicode cmap");
            }
            if (cmapTable.getCmaps().length > 0) {
                cmapSubtable = cmapTable.getCmaps()[0];
            }
        }
        return cmapSubtable;
    }

    public int nameToGID(String string) throws IOException {
        Integer n;
        this.readPostScriptNames();
        if (this.postScriptNames != null && (n = this.postScriptNames.get(string)) != null && n > 0 && n < this.getMaximumProfile().getNumGlyphs()) {
            return n;
        }
        int n2 = this.parseUniName(string);
        if (n2 > -1) {
            CmapSubtable cmapSubtable = this.getUnicodeCmap(false);
            return cmapSubtable.getGlyphId(n2);
        }
        return 0;
    }

    private int parseUniName(String string) throws IOException {
        if (string.startsWith("uni") && string.length() == 7) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n2 = 3;
                while (n2 + 4 <= n) {
                    int n3 = Integer.parseInt(string.substring(n2, n2 + 4), 16);
                    if (n3 <= 55295 || n3 >= 57344) {
                        stringBuilder.append((char)n3);
                    }
                    n2 += 4;
                }
                String string2 = stringBuilder.toString();
                if (string2.length() == 0) {
                    return -1;
                }
                return string2.codePointAt(0);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public GeneralPath getPath(String string) throws IOException {
        int n = this.nameToGID(string);
        GlyphData glyphData = this.getGlyph().getGlyph(n);
        if (glyphData == null) {
            return new GeneralPath();
        }
        return glyphData.getPath();
    }

    @Override
    public float getWidth(String string) throws IOException {
        Integer n = this.nameToGID(string);
        return this.getAdvanceWidth(n);
    }

    @Override
    public boolean hasGlyph(String string) throws IOException {
        return this.nameToGID(string) != 0;
    }

    @Override
    public BoundingBox getFontBBox() throws IOException {
        short s = this.getHeader().getXMin();
        short s2 = this.getHeader().getXMax();
        short s3 = this.getHeader().getYMin();
        short s4 = this.getHeader().getYMax();
        float f = 1000.0f / (float)this.getUnitsPerEm();
        return new BoundingBox((float)s * f, (float)s3 * f, (float)s2 * f, (float)s4 * f);
    }

    @Override
    public List<Number> getFontMatrix() throws IOException {
        float f = 1000.0f / (float)this.getUnitsPerEm();
        return Arrays.asList(Float.valueOf(0.001f * f), 0, 0, Float.valueOf(0.001f * f), 0, 0);
    }

    public String toString() {
        try {
            if (this.getNaming() != null) {
                return this.getNaming().getPostScriptName();
            }
            return "(null)";
        }
        catch (IOException iOException) {
            return "(null - " + iOException.getMessage() + ")";
        }
    }
}

