/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.util.Charsets;

public class NamingTable
extends TTFTable {
    public static final String TAG = "name";
    private List<NameRecord> nameRecords;
    private Map<Integer, Map<Integer, Map<Integer, Map<Integer, String>>>> lookupTable;
    private String fontFamily = null;
    private String fontSubFamily = null;
    private String psName = null;

    NamingTable(TrueTypeFont trueTypeFont) {
        super(trueTypeFont);
    }

    @Override
    public void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) throws IOException {
        Object object;
        int n = tTFDataStream.readUnsignedShort();
        int n2 = tTFDataStream.readUnsignedShort();
        int n3 = tTFDataStream.readUnsignedShort();
        this.nameRecords = new ArrayList<NameRecord>(n2);
        for (int i = 0; i < n2; ++i) {
            NameRecord nameRecord = new NameRecord();
            nameRecord.initData(trueTypeFont, tTFDataStream);
            this.nameRecords.add(nameRecord);
        }
        for (NameRecord nameRecord : this.nameRecords) {
            if ((long)nameRecord.getStringOffset() > this.getLength()) {
                nameRecord.setString(null);
                continue;
            }
            tTFDataStream.seek(this.getOffset() + 6L + (long)(n2 * 2 * 6) + (long)nameRecord.getStringOffset());
            int n4 = nameRecord.getPlatformId();
            int n5 = nameRecord.getPlatformEncodingId();
            object = Charsets.ISO_8859_1;
            if (n4 == 3 && (n5 == 0 || n5 == 1)) {
                object = Charsets.UTF_16;
            } else if (n4 == 0) {
                object = Charsets.UTF_16;
            } else if (n4 == 2) {
                if (n5 == 0) {
                    object = Charsets.US_ASCII;
                } else if (n5 == 1) {
                    object = Charsets.ISO_10646;
                } else if (n5 == 2) {
                    object = Charsets.ISO_8859_1;
                }
            }
            String string = tTFDataStream.readString(nameRecord.getStringLength(), (Charset)object);
            nameRecord.setString(string);
        }
        this.lookupTable = new HashMap<Integer, Map<Integer, Map<Integer, Map<Integer, String>>>>(this.nameRecords.size());
        for (NameRecord nameRecord : this.nameRecords) {
            Map<Integer, Map<Integer, String>> map;
            Map<Integer, Map<Integer, Map<Integer, String>>> map2 = this.lookupTable.get(nameRecord.getNameId());
            if (map2 == null) {
                map2 = new HashMap<Integer, Map<Integer, Map<Integer, String>>>();
                this.lookupTable.put(nameRecord.getNameId(), map2);
            }
            if ((map = map2.get(nameRecord.getPlatformId())) == null) {
                map = new HashMap<Integer, Map<Integer, String>>();
                map2.put(nameRecord.getPlatformId(), map);
            }
            if ((object = map.get(nameRecord.getPlatformEncodingId())) == null) {
                object = new HashMap<Integer, String>();
                map.put(nameRecord.getPlatformEncodingId(), (Map<Integer, String>)object);
            }
            object.put(nameRecord.getLanguageId(), nameRecord.getString());
        }
        this.fontFamily = this.getEnglishName(1);
        this.fontSubFamily = this.getEnglishName(2);
        this.psName = this.getName(6, 1, 0, 0);
        if (this.psName == null) {
            this.psName = this.getName(6, 3, 1, 1033);
        }
        if (this.psName != null) {
            this.psName = this.psName.trim();
        }
        this.initialized = true;
    }

    private String getEnglishName(int n) {
        String string;
        for (int i = 4; i >= 0; --i) {
            string = this.getName(n, 0, i, 0);
            if (string == null) continue;
            return string;
        }
        String string2 = this.getName(n, 3, 1, 1033);
        if (string2 != null) {
            return string2;
        }
        string = this.getName(n, 1, 0, 0);
        if (string != null) {
            return string;
        }
        return null;
    }

    public String getName(int n, int n2, int n3, int n4) {
        Map<Integer, Map<Integer, Map<Integer, String>>> map = this.lookupTable.get(n);
        if (map == null) {
            return null;
        }
        Map<Integer, Map<Integer, String>> map2 = map.get(n2);
        if (map2 == null) {
            return null;
        }
        Map<Integer, String> map3 = map2.get(n3);
        if (map3 == null) {
            return null;
        }
        return map3.get(n4);
    }

    public List<NameRecord> getNameRecords() {
        return this.nameRecords;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontSubFamily() {
        return this.fontSubFamily;
    }

    public String getPostScriptName() {
        return this.psName;
    }
}

