/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class CFFTable
extends TTFTable {
    public static final String TAG = "CFF ";
    private CFFFont cffFont;

    CFFTable(TrueTypeFont trueTypeFont) {
        super(trueTypeFont);
    }

    @Override
    public void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) throws IOException {
        byte[] byArray = tTFDataStream.read((int)this.getLength());
        CFFParser cFFParser = new CFFParser();
        this.cffFont = cFFParser.parse(byArray, new ByteSource(this.font)).get(0);
        this.initialized = true;
    }

    public CFFFont getFont() {
        return this.cffFont;
    }

    private static class ByteSource
    implements CFFParser.ByteSource {
        private final TrueTypeFont ttf;

        ByteSource(TrueTypeFont trueTypeFont) {
            this.ttf = trueTypeFont;
        }

        @Override
        public byte[] getBytes() throws IOException {
            return this.ttf.getTableBytes(this.ttf.getTableMap().get(CFFTable.TAG));
        }
    }
}

