/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.HashMap;
import java.util.Map;

public abstract class CFFCharset {
    private final boolean isCIDFont;
    private final Map<Integer, Integer> sidOrCidToGid = new HashMap<Integer, Integer>(250);
    private final Map<Integer, Integer> gidToSid = new HashMap<Integer, Integer>(250);
    private final Map<String, Integer> nameToSid = new HashMap<String, Integer>(250);
    private final Map<Integer, Integer> gidToCid = new HashMap<Integer, Integer>();
    private final Map<Integer, String> gidToName = new HashMap<Integer, String>(250);

    CFFCharset(boolean bl) {
        this.isCIDFont = bl;
    }

    public boolean isCIDFont() {
        return this.isCIDFont;
    }

    public void addSID(int n, int n2, String string) {
        if (this.isCIDFont) {
            throw new IllegalStateException("Not a Type 1-equivalent font");
        }
        this.sidOrCidToGid.put(n2, n);
        this.gidToSid.put(n, n2);
        this.nameToSid.put(string, n2);
        this.gidToName.put(n, string);
    }

    public void addCID(int n, int n2) {
        if (!this.isCIDFont) {
            throw new IllegalStateException("Not a CIDFont");
        }
        this.sidOrCidToGid.put(n2, n);
        this.gidToCid.put(n, n2);
    }

    int getSIDForGID(int n) {
        if (this.isCIDFont) {
            throw new IllegalStateException("Not a Type 1-equivalent font");
        }
        Integer n2 = this.gidToSid.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    int getGIDForSID(int n) {
        if (this.isCIDFont) {
            throw new IllegalStateException("Not a Type 1-equivalent font");
        }
        Integer n2 = this.sidOrCidToGid.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    public int getGIDForCID(int n) {
        if (!this.isCIDFont) {
            throw new IllegalStateException("Not a CIDFont");
        }
        Integer n2 = this.sidOrCidToGid.get(n);
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    int getSID(String string) {
        if (this.isCIDFont) {
            throw new IllegalStateException("Not a Type 1-equivalent font");
        }
        Integer n = this.nameToSid.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public String getNameForGID(int n) {
        if (this.isCIDFont) {
            throw new IllegalStateException("Not a Type 1-equivalent font");
        }
        return this.gidToName.get(n);
    }

    public int getCIDForGID(int n) {
        if (!this.isCIDFont) {
            throw new IllegalStateException("Not a CIDFont");
        }
        Integer n2 = this.gidToCid.get(n);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }
}

