/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;

public class Results
implements Serializable {
    private static final long serialVersionUID = -2722051869610289637L;
    private int callCount;
    private final LinkedList<Range> ranges = new LinkedList();
    private final List<Result> results = new ArrayList<Result>();

    public void add(Result result, Range range) {
        Range range2;
        if (!this.ranges.isEmpty() && !(range2 = this.ranges.getLast()).hasFixedCount()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock already has a non-fixed count set."));
        }
        this.ranges.add(range);
        this.results.add(result);
    }

    public boolean hasResults() {
        int n = 0;
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range range = this.ranges.get(i);
            if (range.hasOpenCount()) {
                return true;
            }
            if ((n += range.getMaximum()) <= this.callCount) continue;
            return true;
        }
        return false;
    }

    public Result next() {
        int n = 0;
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range range = this.ranges.get(i);
            if (range.hasOpenCount()) {
                ++this.callCount;
                return this.results.get(i);
            }
            if ((n += range.getMaximum()) <= this.callCount) continue;
            ++this.callCount;
            return this.results.get(i);
        }
        return null;
    }

    public boolean hasValidCallCount() {
        return this.getMainInterval().contains(this.callCount);
    }

    public String toString() {
        return this.getMainInterval().expectedCount();
    }

    private Range getMainInterval() {
        int n = 0;
        int n2 = 0;
        for (Range range : this.ranges) {
            n += range.getMinimum();
            if (range.hasOpenCount() || n2 == Integer.MAX_VALUE) {
                n2 = Integer.MAX_VALUE;
                continue;
            }
            n2 += range.getMaximum();
        }
        return new Range(n, n2);
    }

    public int getCallCount() {
        return this.callCount;
    }
}

