/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.easymock.MockType;
import org.easymock.TestSubject;
import org.easymock.internal.Injection;
import org.easymock.internal.InjectionPlan;
import org.easymock.internal.InjectionTarget;

public class Injector {
    public static void injectMocks(Object object) {
        InjectionPlan injectionPlan = new InjectionPlan();
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Injector.createMocksForAnnotations(clazz, object, injectionPlan);
        }
        for (Field object2 : injectionPlan.getTestSubjectFields()) {
            Object object3;
            object2.setAccessible(true);
            try {
                object3 = object2.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            if (object3 == null) {
                throw new NullPointerException("Have you forgotten to instantiate " + object2.getName() + "?");
            }
            for (Class<?> clazz = object3.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                Injector.injectMocksOnClass(clazz, object3, injectionPlan);
            }
        }
        for (Injection injection : injectionPlan.getQualifiedInjections()) {
            if (injection.isMatched()) continue;
            throw new RuntimeException(String.format("Unsatisfied qualifier: '%s'", injection.getAnnotation().fieldName()));
        }
    }

    private static void createMocksForAnnotations(Class<?> clazz, Object object, InjectionPlan injectionPlan) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            TestSubject testSubject = field.getAnnotation(TestSubject.class);
            if (testSubject != null) {
                injectionPlan.addTestSubjectField(field);
                continue;
            }
            Mock mock = field.getAnnotation(Mock.class);
            if (mock == null) continue;
            Class<?> clazz2 = field.getType();
            String string = mock.name();
            string = string.length() == 0 ? null : string;
            MockType mockType = mock.type();
            Object obj = object instanceof EasyMockSupport ? ((EasyMockSupport)object).createMock(string, mockType, clazz2) : EasyMock.createMock(string, mockType, clazz2);
            field.setAccessible(true);
            try {
                field.set(object, obj);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            injectionPlan.addInjection(new Injection(obj, mock));
        }
    }

    private static void injectMocksOnClass(Class<?> clazz, Object object, InjectionPlan injectionPlan) {
        List<Field> list = Injector.injectByName(clazz, object, injectionPlan.getQualifiedInjections());
        Injector.injectByType(object, list, injectionPlan.getUnqualifiedInjections());
    }

    private static List<Field> injectByName(Class<?> clazz, Object object, List<Injection> list) {
        List<Field> list2 = Injector.fieldsOf(clazz);
        for (Injection injection : list) {
            Field field = Injector.getFieldByName(clazz, injection.getQualifier());
            InjectionTarget injectionTarget = Injector.injectionTargetWithField(field);
            if (injectionTarget == null || !injectionTarget.accepts(injection)) continue;
            injectionTarget.inject(object, injection);
            list2.remove(injectionTarget.getTargetField());
        }
        return list2;
    }

    private static void injectByType(Object object, List<Field> list, List<Injection> list2) {
        for (Field field : list) {
            Injection injection;
            InjectionTarget injectionTarget = Injector.injectionTargetWithField(field);
            if (injectionTarget == null || (injection = Injector.findUniqueAssignable(list2, injectionTarget)) == null) continue;
            injectionTarget.inject(object, injection);
        }
    }

    private static List<Field> fieldsOf(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        arrayList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return arrayList;
    }

    private static Field getFieldByName(Class<?> clazz, String string) {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static InjectionTarget injectionTargetWithField(Field field) {
        if (Injector.shouldNotAssignTo(field)) {
            return null;
        }
        return new InjectionTarget(field);
    }

    private static boolean shouldNotAssignTo(Field field) {
        return field == null || (field.getModifiers() & 0x18) != 0;
    }

    private static Injection findUniqueAssignable(List<Injection> list, InjectionTarget injectionTarget) {
        Injection injection = null;
        for (Injection injection2 : list) {
            if (!injectionTarget.accepts(injection2)) continue;
            if (injection != null) {
                throw new RuntimeException(String.format("At least two mocks can be assigned to '%s': %s and %s", injectionTarget.getTargetField(), injection.getMock(), injection2.getMock()));
            }
            injection = injection2;
        }
        return injection;
    }
}

