/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Field;
import org.easymock.internal.Injection;

public class InjectionTarget {
    private final Field targetField;

    public InjectionTarget(Field field) {
        this.targetField = field;
    }

    public boolean accepts(Injection injection) {
        return this.targetField.getType().isAssignableFrom(injection.getMock().getClass());
    }

    public void inject(Object object, Injection injection) {
        this.targetField.setAccessible(true);
        try {
            this.targetField.set(object, injection.getMock());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        injection.setMatched();
    }

    public Field getTargetField() {
        return this.targetField;
    }
}

