/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class EasyMockProperties {
    private static final String PREFIX = "easymock.";
    private static volatile EasyMockProperties instance;
    private final Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EasyMockProperties getInstance() {
        if (instance != null) return instance;
        Class<EasyMockProperties> clazz = EasyMockProperties.class;
        synchronized (EasyMockProperties.class) {
            if (instance != null) return instance;
            instance = new EasyMockProperties();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private EasyMockProperties() {
        this.loadEasyMockProperties("easymock.properties");
    }

    private void loadEasyMockProperties(String string) {
        InputStream inputStream = this.getClassLoader().getResourceAsStream(string);
        if (inputStream != null) {
            inputStream = new BufferedInputStream(inputStream);
            try {
                this.properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to read " + string + " file");
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String setProperty(String string, String string2) {
        if (!string.startsWith(PREFIX)) {
            throw new IllegalArgumentException("Invalid key (" + string + "), an easymock property starts with \"" + PREFIX + "\"");
        }
        if (string2 == null) {
            return (String)this.properties.remove(string);
        }
        return (String)this.properties.setProperty(string, string2);
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }
}

