;
; "Second Sleep"
; by Dave Seidel
;
; Copyright 2007 Dave Seidel, some rights reserved.  This work is licensed under a
; Creative Commons Attribution License (see http://creativecommons.org/licenses/by/3.0/).
; 
; For more information, go to http://mysterybear.net/article/27
; 
; Add the following lines after <CsoundSynthesizer> and before <CsInstruments> below,
; uncomment by removing the leading semicolons, then edit as desired.
; 
; *** START OF OPTIONS ***
; <CsOptions>
; ;; 96K/24-bit
; ;--sample-rate=96000 --control-rate=96000 --format=wav:24bit -o "SecondSleep-(96-24).wav"
; ;; 44.1K/16-bit
; --sample-rate=44100 --control-rate=44100 --format=wav:short -o "SecondSleep-(44-16).wav"
; </CsOptions>
; *** END OF OPTIONS ***
; 
;
; Generated by blue 0.123.1 (http://csounds.com/stevenyi/blue/index.html)
;

<CsoundSynthesizer>

<CsInstruments>
sr=96000
ksmps=1
nchnls=2

giTblSz	init	1048576

; sine wave
giFn1	ftgen	1, 0, giTblSz, 10, 1

; "Fibonacci" wave (Mt. Meru A)
giFn2	ftgen	2, 0, giTblSz, 9,  1,1,0,   2,.5,0,   3,.3333,0,  5,.2,0,  8,.125,0,  13,.0769,0,  21,.0476,0,  34,.0294,0,  55,.0182,0,  89,.0112,0  144,.0069,0

ga_bluemix_18_0	init	0
ga_bluemix_18_1	init	0
ga_bluemix_19_0	init	0
ga_bluemix_19_1	init	0
ga_bluemix_20_0	init	0
ga_bluemix_20_1	init	0
ga_bluesub_SubChannel1_0	init	0
ga_bluesub_SubChannel1_1	init	0
ga_bluesub_SubChannel2_0	init	0
ga_bluesub_SubChannel2_1	init	0
ga_bluesub_SubChannel3_0	init	0
ga_bluesub_SubChannel3_1	init	0
ga_bluesub_Master_0	init	0
ga_bluesub_Master_1	init	0



;git_sqr	ftgen	0, 0, 8192,	7,	1, 4096, 1, 0, -1, 4096, -1
;git_sqr	ftgen	0, 0, 8192,	7,	1, 4096, 1, 0, -1, 4096, -1


	opcode yipan,aa,ia

iSpace,aout	xin
iSpace		=	iSpace * 3.14159265359 * .5
krtl		= 	sqrt(2) / 2 * (cos(iSpace) + sin(iSpace))
krtr		= 	sqrt(2) / 2 * (cos(iSpace) - sin(iSpace))
aLeft		=	aout * krtl
aRight		=	aout * krtr
		xout	aLeft, aRight


	endop
	opcode yiEnvelope,k,ioooooo

ienvType, iattack, idecay, isus, irel, iOldAmp, iNewAmp	xin

itie	tival
idur = p3

;prints "itie=%d  p3=%f\\n", itie, p3

iEndAmp = iNewAmp / iOldAmp


if (ienvType == 0) then
	kenv	adsr	iattack, idecay, isus, irel
elseif (ienvType == 1) then	
	kenv 	linseg	0, p3 * .5, 1, p3 * .5, 0
	kenv logcurve kenv, 1.5
elseif (ienvType == 2) then	
	kenv	linseg 	0, p3 - .1, 1, .1, 0	

elseif (ienvType == 3) then

    if (itie == 0 && p3 < 0) then
        ; this is an initial note within a group of tied notes
	prints	"start note\\n"
        kenv	linseg	0, .2, 1,  .2, 1
       
    elseif (p3 > 0 && itie == 1) then
        ; this is an end note out of a group of tied notes
	prints "end note\\n"
        kenv linseg	1, p3 - 1, 1, 1, 0
 
    elseif (p3 > 0 && itie == 0) then
        ; this is a stand alone note
	prints "standalone note\\n"
        kenv adsr iattack, idecay, isus, irel
    else
        ; this is a middle note within a group of tied notes (p3 < 0 && itie == 1)
	prints "middle note\\n"
        kenv line 1, abs(p3), iEndAmp
    endif  

endif

	xout 	kenv


	endop
	opcode blueEffect0,aa,aa

ain1,ain2	xin
krms1	rms ain1
arms1	upsamp krms1

aout1 init 0
aout2 init 0

if 1 == 0 then
	aout1	compress ain1, ain1, 0, 48, 60, 1.5, 0.0100000007, 0.0800000057, .05
else
	aout1	compress ain1, arms1, 0, 48, 60, 1.5, 0.0100000007, 0.0800000057, .05
endif
	
krms2	rms ain2
arms2	upsamp krms2

if 1 == 0 then
	aout2	compress ain2, ain2, 0, 48, 60, 1.5, 0.0100000007, 0.0800000057, .05
else
	aout2	compress ain2, arms2, 0, 48, 60, 1.5, 0.0100000007, 0.0800000057, .05
endif

aout1	= aout1 * 1
aout2	= aout2 * 1

;aout1 compress ain1, ain2, 
xout	aout1,aout2


	endop
	opcode blueEffect1,aa,aa

ain1,ain2	xin
aout1, aout2  reverbsc ain1, ain2, 0.85, 8000.0

aout1 = (ain1 * 0.66999966) + (aout1 * (1 - 0.66999966))
aout2 = (ain2 * 0.66999966) + (aout2 * (1 - 0.66999966))


xout	aout1,aout2


	endop
	opcode blueEffect2,aa,aa

ain1,ain2	xin
aout1	butterlp ain1, sr/2
aout2	butterlp ain2, sr/2

xout	aout1,aout2


	endop


	instr 18	;Modified ResonantRhythm
ifreq	=	p4
ibpm    =       p5
isubdiv	=	p6
ipan	=	p7
; optional
ivol	=	p8
kdetune	=	p9
kbright	=	p10
kres	=	p11
khpfreq	=	p12
; setup
iamp	=	5000
; defaults
ifreq	=	(p4 >= 20) ? ifreq : cpspch(ifreq)
ivol		= (ivol == 0) ? 0.9 : ivol
kdetune		= (kdetune == 0) ? 0.015 : kdetune
kbright		= (kbright == 0) ? 6.3619614 : kbright
kres		= (kres == 0) ? 0.33750337 : kres
khpfreq		= (khpfreq == 0) ? 720.0 : khpfreq
; calculate iamp
iamp	=	iamp * ivol
; seed
;	seed	0
;iseed	random	0, 1	
; envelope
aampenv linsegr	0, 0.40059987, 1, 1.75, 0
; sqr random
ksqrfreq	= ibpm * isubdiv / 240
kfreq	randi	.5, ksqrfreq, 0.1, 0.1
kfreq	=	(kfreq + .5) * kbright
; oscillators
idet	=	0.015
ivar	=	0.005
idet2	=	2*idet
idet3	=	3*(idet+ivar)
idet4	=	4*(idet+(ivar*2))
aosc1	vco2	iamp, ifreq, 2, 0.15215088
aosc2	vco2	iamp, ifreq + idet, 2, 0.15215088
aosc3	vco2	iamp, ifreq + idet2, 2, 0.15215088
aosc4	vco2	iamp, ifreq + idet3, 2, 0.15215088
aosc5	vco2	iamp, ifreq + idet4, 2, 0.15215088
aosc6	vco2	iamp, ifreq - idet, 2, 0.15215088
aosc7	vco2	iamp, ifreq - idet2, 2, 0.15215088
aosc8	vco2	iamp, ifreq - idet3, 2, 0.15215088
aosc9	vco2	iamp, ifreq - idet4, 2, 0.15215088
; mix
aout	=	(aosc1 + aosc2 + aosc3 + aosc4 + aosc5 + aosc6 + aosc7 + aosc8 + aosc8) * aampenv
; filter
aout	moogvcf2	aout, kfreq * ifreq, kres
aout	atone		aout, khpfreq
; output
aoutl, aoutr	yipan	ipan, aout
ga_bluemix_18_0 = ga_bluemix_18_0 +  aoutl
ga_bluemix_18_1 = ga_bluemix_18_1 +  aoutr

	endin

	instr 19	;Risset harmonic arpeggio
idur	=	p3				; duration
iamp	=	p4/9				; amplitude
ifn	=	p5				; function table number (waveform)
ifreq	=	p6*(p7/p8)			; pitch (base * (n/m))
ipan	=	p10				; 1.0 = left <-> 0.0 = right
irise	=	p11
ifall	=	p12
if (p9 < 0) then
	ioff    =       ((p8*2)/p7)*abs(p9)		; offset inversely proportional to ratio
else
	ioff	=	p9				; oscillator offset for arpeggio
endif
ioff1	=	ioff
ioff2	=	2*ioff
ioff3	=	3*ioff	
ioff4	=	4*ioff
ke	linen	iamp, irise, idur, ifall	; simple envelope
a1	poscil3	ke, ifreq, ifn, -1
a2	poscil3	ke, ifreq+ioff1, ifn, -1	; nine oscillators with the same ae
a3	poscil3	ke, ifreq+ioff2, ifn, -1	; and waveform, but slightly different
a4	poscil3	ke, ifreq+ioff3, ifn, -1	; frequencies create harmonic arpeggio
a5	poscil3	ke, ifreq+ioff4, ifn, -1
a6	poscil3	ke, ifreq-ioff1, ifn, -1
a7	poscil3	ke, ifreq-ioff2, ifn, -1
a8	poscil3	ke, ifreq-ioff3, ifn, -1
a9	poscil3	ke, ifreq-ioff4, ifn, -1
asig	sum	a1,a2,a3,a4,a5,a6,a7,a8,a9
; compress it
icomp1	=	0.5
icomp2	=	0.763
irtime	=	0.1
iftime	=	0.1
asig	dam	asig, ke, icomp1, icomp2, irtime, iftime
al,ar	yipan	ipan, asig
ga_bluemix_19_0 = ga_bluemix_19_0 +  al
ga_bluemix_19_1 = ga_bluemix_19_1 +  ar
;gaL	= 	gaL + al
;gaR	=	gaR + ar

	endin

	instr 20	;Modified ResonantRhythm
ifreq	=	p4
ibpm    =       p5
isubdiv	=	p6
ipan	=	p7
; optional
ivol	=	p8
kdetune	=	p9
kbright	=	p10
kres	=	p11
khpfreq	=	p12
; setup
iamp	=	5000
; defaults
ifreq	=	(p4 >= 20) ? ifreq : cpspch(ifreq)
ivol		= (ivol == 0) ? 0.9 : ivol
kdetune		= (kdetune == 0) ? 0.015 : kdetune
kbright		= (kbright == 0) ? 6.3619614 : kbright
kres		= (kres == 0) ? 0.33750337 : kres
khpfreq		= (khpfreq == 0) ? 720.0 : khpfreq
; calculate iamp
iamp	=	iamp * ivol
; seed
;	seed	0
;iseed	random	0, 1	
; envelope
aampenv linsegr	0, 0.40059987, 1, 0.5004998, 0
; sqr random
ksqrfreq	= ibpm * isubdiv / 240
kfreq	randi	.5, ksqrfreq, 0.1, 0.1
kfreq	=	(kfreq + .5) * kbright
; oscillators
idet	=	0.015
ivar	=	0.005
idet2	=	2*idet
idet3	=	3*(idet+ivar)
idet4	=	4*(idet+(ivar*2))
aosc1	vco2	iamp, ifreq, 2, 0.15215088
aosc2	vco2	iamp, ifreq + idet, 2, 0.15215088
aosc3	vco2	iamp, ifreq + idet2, 2, 0.15215088
aosc4	vco2	iamp, ifreq + idet3, 2, 0.15215088
aosc5	vco2	iamp, ifreq + idet4, 2, 0.15215088
aosc6	vco2	iamp, ifreq - idet, 2, 0.15215088
aosc7	vco2	iamp, ifreq - idet2, 2, 0.15215088
aosc8	vco2	iamp, ifreq - idet3, 2, 0.15215088
aosc9	vco2	iamp, ifreq - idet4, 2, 0.15215088
; mix
aout	=	(aosc1 + aosc2 + aosc3 + aosc4 + aosc5 + aosc6 + aosc7 + aosc8 + aosc8) * aampenv
; filter
aout	moogvcf2	aout, kfreq * ifreq, kres
aout	atone		aout, khpfreq
; output
aoutl, aoutr	yipan	ipan, aout
ga_bluemix_20_0 = ga_bluemix_20_0 +  aoutl
ga_bluemix_20_1 = ga_bluemix_20_1 +  aoutr

	endin

	instr 21	;Blue Mixer Instrument
ga_bluemix_18_0, ga_bluemix_18_1	blueEffect0	ga_bluemix_18_0, ga_bluemix_18_1
ga_bluesub_SubChannel1_0	sum	ga_bluesub_SubChannel1_0, ga_bluemix_18_0
ga_bluesub_SubChannel1_1	sum	ga_bluesub_SubChannel1_1, ga_bluemix_18_1
ga_bluemix_19_0 = ga_bluemix_19_0 * 0.7079457641
ga_bluemix_19_1 = ga_bluemix_19_1 * 0.7079457641
ga_bluesub_SubChannel2_0	sum	ga_bluesub_SubChannel2_0, ga_bluemix_19_0
ga_bluesub_SubChannel2_1	sum	ga_bluesub_SubChannel2_1, ga_bluemix_19_1
ga_bluesub_SubChannel3_0	sum	ga_bluesub_SubChannel3_0, ga_bluemix_20_0
ga_bluesub_SubChannel3_1	sum	ga_bluesub_SubChannel3_1, ga_bluemix_20_1
ga_bluesub_SubChannel1_0 = ga_bluesub_SubChannel1_0 * 1.2589254379
ga_bluesub_SubChannel1_1 = ga_bluesub_SubChannel1_1 * 1.2589254379
ga_bluesub_SubChannel1_0, ga_bluesub_SubChannel1_1	blueEffect1	ga_bluesub_SubChannel1_0, ga_bluesub_SubChannel1_1
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluesub_SubChannel1_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluesub_SubChannel1_1
ga_bluesub_SubChannel2_0, ga_bluesub_SubChannel2_1	blueEffect1	ga_bluesub_SubChannel2_0, ga_bluesub_SubChannel2_1
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluesub_SubChannel2_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluesub_SubChannel2_1
ga_bluesub_SubChannel3_0, ga_bluesub_SubChannel3_1	blueEffect1	ga_bluesub_SubChannel3_0, ga_bluesub_SubChannel3_1
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluesub_SubChannel3_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluesub_SubChannel3_1
ga_bluesub_Master_0, ga_bluesub_Master_1	blueEffect2	ga_bluesub_Master_0, ga_bluesub_Master_1
ga_bluesub_Master_0 = ga_bluesub_Master_0 * 2.3713736534
ga_bluesub_Master_1 = ga_bluesub_Master_1 * 2.3713736534
outc ga_bluesub_Master_0, ga_bluesub_Master_1
ga_bluemix_18_0 = 0
ga_bluemix_18_1 = 0
ga_bluemix_19_0 = 0
ga_bluemix_19_1 = 0
ga_bluemix_20_0 = 0
ga_bluemix_20_1 = 0
ga_bluesub_SubChannel1_0 = 0
ga_bluesub_SubChannel1_1 = 0
ga_bluesub_SubChannel2_0 = 0
ga_bluesub_SubChannel2_1 = 0
ga_bluesub_SubChannel3_0 = 0
ga_bluesub_SubChannel3_1 = 0
ga_bluesub_Master_0 = 0
ga_bluesub_Master_1 = 0

	endin


</CsInstruments>

<CsScore>



t 0 20





i20	0.0	155.8095245361	240	30	8	0	0.2
i20	0.0	155.8095245361	120	15	8	0	0.6
i20	0.0	155.8095245361	60	7.5	8	0	0.6
i19	0.0	155.8095245361	1400	2	240	1	1	0.013	0	3	3
i19	0.0	155.8095245361	1400	2	120	1	1	0.014	0	3	3
i19	0.0	155.8095245361	1400	2	60	1	1	0.015	0	3	3
i19	3.0	148.2380981445	1400	2	240	65	64	0.010	1	3	3
i19	3.0	148.2380981445	1400	2	120	57	32	0.012	-1	3	3
i19	3.0	148.2380981445	1400	2	120	43	32	0.011	0	3	3
i18	8.761905	41.5238113403	135	16.875	16	0.8	1.0
i18	56.38095	41.5238113403	138.75	17.34375	8	0.8	0.9
i18	103.61905	41.9047622681	135	16.875	16	0.8	1.0
i18	9.142858	41.1428565979	141.5625	17.6953125	16	0.6	1.0
i18	56.761906	41.1428565979	157.5	19.6875	8	0.6	0.9
i18	104.0	41.5238113403	141.5625	17.6953125	16	0.6	1.0
i18	9.523809	40.7619056702	180	22.5	16	-0.6	1.0
i18	57.142857	40.7619056702	183.75	22.96875	8	-0.6	0.9
i18	104.38095	41.1428565979	180	22.5	16	-0.6	1.0
i18	9.904762	40.3809509277	187.5	23.4375	16	-0.8	1.0
i18	57.52381	40.3809509277	210	26.25	8	-0.8	0.9
i18	104.7619	40.7619056702	187.5	23.4375	16	-0.8	1.0
i21	0	157.8095245361	
e

</CsScore>

</CsoundSynthesizer>