/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.python.editor.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.python.editor.lexer.PythonStringTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class PythonStringLexer
implements Lexer<PythonStringTokenId> {
    private static final int EOF = -1;
    private final LexerInput input;
    private final TokenFactory<PythonStringTokenId> tokenFactory;
    private final boolean substituting;

    public PythonStringLexer(LexerRestartInfo<PythonStringTokenId> info, boolean substituting) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.substituting = substituting;
        assert (info.state() == null);
    }

    public Object state() {
        return null;
    }

    public Token<PythonStringTokenId> nextToken() {
        boolean inWord = false;
        while (true) {
            int ch = this.input.read();
            switch (ch) {
                case -1: {
                    if (this.input.readLength() > 0) {
                        return this.tokenFactory.createToken((TokenId)PythonStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    return null;
                }
                case 62: {
                    int initialReadLength = this.input.readLength();
                    this.input.read();
                    if (ch == 62 && (ch = this.input.read()) == 62) {
                        if (this.input.readLength() > 3) {
                            this.input.backup(3);
                            return this.tokenFactory.createToken((TokenId)PythonStringTokenId.STRING_TEXT, this.input.readLength());
                        }
                        boolean nonempty = false;
                        while ((ch = this.input.read()) != -1) {
                            if (ch == 10) {
                                if (!nonempty) break;
                                this.input.backup(1);
                                return this.tokenFactory.createToken((TokenId)PythonStringTokenId.EMBEDDED_PYTHON, this.input.readLength());
                            }
                            if (Character.isWhitespace(ch)) continue;
                            nonempty = true;
                        }
                    }
                    if (this.input.readLength() > initialReadLength) {
                        this.input.backup(this.input.readLength() - initialReadLength);
                        break;
                    }
                    return this.tokenFactory.createToken((TokenId)PythonStringTokenId.STRING_TEXT, this.input.readLength());
                }
                case 92: {
                    if (this.input.readLength() > 1) {
                        this.input.backup(1);
                        return this.tokenFactory.createToken((TokenId)PythonStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    ch = this.input.read();
                    if (ch == -1) {
                        return this.tokenFactory.createToken((TokenId)PythonStringTokenId.STRING_INVALID, this.input.readLength());
                    }
                    return this.tokenFactory.createToken((TokenId)PythonStringTokenId.STRING_ESCAPE, this.input.readLength());
                }
                case 102: 
                case 104: 
                case 109: 
                case 119: {
                    if (inWord) break;
                    int originalLength = this.input.readLength();
                    boolean foundLinkBegin = false;
                    if (ch == 104) {
                        if (this.input.read() == 116) {
                            if (this.input.read() == 116) {
                                if (this.input.read() == 112) {
                                    int r = this.input.read();
                                    if (r == 58) {
                                        foundLinkBegin = true;
                                    } else if (r == 115) {
                                        if (this.input.read() == 58) {
                                            foundLinkBegin = true;
                                        } else {
                                            this.input.backup(5);
                                        }
                                    } else {
                                        this.input.backup(4);
                                    }
                                } else {
                                    this.input.backup(3);
                                }
                            } else {
                                this.input.backup(2);
                            }
                        } else {
                            this.input.backup(1);
                        }
                    } else if (ch == 102) {
                        if (this.input.read() == 116) {
                            if (this.input.read() == 112) {
                                if (this.input.read() == 58) {
                                    foundLinkBegin = true;
                                } else {
                                    this.input.backup(3);
                                }
                            } else {
                                this.input.backup(2);
                            }
                        } else {
                            this.input.backup(1);
                        }
                    } else if (ch == 109) {
                        if (this.input.read() == 97) {
                            if (this.input.read() == 105) {
                                if (this.input.read() == 108) {
                                    if (this.input.read() == 116) {
                                        if (this.input.read() == 111) {
                                            if (this.input.read() == 58) {
                                                foundLinkBegin = true;
                                            } else {
                                                this.input.backup(6);
                                            }
                                        } else {
                                            this.input.backup(5);
                                        }
                                    } else {
                                        this.input.backup(4);
                                    }
                                } else {
                                    this.input.backup(3);
                                }
                            } else {
                                this.input.backup(2);
                            }
                        } else {
                            this.input.backup(1);
                        }
                    } else if (ch == 119) {
                        if (this.input.read() == 119) {
                            if (this.input.read() == 119) {
                                if (this.input.read() == 46) {
                                    foundLinkBegin = true;
                                } else {
                                    this.input.backup(3);
                                }
                            } else {
                                this.input.backup(2);
                            }
                        } else {
                            this.input.backup(1);
                        }
                    }
                    if (!foundLinkBegin) break;
                    while (ch != -1) {
                        ch = this.input.read();
                        if (ch != 93 && ch != 41 && !Character.isWhitespace(ch) && ch != 39 && ch != 34) continue;
                        this.input.backup(1);
                        break;
                    }
                    if (originalLength > 1) {
                        this.input.backup(this.input.readLengthEOF() - originalLength + 1);
                        return this.tokenFactory.createToken((TokenId)PythonStringTokenId.STRING_TEXT, this.input.readLength());
                    }
                    if (this.input.readLength() <= 2) break;
                    return this.tokenFactory.createToken((TokenId)PythonStringTokenId.URL, this.input.readLength());
                }
            }
            inWord = Character.isJavaIdentifierPart(ch);
        }
    }

    public void release() {
    }
}

