/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.csound.orc.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public class AddSemiColonLineCommentAction
extends BaseAction {
    public static String ACTION_NAME = "add-semicolon-line-comment";
    private static String COMMENT_STRING = ";";

    public AddSemiColonLineCommentAction() {
        this.putValue("Name", ACTION_NAME);
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            doc.runAtomicAsUser(() -> {
                try {
                    int endPos;
                    int startPos;
                    if (Utilities.isSelectionShowing((Caret)caret)) {
                        startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                        endPos = target.getSelectionEnd();
                        if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                            --endPos;
                        }
                        endPos = Utilities.getRowEnd((BaseDocument)doc, (int)endPos);
                    } else {
                        startPos = Utilities.getRowStart((BaseDocument)doc, (int)caret.getDot());
                        endPos = Utilities.getRowEnd((BaseDocument)doc, (int)caret.getDot());
                    }
                    int lineCount = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos);
                    this.comment(doc, startPos, lineCount);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            });
        }
    }

    private void comment(BaseDocument doc, int startOffset, int lineCount) throws BadLocationException {
        int offset = startOffset;
        while (lineCount > 0) {
            doc.insertString(offset, COMMENT_STRING, null);
            offset = Utilities.getRowStart((BaseDocument)doc, (int)offset, (int)1);
            --lineCount;
        }
    }
}

