/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.editor.csound.orc;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public class CsoundOrcVariableCompletionItem
implements CompletionItem {
    private static String RIGHT_LABEL = "variable";
    private final String opName;

    public CsoundOrcVariableCompletionItem(String opName) {
        this.opName = opName;
    }

    public void defaultAction(JTextComponent component) {
        this.replaceWordBeforeCaret(this.opName, component);
        Completion.get().hideAll();
    }

    protected void replaceWordBeforeCaret(String replacementText, JTextComponent jtc) {
        int index1;
        int index2 = index1 = jtc.getCaretPosition();
        String text = jtc.getText();
        int len = text.length();
        for (index1 = index1 > 0 ? index1 - 1 : index1; index1 >= 0 && !Character.isWhitespace(text.charAt(index1)); --index1) {
        }
        ++index1;
        while (index2 < len && !Character.isWhitespace(text.charAt(index2))) {
            ++index2;
        }
        try {
            jtc.getDocument().remove(index1, index2 - index1);
            jtc.getDocument().insertString(index1, replacementText, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.opName, (String)RIGHT_LABEL, (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml(null, (String)this.opName, (String)RIGHT_LABEL, (Graphics)g, (Font)defaultFont, (Color)(selected ? Color.orange : Color.white), (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public int getSortPriority() {
        return -1;
    }

    public CharSequence getSortText() {
        return this.opName;
    }

    public CharSequence getInsertPrefix() {
        return this.opName;
    }
}

