/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

public class JavaImportCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        Vector<String> class_vector;
        String class_package;
        Enumeration search;
        String usage = "java::import ?-forget? ?-package pkg? ?class ...?";
        Hashtable classTable = interp.importTable[0];
        Hashtable packageTable = interp.importTable[1];
        boolean forget = false;
        String pkg = null;
        if (objv.length == 1) {
            TclObject import_list = TclList.newInstance();
            Enumeration search2 = classTable.keys();
            while (search2.hasMoreElements()) {
                String elem = (String)search2.nextElement();
                TclList.append((Interp)interp, (TclObject)import_list, (TclObject)TclString.newInstance((String)classTable.get(elem)));
            }
            interp.setResult(import_list);
            return;
        }
        int startIdx = 1;
        String elem = objv[startIdx].toString();
        if (elem.equals("-forget")) {
            forget = true;
            ++startIdx;
        }
        if (startIdx >= objv.length) {
            interp.resetResult();
            return;
        }
        elem = objv[startIdx].toString();
        if (elem.equals("-package")) {
            if (++startIdx >= objv.length) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            pkg = objv[startIdx].toString();
            if (pkg.length() == 0) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            ++startIdx;
        }
        if (startIdx >= objv.length) {
            if (forget) {
                if (pkg == null) {
                    throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
                }
                boolean found = false;
                Enumeration search3 = packageTable.keys();
                while (search3.hasMoreElements()) {
                    elem = (String)search3.nextElement();
                    if (!elem.equals(pkg)) continue;
                    if (found) {
                        throw new TclRuntimeError("unexpected : found == true");
                    }
                    found = true;
                    Enumeration search2 = ((Vector)packageTable.get(elem)).elements();
                    while (search2.hasMoreElements()) {
                        String elem2 = (String)search2.nextElement();
                        classTable.remove(elem2);
                    }
                    packageTable.remove(elem);
                }
                if (!found) {
                    throw new TclException(interp, "cannot forget package \"" + pkg + "\", no classes were imported from it");
                }
                interp.resetResult();
                return;
            }
            if (pkg == null) {
                throw new TclRuntimeError("unexpected : pkg == null");
            }
            Enumeration search4 = packageTable.keys();
            while (search4.hasMoreElements()) {
                elem = (String)search4.nextElement();
                if (!elem.equals(pkg)) continue;
                TclObject import_list = TclList.newInstance();
                Enumeration search2 = ((Vector)packageTable.get(elem)).elements();
                while (search2.hasMoreElements()) {
                    String elem2 = (String)search2.nextElement();
                    TclList.append((Interp)interp, (TclObject)import_list, (TclObject)TclString.newInstance((String)classTable.get(elem2)));
                }
                interp.setResult(import_list);
                return;
            }
            interp.resetResult();
            return;
        }
        Vector<String> importClasses = new Vector<String>();
        Vector<String> forgetClasses = new Vector<String>();
        String operation = "import";
        if (forget) {
            operation = "forget";
        }
        TclClassLoader tclClassLoader = new TclClassLoader(interp, null);
        for (int i = startIdx; i < objv.length; ++i) {
            elem = objv[i].toString();
            if (elem.length() == 0 || elem.equals("-forget") || elem.equals("-package")) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            if (pkg != null && elem.indexOf(46) != -1) {
                throw new TclException(interp, "class argument must not contain a package specifier when the -package pkg arguments are given");
            }
            if (elem.equals("int") || elem.equals("boolean") || elem.equals("long") || elem.equals("float") || elem.equals("double") || elem.equals("byte") || elem.equals("short") || elem.equals("char")) {
                throw new TclException(interp, "cannot " + operation + " primitive type \"" + elem + "\"");
            }
            String fullyqualified = pkg == null ? elem : pkg + "." + elem;
            int ind = fullyqualified.lastIndexOf(46);
            if (ind == -1) {
                throw new TclException(interp, "cannot " + operation + " from global package");
            }
            String class_package2 = fullyqualified.substring(0, ind);
            String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
            if (class_package2.equals("java.lang")) {
                throw new TclException(interp, "cannot " + operation + " class \"" + fullyqualified + "\", it is in the java.lang package");
            }
            if (!forget) {
                boolean inGlobal = true;
                try {
                    tclClassLoader.loadClass(class_name);
                }
                catch (ClassNotFoundException e) {
                    inGlobal = false;
                    tclClassLoader.removeCache(class_name);
                }
                if (inGlobal) {
                    throw new TclException(interp, "cannot import \"" + fullyqualified + "\" it conflicts with a class with the same name" + " in the global package");
                }
                TclException notfound = new TclException(interp, "cannot import class \"" + fullyqualified + "\", it does not exist");
                try {
                    Class<?> c = tclClassLoader.loadClass(fullyqualified);
                    if (!PkgInvoker.isAccessible(c)) {
                        throw new TclException(interp, "Class \"" + c.getName() + "\" is not accessible");
                    }
                }
                catch (ClassNotFoundException e) {
                    throw notfound;
                }
                catch (SecurityException e) {
                    throw notfound;
                }
            }
            if (forget && classTable.get(class_name) == null) {
                throw new TclException(interp, "cannot forget class \"" + fullyqualified + "\", it was never imported");
            }
            if (forget) {
                forgetClasses.addElement(fullyqualified);
                continue;
            }
            importClasses.addElement(fullyqualified);
        }
        if (forgetClasses.size() != 0 && importClasses.size() != 0) {
            throw new TclRuntimeError("unexpected : forgetClasses and importClasses are both nonempty");
        }
        boolean debug = false;
        if (forgetClasses.size() != 0) {
            search = forgetClasses.elements();
            while (search.hasMoreElements()) {
                String fullyqualified = (String)search.nextElement();
                int ind = fullyqualified.lastIndexOf(46);
                if (ind == -1) {
                    throw new TclRuntimeError("unexpected : no package in forget class");
                }
                class_package = fullyqualified.substring(0, ind);
                String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
                class_vector = (Vector<String>)packageTable.get(class_package);
                if (!class_vector.removeElement(class_name)) {
                    throw new TclRuntimeError("unexpected : class not found in package vector");
                }
                if (class_vector.size() == 0) {
                    packageTable.remove(class_package);
                }
                classTable.remove(class_name);
            }
        }
        if (importClasses.size() != 0) {
            search = importClasses.elements();
            while (search.hasMoreElements()) {
                String fullyqualified = (String)search.nextElement();
                int ind = fullyqualified.lastIndexOf(46);
                if (ind == -1) {
                    throw new TclRuntimeError("unexpected : no package in import class");
                }
                class_package = fullyqualified.substring(0, ind);
                String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
                if (classTable.get(class_name) != null) continue;
                classTable.put(class_name, fullyqualified);
                class_vector = (Vector)packageTable.get(class_package);
                if (class_vector == null) {
                    class_vector = new Vector<String>();
                    packageTable.put(class_package, class_vector);
                }
                class_vector.addElement(class_name);
            }
        }
        interp.resetResult();
    }

    public static String getImport(Interp interp, String name) {
        Hashtable classTable = interp.importTable[0];
        return (String)classTable.get(name);
    }
}

