/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.scratchPad;

import blue.BlueData;
import blue.ScratchPadData;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ScratchPadTopComponent", persistenceType=0)
public final class ScratchPadTopComponent
extends TopComponent {
    private static ScratchPadTopComponent instance;
    private ScratchPadData scratchPadData = null;
    private JScrollPane jScrollPane1;
    private JTextArea scratchPadText;
    private JCheckBox wordWrapEnabledCheckBox;

    private ScratchPadTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ScratchPadTopComponent.class, (String)"CTL_ScratchPadTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ScratchPadTopComponent.class, (String)"HINT_ScratchPadTopComponent"));
        this.scratchPadText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (ScratchPadTopComponent.this.scratchPadData != null) {
                    ScratchPadTopComponent.this.scratchPadData.setScratchText(ScratchPadTopComponent.this.scratchPadText.getText());
                }
            }
        });
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.reinitialize();
    }

    private void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project != null) {
            BlueData currentData = project.getData();
            this.setScratchPadData(currentData.getScratchPadData());
        } else {
            this.setScratchPadData(null);
        }
    }

    private void setScratchPadData(ScratchPadData scratchPadData) {
        this.scratchPadData = null;
        if (scratchPadData != null) {
            this.scratchPadText.setText(scratchPadData.getScratchText());
            this.wordWrapEnabledCheckBox.setSelected(scratchPadData.isWordWrapEnabled());
            this.scratchPadText.setLineWrap(scratchPadData.isWordWrapEnabled());
            this.wordWrapEnabledCheckBox.setEnabled(true);
            this.scratchPadText.setEnabled(true);
        } else {
            this.scratchPadText.setText("");
            this.wordWrapEnabledCheckBox.setEnabled(false);
            this.scratchPadText.setEnabled(false);
        }
        this.scratchPadData = scratchPadData;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.scratchPadText = new JTextArea();
        this.wordWrapEnabledCheckBox = new JCheckBox();
        this.scratchPadText.setColumns(20);
        this.scratchPadText.setRows(5);
        this.jScrollPane1.setViewportView(this.scratchPadText);
        Mnemonics.setLocalizedText((AbstractButton)this.wordWrapEnabledCheckBox, (String)NbBundle.getMessage(ScratchPadTopComponent.class, (String)"ScratchPadTopComponent.wordWrapEnabledCheckBox.text"));
        this.wordWrapEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScratchPadTopComponent.this.wordWrapEnabledCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.wordWrapEnabledCheckBox).addContainerGap(301, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 417, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 263, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wordWrapEnabledCheckBox).addContainerGap()));
    }

    private void wordWrapEnabledCheckBoxActionPerformed(ActionEvent evt) {
        this.scratchPadText.setLineWrap(this.wordWrapEnabledCheckBox.isSelected());
        if (this.scratchPadData != null) {
            this.scratchPadData.setWordWrapEnabled(this.wordWrapEnabledCheckBox.isSelected());
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

