/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.ui.core.score.undo.MoveScoreObjectsEdit;
import blue.undo.BlueUndoManager;
import java.util.Collection;
import javax.swing.undo.UndoableEdit;

public class NudgeUtils {
    public static void nudgeHorizontal(double timeValue, Collection<? extends ScoreObject> scoreObjects) {
        if (scoreObjects == null || scoreObjects.size() == 0) {
            return;
        }
        double adjustedTime = timeValue;
        if (timeValue < 0.0) {
            for (ScoreObject scoreObject : scoreObjects) {
                double start = scoreObject.getStartTime();
                if (start == 0.0) {
                    return;
                }
                if (!(adjustedTime < -start)) continue;
                adjustedTime = -start;
            }
        }
        int len = scoreObjects.size();
        ScoreObject[] scoreObjectArray = scoreObjects.toArray(new ScoreObject[scoreObjects.size()]);
        double[] startTimes = new double[len];
        double[] endTimes = new double[len];
        for (int i = 0; i < scoreObjectArray.length; ++i) {
            ScoreObject scoreObj = scoreObjectArray[i];
            startTimes[i] = scoreObj.getStartTime();
            endTimes[i] = scoreObj.getStartTime() + adjustedTime;
            scoreObj.setStartTime(endTimes[i]);
        }
        MoveScoreObjectsEdit edit = new MoveScoreObjectsEdit(scoreObjectArray, null, null, startTimes, endTimes);
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit((UndoableEdit)edit);
    }
}

