/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.soundObject.Instance;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.utilities.FileChooserManager;
import electric.xml.Element;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class ExportAction
extends AbstractAction
implements ContextAwareAction {
    private static final String EXPORT_DIALOG = "sObj.export";
    private final Collection<? extends ScoreObject> scoreObjects;
    private final Collection<? extends SoundObject> soundObjects;

    public ExportAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportAction(Lookup lookup) {
        super(NbBundle.getMessage(ExportAction.class, (String)"CTL_ExportAction"));
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
        this.soundObjects = lookup.lookupAll(SoundObject.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File retVal;
        if (this.scoreObjects.size() == 1 && this.soundObjects.size() == 1 && (retVal = FileChooserManager.getDefault().showSaveDialog((Object)EXPORT_DIALOG, (Component)WindowManager.getDefault().getMainWindow())) != null) {
            int overWrite;
            File f = retVal;
            if (f.exists() && (overWrite = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(WindowManager.getDefault().getMainWindow()), "Please confirm you would like to overwrite this file.")) != 0) {
                return;
            }
            SoundObject sObj = this.soundObjects.iterator().next();
            if (sObj instanceof Instance || sObj instanceof PolyObject && this.containsInstance((PolyObject)sObj)) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Error: Export of Instance or PolyObjects containing Instance is not allowed.", "Error", 0);
                return;
            }
            Element node = sObj.saveAsXML(null);
            try {
                PrintWriter out = new PrintWriter(new FileWriter(f));
                out.print(node.toString());
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected boolean containsInstance(PolyObject pObj) {
        List soundObjects = pObj.getSoundObjects(true);
        for (SoundObject sObj : soundObjects) {
            if (!(sObj instanceof PolyObject ? this.containsInstance((PolyObject)sObj) : sObj instanceof Instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.scoreObjects.size() == 1 && this.soundObjects.size() == 1;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ExportAction(actionContext);
    }
}

