/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject.actions;

import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.layers.soundObject.actions.SelectLayerAction;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class SelectAllAfterAction
extends AbstractAction
implements ContextAwareAction {
    final Point p;
    private final ScorePath scorePath;
    private final TimeState timeState;

    public SelectAllAfterAction() {
        this(Utilities.actionsGlobalContext());
    }

    private SelectAllAfterAction(Lookup lookup) {
        super(NbBundle.getMessage(SelectLayerAction.class, (String)"CTL_SelectAllAfterAction"));
        this.p = (Point)lookup.lookup(Point.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
        this.timeState = (TimeState)lookup.lookup(TimeState.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        float pointTime = (float)this.p.x / (float)this.timeState.getPixelSecond();
        ArrayList<ScoreObject> newSelected = new ArrayList<ScoreObject>();
        List<Layer> allLayers = this.scorePath.getAllLayers();
        for (Layer layer : allLayers) {
            if (!(layer instanceof ScoreObjectLayer)) continue;
            ScoreObjectLayer sLayer = (ScoreObjectLayer)layer;
            for (ScoreObject scoreObject : sLayer) {
                if (!(scoreObject.getStartTime() >= (double)pointTime)) continue;
                newSelected.add(scoreObject);
            }
        }
        ScoreController.getInstance().setSelectedScoreObjects(newSelected);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SelectAllAfterAction(actionContext);
    }
}

