/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.midi;

import blue.BlueData;
import blue.InstrumentAssignment;
import blue.midi.MidiInputProcessor;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.ui.core.blueLive.BlueLiveToolBar;
import java.util.ArrayList;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public final class MidiInputEngine
implements Receiver {
    private static MidiInputEngine instance = new MidiInputEngine();
    private static BlueLiveToolBar toolbar;
    private ArrayList<InstrumentAssignment> arrangement;
    private MidiInputProcessor processor = null;

    public static MidiInputEngine getInstance() {
        return instance;
    }

    private MidiInputEngine() {
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
    }

    protected void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        BlueData data = null;
        if (project != null) {
            data = project.getData();
            this.arrangement = data.getArrangement().getArrangement();
            this.processor = data.getMidiInputProcessor();
        }
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (message instanceof ShortMessage) {
            ShortMessage shortMsg = (ShortMessage)message;
            int channel = shortMsg.getChannel();
            int noteNum = shortMsg.getData1();
            int velocity = shortMsg.getData2();
            if (this.processor == null || this.arrangement == null || channel >= this.arrangement.size()) {
                return;
            }
            String id = this.arrangement.get((int)channel).arrangementId;
            String score = "i";
            switch (shortMsg.getCommand()) {
                case 144: {
                    if (velocity > 0) {
                        score = this.processor.getNoteOn(id, noteNum, noteNum, velocity);
                        break;
                    }
                    score = this.processor.getNoteOff(id, noteNum);
                    break;
                }
                case 128: {
                    score = this.processor.getNoteOff(id, noteNum);
                }
            }
            System.err.println(score);
            if (toolbar == null) {
                toolbar = BlueLiveToolBar.getInstance();
            }
            toolbar.sendEvents(score);
        }
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

