/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.blueLive;

import blue.BlueData;
import blue.BlueSystem;
import blue.CompileData;
import blue.LiveData;
import blue.blueLive.LiveObject;
import blue.blueLive.LiveObjectBins;
import blue.blueLive.LiveObjectSet;
import blue.blueLive.LiveObjectSetList;
import blue.midi.MidiInputManager;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.score.ScoreObject;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.ui.core.blueLive.BlueLiveToolBar;
import blue.ui.core.blueLive.LiveObjectRenderer;
import blue.ui.core.blueLive.LiveObjectSetListTableModel;
import blue.ui.core.blueLive.LiveObjectsTableModel;
import blue.ui.core.blueLive.ScoPadReceiver;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.layers.SoundObjectProvider;
import blue.ui.nbutilities.lazyplugin.AttributeFilter;
import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import blue.ui.utilities.SimpleDocumentListener;
import blue.ui.utilities.UiUtilities;
import blue.utility.ScoreUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import skt.swing.SwingUtil;

@TopComponent.Description(preferredID="BlueLiveTopComponent", persistenceType=0)
public final class BlueLiveTopComponent
extends TopComponent
implements SoundObjectProvider {
    private static BlueLiveTopComponent instance;
    private final InstanceContent content = new InstanceContent();
    private static final String PREFERRED_ID = "BlueLiveTopComponent";
    BlueData data = null;
    LiveObjectsTableModel model;
    LiveObjectSetListTableModel setModel;
    BufferMenu bufferPopup;
    SetsBufferMenu setsBufferPopup;
    MidiInputManager midiManager;
    ScoPadReceiver scoPadReceiver = new ScoPadReceiver();
    JPopupMenu noteTemplatePopup;
    BlueLiveToolBar blueLiveToolBar;
    int mouseColumn = -1;
    int mouseRow = -1;
    Map<Class<? extends SoundObject>, String> liveSoundObjectTemplates;
    CompileData compileData = CompileData.createEmptyCompileData();
    private JPanel bottomPanel;
    private JButton buttonAdd;
    private JButton buttonDown;
    private JButton buttonRemove;
    private JButton buttonUp;
    private JTextField commandLineText;
    private JCheckBox completeOverride;
    private JCheckBox enableAdvancedFlags;
    private JTextField instrIdText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTable liveObjectSetListTable;
    private JTable liveObjectsTable;
    private JPanel liveSpacePanel;
    private JTextField noteTemplateText;
    private JTextArea outputTextArea;
    private JSpinner quarterNoteSpinner;
    private JToggleButton repeatButton;
    private JSpinner repeatSpinner;
    private JPanel scoPadPanel;
    private JSpinner startSpinner;
    private JSpinner tempoSpinner;
    private JButton triggerButton;

    public BlueLiveTopComponent() {
        List plugins = LazyPluginFactory.loadPlugins((String)"blue/score/soundObjects", SoundObject.class, (LazyPluginFactory.Filter)new AttributeFilter("live"));
        this.liveSoundObjectTemplates = new HashMap<Class<? extends SoundObject>, String>();
        for (LazyPlugin plugin : plugins) {
            this.liveSoundObjectTemplates.put(((SoundObject)plugin.getInstance()).getClass(), plugin.getDisplayName());
        }
        this.initComponents();
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.content));
        this.setName(NbBundle.getMessage(BlueLiveTopComponent.class, (String)"CTL_BlueLiveTopComponent"));
        this.setToolTipText(NbBundle.getMessage(BlueLiveTopComponent.class, (String)"HINT_BlueLiveTopComponent"));
        this.blueLiveToolBar = BlueLiveToolBar.getInstance();
        this.setupNoteTemplatePopup();
        this.model = new LiveObjectsTableModel();
        this.setModel = new LiveObjectSetListTableModel();
        final LiveObjectRenderer liveObjectRenderer = new LiveObjectRenderer();
        this.liveObjectsTable.setDefaultRenderer(LiveObject.class, liveObjectRenderer);
        this.liveObjectsTable.setModel(this.model);
        this.liveObjectsTable.setRowHeight(24);
        this.liveObjectsTable.setSelectionMode(0);
        this.liveObjectsTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int column;
                if (this.data == null) {
                    return;
                }
                int row = this.liveObjectsTable.getSelectedRow();
                LiveObject lObj = (LiveObject)this.model.getValueAt(row, column = this.liveObjectsTable.getSelectedColumn());
                if (lObj != null) {
                    SwingUtilities.invokeLater(() -> this.content.set(Collections.singleton(lObj.getSoundObject()), null));
                } else {
                    SwingUtilities.invokeLater(() -> this.content.set(Collections.emptyList(), null));
                }
            }
        });
        this.liveObjectsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    if (BlueLiveTopComponent.this.bufferPopup == null) {
                        BlueLiveTopComponent.this.bufferPopup = new BufferMenu();
                    }
                    BlueLiveTopComponent.this.mouseRow = BlueLiveTopComponent.this.liveObjectsTable.rowAtPoint(e.getPoint());
                    BlueLiveTopComponent.this.mouseColumn = BlueLiveTopComponent.this.liveObjectsTable.columnAtPoint(e.getPoint());
                    BlueLiveTopComponent.this.bufferPopup.show(BlueLiveTopComponent.this.liveObjectsTable, e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    BlueLiveTopComponent.this.mouseRow = BlueLiveTopComponent.this.liveObjectsTable.rowAtPoint(e.getPoint());
                    BlueLiveTopComponent.this.mouseColumn = BlueLiveTopComponent.this.liveObjectsTable.columnAtPoint(e.getPoint());
                    LiveObject lObj = (LiveObject)BlueLiveTopComponent.this.liveObjectsTable.getValueAt(BlueLiveTopComponent.this.mouseRow, BlueLiveTopComponent.this.mouseColumn);
                    if (lObj != null) {
                        lObj.setEnabled(!lObj.isEnabled());
                        BlueLiveTopComponent.this.liveObjectsTable.repaint();
                    }
                }
            }
        });
        this.liveObjectsTable.setColumnSelectionAllowed(true);
        this.liveObjectSetListTable.setModel(this.setModel);
        this.liveObjectSetListTable.setRowHeight(24);
        this.liveObjectSetListTable.setSelectionMode(0);
        this.liveObjectSetListTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.data == null) {
                    return;
                }
                int row = this.liveObjectSetListTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                LiveObjectSet lObjSet = (LiveObjectSet)this.data.getLiveData().getLiveObjectSets().get(row);
                if (lObjSet != null) {
                    this.model.setEnabled(lObjSet);
                }
            }
        });
        this.liveObjectSetListTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = BlueLiveTopComponent.this.liveObjectSetListTable.rowAtPoint(e.getPoint());
                if (row < BlueLiveTopComponent.this.setModel.getRowCount()) {
                    LiveObjectSet lObjSet = (LiveObjectSet)BlueLiveTopComponent.this.data.getLiveData().getLiveObjectSets().get(row);
                    liveObjectRenderer.setLiveObjectSet(lObjSet);
                    if (lObjSet != null) {
                        BlueLiveTopComponent.this.liveObjectsTable.repaint();
                    }
                }
            }
        });
        this.liveObjectSetListTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                liveObjectRenderer.setLiveObjectSet(null);
                BlueLiveTopComponent.this.liveObjectsTable.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    if (BlueLiveTopComponent.this.setsBufferPopup == null) {
                        BlueLiveTopComponent.this.setsBufferPopup = new SetsBufferMenu();
                    }
                    BlueLiveTopComponent.this.mouseRow = BlueLiveTopComponent.this.liveObjectSetListTable.rowAtPoint(e.getPoint());
                    BlueLiveTopComponent.this.mouseColumn = BlueLiveTopComponent.this.liveObjectSetListTable.columnAtPoint(e.getPoint());
                    BlueLiveTopComponent.this.setsBufferPopup.show(BlueLiveTopComponent.this.liveObjectSetListTable, e.getX(), e.getY());
                }
            }
        });
        this.commandLineText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (BlueLiveTopComponent.this.data == null) {
                    return;
                }
                BlueLiveTopComponent.this.data.getLiveData().setCommandLine(BlueLiveTopComponent.this.commandLineText.getText());
            }
        });
        this.midiManager = MidiInputManager.getInstance();
        this.midiManager.addReceiver(new Receiver(){

            @Override
            public void send(MidiMessage message, long timeStamp) {
                if (BlueLiveTopComponent.this.jTabbedPane1.getSelectedIndex() != 0) {
                    return;
                }
            }

            @Override
            public void close() {
            }
        });
        this.midiManager.addReceiver((Receiver)this.scoPadReceiver);
        this.startSpinner.setModel(new SpinnerNumberModel(0.0, 0.0, Double.POSITIVE_INFINITY, 1.0));
        this.quarterNoteSpinner.setModel(new SpinnerNumberModel(1.0, 0.0, Double.POSITIVE_INFINITY, 1.0));
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.reinitialize();
        AbstractAction singleTrigger = new AbstractAction("trigger-single"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveObject liveObject = (LiveObject)BlueLiveTopComponent.this.liveObjectsTable.getValueAt(BlueLiveTopComponent.this.liveObjectsTable.getSelectedRow(), BlueLiveTopComponent.this.liveObjectsTable.getSelectedColumn());
                if (liveObject != null) {
                    BlueLiveTopComponent.this.triggerLiveObject(liveObject);
                }
            }
        };
        singleTrigger.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()));
        AbstractAction multiTrigger = new AbstractAction("trigger-multi"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlueLiveTopComponent.this.triggerButtonActionPerformed(null);
            }
        };
        multiTrigger.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey() | 0x40));
        AbstractAction copyObj = new AbstractAction("copy-obj"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveObject lObj = (LiveObject)BlueLiveTopComponent.this.liveObjectsTable.getValueAt(BlueLiveTopComponent.this.liveObjectsTable.getSelectedRow(), BlueLiveTopComponent.this.liveObjectsTable.getSelectedColumn());
                if (lObj != null) {
                    SoundObject copy = lObj.getSoundObject().deepCopy();
                    ScoreController.ScoreObjectBuffer scoreObjectBuffer = ScoreController.getInstance().getScoreObjectBuffer();
                    scoreObjectBuffer.clear();
                    scoreObjectBuffer.scoreObjects.add((ScoreObject)copy);
                    scoreObjectBuffer.layerIndexes.add(0);
                }
            }
        };
        copyObj.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, BlueSystem.getMenuShortcutKey()));
        AbstractAction pasteObj = new AbstractAction("paste-obj"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScoreController.ScoreObjectBuffer scoreObjectBuffer = ScoreController.getInstance().getScoreObjectBuffer();
                if (scoreObjectBuffer.scoreObjects.size() != 1) {
                    return;
                }
                ScoreObject scoreObj = scoreObjectBuffer.scoreObjects.get(0);
                if (!(scoreObj instanceof SoundObject)) {
                    return;
                }
                SoundObject sObj = (SoundObject)scoreObj;
                int row = BlueLiveTopComponent.this.liveObjectsTable.getSelectedRow();
                int column = BlueLiveTopComponent.this.liveObjectsTable.getSelectedColumn();
                if (sObj == null || !BlueLiveTopComponent.this.liveSoundObjectTemplates.containsKey(sObj.getClass()) || row < 0 || column < 0) {
                    return;
                }
                SoundObject copy = sObj.deepCopy();
                copy.setStartTime(0.0);
                BlueLiveTopComponent.this.addSoundObject(column, row, copy);
            }
        };
        pasteObj.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, BlueSystem.getMenuShortcutKey()));
        SwingUtil.installActions((JComponent)this.liveObjectsTable, (Action[])new Action[]{singleTrigger, multiTrigger, copyObj, pasteObj});
    }

    private void reinitialize() {
        this.data = null;
        this.compileData = CompileData.createEmptyCompileData();
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        BlueData currentData = null;
        if (project != null) {
            currentData = project.getData();
        }
        if (currentData != null) {
            LiveData liveData = currentData.getLiveData();
            this.liveObjectsTable.setAutoCreateColumnsFromModel(true);
            this.model.setLiveObjectBins(liveData.getLiveObjectBins());
            this.setModel.setLiveObjectSetList(liveData.getLiveObjectSets());
            this.liveObjectsTable.setModel(this.model);
            this.liveObjectSetListTable.setModel(this.setModel);
            this.commandLineText.setText(liveData.getCommandLine());
            this.enableAdvancedFlags.setSelected(liveData.isCommandLineEnabled());
            this.completeOverride.setSelected(liveData.isCommandLineOverride());
            this.repeatButton.setSelected(liveData.isRepeatEnabled());
            this.commandLineText.setEnabled(liveData.isCommandLineEnabled());
            this.repeatSpinner.setValue(liveData.getRepeat());
            this.tempoSpinner.setValue(liveData.getTempo());
            this.data = currentData;
            this.repaint();
        }
    }

    protected void triggerLiveObject(LiveObject liveObject) {
        NoteList nl = null;
        try {
            SoundObject sObj = liveObject.getSoundObject();
            if (sObj.getTimeBehavior() != -1) {
                sObj.setTimeBehavior(2);
            }
            nl = sObj.generateForCSD(this.compileData, 0.0, -1.0);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (nl == null) {
            return;
        }
        int tempo = (Integer)this.tempoSpinner.getValue();
        ScoreUtilities.scaleScore((NoteList)nl, (double)(60.0f / (float)tempo));
        String scoreText = nl.toString();
        if (scoreText != null && scoreText.length() > 0) {
            this.blueLiveToolBar.sendEvents(scoreText);
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.liveSpacePanel = new JPanel();
        this.triggerButton = new JButton();
        this.jLabel6 = new JLabel();
        this.tempoSpinner = new JSpinner();
        this.jLabel7 = new JLabel();
        this.repeatSpinner = new JSpinner();
        this.repeatButton = new JToggleButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.liveObjectsTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }
        };
        this.jPanel2 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.liveObjectSetListTable = new JTable();
        this.bottomPanel = new JPanel();
        this.buttonUp = new JButton();
        this.buttonDown = new JButton();
        this.buttonAdd = new JButton();
        this.buttonRemove = new JButton();
        this.scoPadPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.startSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.outputTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.noteTemplateText = new JTextField();
        this.jLabel2 = new JLabel();
        this.quarterNoteSpinner = new JSpinner();
        this.jLabel5 = new JLabel();
        this.instrIdText = new JTextField();
        this.jPanel1 = new JPanel();
        this.completeOverride = new JCheckBox();
        this.commandLineText = new JTextField();
        this.enableAdvancedFlags = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.triggerButton, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.triggerButton.text"));
        this.triggerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlueLiveTopComponent.this.triggerButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.jLabel6.text"));
        this.tempoSpinner.setModel(new SpinnerNumberModel(60, 1, 300, 1));
        this.tempoSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BlueLiveTopComponent.this.tempoSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.jLabel7.text"));
        this.repeatSpinner.setModel(new SpinnerNumberModel(4, 1, 256, 1));
        this.repeatSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BlueLiveTopComponent.this.repeatSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.repeatButton, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.repeatButton.text"));
        this.repeatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlueLiveTopComponent.this.repeatButtonActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(200);
        this.liveObjectsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.liveObjectsTable);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jPanel2.setLayout(new BorderLayout());
        this.liveObjectSetListTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView(this.liveObjectSetListTable);
        this.jPanel2.add((Component)this.jScrollPane3, "Center");
        this.bottomPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 17));
        this.bottomPanel.setPreferredSize(new Dimension(100, 17));
        this.bottomPanel.setLayout(new GridLayout(1, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonUp, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.buttonUp.text"));
        this.buttonUp.setFocusPainted(false);
        this.buttonUp.setFocusable(false);
        this.buttonUp.setMargin(new Insets(0, 1, 0, 1));
        this.buttonUp.setMinimumSize(new Dimension(15, 15));
        this.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlueLiveTopComponent.this.buttonUpActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.buttonUp);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDown, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.buttonDown.text"));
        this.buttonDown.setFocusPainted(false);
        this.buttonDown.setFocusable(false);
        this.buttonDown.setMargin(new Insets(0, 1, 1, 1));
        this.buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlueLiveTopComponent.this.buttonDownActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.buttonDown);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonAdd, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.buttonAdd.text"));
        this.buttonAdd.setFocusPainted(false);
        this.buttonAdd.setFocusable(false);
        this.buttonAdd.setMargin(new Insets(0, 1, 1, 1));
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlueLiveTopComponent.this.buttonAddActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.buttonAdd);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonRemove, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.buttonRemove.text"));
        this.buttonRemove.setFocusPainted(false);
        this.buttonRemove.setFocusable(false);
        this.buttonRemove.setMargin(new Insets(0, 1, 1, 1));
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlueLiveTopComponent.this.buttonRemoveActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.buttonRemove);
        this.jPanel2.add((Component)this.bottomPanel, "South");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        GroupLayout liveSpacePanelLayout = new GroupLayout(this.liveSpacePanel);
        this.liveSpacePanel.setLayout(liveSpacePanelLayout);
        liveSpacePanelLayout.setHorizontalGroup(liveSpacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, liveSpacePanelLayout.createSequentialGroup().addContainerGap().addGroup(liveSpacePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSplitPane1, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, liveSpacePanelLayout.createSequentialGroup().addGroup(liveSpacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(liveSpacePanelLayout.createSequentialGroup().addGap(124, 124, 124).addComponent(this.jLabel7)).addGroup(liveSpacePanelLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tempoSpinner, -2, 69, -2).addGap(58, 58, 58).addComponent(this.repeatSpinner, -2, 71, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repeatButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 138, Short.MAX_VALUE).addComponent(this.triggerButton))).addContainerGap()));
        liveSpacePanelLayout.setVerticalGroup(liveSpacePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(liveSpacePanelLayout.createSequentialGroup().addContainerGap().addGroup(liveSpacePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.triggerButton).addComponent(this.repeatButton).addComponent(this.repeatSpinner, -2, -1, -2).addComponent(this.tempoSpinner, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jLabel6, -2, 29, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 560, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.liveSpacePanel.TabConstraints.tabTitle"), this.liveSpacePanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.jLabel4.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.jLabel3.text"));
        this.outputTextArea.setColumns(20);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setRows(5);
        this.outputTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                BlueLiveTopComponent.this.outputTextAreaKeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.outputTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.jLabel1.text"));
        this.noteTemplateText.setText(NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.noteTemplateText.text"));
        this.noteTemplateText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BlueLiveTopComponent.this.noteTemplateTextMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.jLabel5.text"));
        this.instrIdText.setText(NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.instrIdText.text"));
        GroupLayout scoPadPanelLayout = new GroupLayout(this.scoPadPanel);
        this.scoPadPanel.setLayout(scoPadPanelLayout);
        scoPadPanelLayout.setHorizontalGroup(scoPadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scoPadPanelLayout.createSequentialGroup().addContainerGap().addGroup(scoPadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 566, Short.MAX_VALUE).addComponent(this.jLabel3).addGroup(scoPadPanelLayout.createSequentialGroup().addGroup(scoPadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(scoPadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scoPadPanelLayout.createSequentialGroup().addComponent(this.instrIdText, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startSpinner, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.quarterNoteSpinner, -2, 84, -2)).addComponent(this.noteTemplateText, -1, 468, Short.MAX_VALUE)))).addContainerGap()));
        scoPadPanelLayout.setVerticalGroup(scoPadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scoPadPanelLayout.createSequentialGroup().addContainerGap().addGroup(scoPadPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.noteTemplateText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(scoPadPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.startSpinner, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.quarterNoteSpinner, -2, -1, -2).addComponent(this.instrIdText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 387, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.scoPadPanel.TabConstraints.tabTitle"), this.scoPadPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.completeOverride, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.completeOverride.text"));
        this.completeOverride.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.completeOverride.setMargin(new Insets(0, 0, 0, 0));
        this.completeOverride.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlueLiveTopComponent.this.completeOverrideActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enableAdvancedFlags, (String)NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.enableAdvancedFlags.text"));
        this.enableAdvancedFlags.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableAdvancedFlags.setMargin(new Insets(0, 0, 0, 0));
        this.enableAdvancedFlags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlueLiveTopComponent.this.enableAdvancedFlagsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.enableAdvancedFlags).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.completeOverride).addComponent(this.commandLineText, -1, 432, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableAdvancedFlags).addComponent(this.commandLineText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.completeOverride).addContainerGap(427, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(BlueLiveTopComponent.class, (String)"BlueLiveTopComponent.jPanel1.TabConstraints.tabTitle"), this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 535, Short.MAX_VALUE).addContainerGap()));
    }

    private void completeOverrideActionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        this.data.getLiveData().setCommandLineOverride(this.completeOverride.isSelected());
    }

    private void enableAdvancedFlagsActionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        this.data.getLiveData().setCommandLineEnabled(this.enableAdvancedFlags.isSelected());
        this.commandLineText.setEnabled(this.enableAdvancedFlags.isSelected());
    }

    private void outputTextAreaKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        double time = 0.0;
        if ((evt.getModifiers() & BlueSystem.getMenuShortcutKey()) == BlueSystem.getMenuShortcutKey()) {
            switch (key) {
                default: 
            }
            return;
        }
        switch (key) {
            case 46: {
                return;
            }
            case 48: {
                return;
            }
            case 49: {
                time = 0.125;
                break;
            }
            case 50: {
                time = 0.25;
                break;
            }
            case 51: {
                time = 0.5;
                break;
            }
            case 52: {
                time = 1.0;
                break;
            }
            case 53: {
                time = 2.0;
                break;
            }
            case 54: {
                time = 4.0;
                break;
            }
            case 55: {
                time = 8.0;
                break;
            }
            case 56: {
                return;
            }
            case 57: {
                return;
            }
            default: {
                return;
            }
        }
        double start = (Double)this.startSpinner.getValue();
        String template = this.noteTemplateText.getText();
        String instrId = this.instrIdText.getText();
        double quarterNote = (Double)this.quarterNoteSpinner.getValue();
        double dur = quarterNote * time;
        this.outputTextArea.setText(this.outputTextArea.getText() + this.scoPadReceiver.getNotes(template, instrId, start, dur));
        this.startSpinner.setValue(new Double(start + dur));
    }

    private void noteTemplateTextMousePressed(MouseEvent evt) {
        if (UiUtilities.isRightMouseButton((MouseEvent)evt)) {
            this.noteTemplatePopup.show(this.noteTemplateText, evt.getX(), evt.getY());
        }
    }

    private void triggerButtonActionPerformed(ActionEvent evt) {
        if (this.data == null) {
            return;
        }
        LiveObjectSet liveObjects = this.data.getLiveData().getLiveObjectBins().getEnabledLiveObjectSet();
        if (liveObjects.size() > 0) {
            System.out.println("LiveObjectsSize: " + liveObjects.size());
            NoteList nl = new NoteList();
            try {
                for (LiveObject liveObj : liveObjects) {
                    SoundObject sObj = liveObj.getSoundObject();
                    if (sObj.getTimeBehavior() != -1) {
                        sObj.setTimeBehavior(2);
                    }
                    nl.addAll((Collection)sObj.generateForCSD(this.compileData, 0.0, -1.0));
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            int tempo = (Integer)this.tempoSpinner.getValue();
            ScoreUtilities.scaleScore((NoteList)nl, (double)(60.0f / (float)tempo));
            String scoreText = nl.toString();
            if (scoreText != null && scoreText.length() > 0) {
                this.blueLiveToolBar.sendEvents(scoreText);
            }
        }
    }

    private void repeatButtonActionPerformed(ActionEvent evt) {
        if (this.data != null) {
            this.data.getLiveData().setRepeatEnabled(this.repeatButton.isSelected());
        }
    }

    private void tempoSpinnerStateChanged(ChangeEvent evt) {
        if (this.data == null) {
            return;
        }
        this.data.getLiveData().setTempo(((Integer)this.tempoSpinner.getValue()).intValue());
    }

    private void repeatSpinnerStateChanged(ChangeEvent evt) {
        if (this.data == null) {
            return;
        }
        this.data.getLiveData().setRepeat(((Integer)this.repeatSpinner.getValue()).intValue());
    }

    private void buttonUpActionPerformed(ActionEvent evt) {
        int row = this.liveObjectSetListTable.getSelectedRow();
        if (row >= 1 && row < this.setModel.getRowCount()) {
            this.setModel.pushUpSet(row);
            this.liveObjectSetListTable.setRowSelectionInterval(row - 1, row - 1);
        }
    }

    private void buttonDownActionPerformed(ActionEvent evt) {
        int row = this.liveObjectSetListTable.getSelectedRow();
        if (row >= 0 && row < this.setModel.getRowCount() - 1) {
            this.setModel.pushDownSet(row);
            this.liveObjectSetListTable.setRowSelectionInterval(row + 1, row + 1);
        }
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        if (this.data != null) {
            LiveData liveData = this.data.getLiveData();
            LiveObjectBins bins = liveData.getLiveObjectBins();
            LiveObjectSetList sets = liveData.getLiveObjectSets();
            LiveObjectSet set = bins.getEnabledLiveObjectSet();
            if (set != null && set.size() > 0) {
                this.setModel.addLiveObjectSet(set);
            }
        }
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        int row = this.liveObjectSetListTable.getSelectedRow();
        if (row >= 0 && row < this.setModel.getRowCount() - 1) {
            this.setModel.removeLiveObjectSet(row);
        }
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void setupNoteTemplatePopup() {
        this.noteTemplatePopup = new JPopupMenu();
        String[] items = new String[]{"<START>", "<DUR>", "<KEY>", "<KEY_CPS>", "<KEY_OCT>", "<KEY_PCH>", "<VELOCITY>", "<VELOCITY_AMP>"};
        ActionListener al = e -> {
            if (this.noteTemplateText.isEnabled()) {
                int mark;
                int loc = this.noteTemplateText.getCaret().getDot();
                int start = loc < (mark = this.noteTemplateText.getCaret().getMark()) ? loc : mark;
                int len = Math.abs(loc - mark);
                Document doc = this.noteTemplateText.getDocument();
                try {
                    if (len > 0) {
                        doc.remove(start, len);
                    }
                    doc.insertString(start, e.getActionCommand(), null);
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        };
        for (int i = 0; i < items.length; ++i) {
            JMenuItem item = new JMenuItem(items[i]);
            item.addActionListener(al);
            this.noteTemplatePopup.add(item);
        }
    }

    protected void addSoundObject(int column, int row, SoundObject sObj) {
        this.model.setValueAt(new LiveObject(sObj), row, column);
        this.liveObjectsTable.setRowSelectionInterval(row, row);
        this.liveObjectsTable.setColumnSelectionInterval(column, column);
    }

    class BufferMenu
    extends JPopupMenu {
        JMenu addMenu;
        JMenuItem removeInstrumentMenuItem;
        JMenuItem cutMenuItem;
        JMenuItem copyMenuItem;
        JMenuItem pasteMenuItem;
        JMenuItem convertToBSB;
        JMenuItem insertRowBefore;
        JMenuItem insertRowAfter;
        JMenuItem removeRow;
        JMenuItem insertColumnBefore;
        JMenuItem insertColumnAfter;
        JMenuItem removeColumn;

        public BufferMenu() {
            this.addMenu = new AddMenu();
            this.removeInstrumentMenuItem = new JMenuItem(BlueSystem.getString((String)"common.remove"));
            this.cutMenuItem = new JMenuItem(BlueSystem.getString((String)"common.cut"));
            this.copyMenuItem = new JMenuItem(BlueSystem.getString((String)"common.copy"));
            this.pasteMenuItem = new JMenuItem(BlueSystem.getString((String)"common.paste"));
            this.convertToBSB = new JMenuItem();
            this.insertRowBefore = new JMenuItem("Insert Row Before");
            this.insertRowAfter = new JMenuItem("Insert Row After");
            this.removeRow = new JMenuItem("Remove Row");
            this.insertColumnBefore = new JMenuItem("Insert Column Before");
            this.insertColumnAfter = new JMenuItem("Insert Column After");
            this.removeColumn = new JMenuItem("Remove Column");
            this.removeInstrumentMenuItem.addActionListener(e -> {
                LiveObject lObj = (LiveObject)BlueLiveTopComponent.this.liveObjectsTable.getValueAt(BlueLiveTopComponent.this.mouseRow, BlueLiveTopComponent.this.mouseColumn);
                if (lObj != null) {
                    BlueLiveTopComponent.this.model.setValueAt(null, BlueLiveTopComponent.this.mouseRow, BlueLiveTopComponent.this.mouseColumn);
                    BlueLiveTopComponent.this.content.set(Collections.emptyList(), null);
                }
            });
            this.cutMenuItem.addActionListener(e -> {
                LiveObject lObj = (LiveObject)BlueLiveTopComponent.this.liveObjectsTable.getValueAt(BlueLiveTopComponent.this.mouseRow, BlueLiveTopComponent.this.mouseColumn);
                if (lObj != null) {
                    SoundObject copy = lObj.getSoundObject().deepCopy();
                    ScoreController.ScoreObjectBuffer scoreObjectBuffer = ScoreController.getInstance().getScoreObjectBuffer();
                    scoreObjectBuffer.clear();
                    scoreObjectBuffer.scoreObjects.add((ScoreObject)copy);
                    scoreObjectBuffer.layerIndexes.add(0);
                    BlueLiveTopComponent.this.model.setValueAt(null, BlueLiveTopComponent.this.mouseRow, BlueLiveTopComponent.this.mouseColumn);
                    BlueLiveTopComponent.this.content.set(Collections.emptyList(), null);
                }
            });
            this.copyMenuItem.addActionListener(e -> {
                LiveObject lObj = (LiveObject)BlueLiveTopComponent.this.liveObjectsTable.getValueAt(BlueLiveTopComponent.this.mouseRow, BlueLiveTopComponent.this.mouseColumn);
                if (lObj != null) {
                    SoundObject copy = lObj.getSoundObject().deepCopy();
                    ScoreController.ScoreObjectBuffer scoreObjectBuffer = ScoreController.getInstance().getScoreObjectBuffer();
                    scoreObjectBuffer.clear();
                    scoreObjectBuffer.scoreObjects.add((ScoreObject)copy);
                    scoreObjectBuffer.layerIndexes.add(0);
                }
            });
            this.pasteMenuItem.addActionListener(e -> {
                ScoreController.ScoreObjectBuffer scoreObjectBuffer = ScoreController.getInstance().getScoreObjectBuffer();
                if (scoreObjectBuffer.scoreObjects.size() != 1) {
                    return;
                }
                ScoreObject scoreObj = scoreObjectBuffer.scoreObjects.get(0);
                if (!(scoreObj instanceof SoundObject)) {
                    return;
                }
                SoundObject sObj = (SoundObject)scoreObj;
                if (!BlueLiveTopComponent.this.liveSoundObjectTemplates.containsKey(sObj.getClass())) {
                    return;
                }
                SoundObject copy = sObj.deepCopy();
                copy.setStartTime(0.0);
                BlueLiveTopComponent.this.addSoundObject(BlueLiveTopComponent.this.mouseColumn, BlueLiveTopComponent.this.mouseRow, copy);
            });
            this.insertRowBefore.addActionListener(e -> BlueLiveTopComponent.this.model.insertRow(BlueLiveTopComponent.this.mouseRow));
            this.insertRowAfter.addActionListener(e -> BlueLiveTopComponent.this.model.insertRow(BlueLiveTopComponent.this.mouseRow + 1));
            this.removeRow.addActionListener(e -> BlueLiveTopComponent.this.model.removeRow(BlueLiveTopComponent.this.mouseRow));
            this.insertColumnBefore.addActionListener(e -> BlueLiveTopComponent.this.model.insertColumn(BlueLiveTopComponent.this.mouseColumn));
            this.insertColumnAfter.addActionListener(e -> BlueLiveTopComponent.this.model.insertColumn(BlueLiveTopComponent.this.mouseColumn + 1));
            this.removeColumn.addActionListener(e -> BlueLiveTopComponent.this.model.removeColumn(BlueLiveTopComponent.this.mouseColumn));
            this.add(this.addMenu);
            this.add(this.removeInstrumentMenuItem);
            this.addSeparator();
            this.add(this.cutMenuItem);
            this.add(this.copyMenuItem);
            this.add(this.pasteMenuItem);
            this.addSeparator();
            this.add(this.insertRowBefore);
            this.add(this.insertRowAfter);
            this.add(this.removeRow);
            this.addSeparator();
            this.add(this.insertColumnBefore);
            this.add(this.insertColumnAfter);
            this.add(this.removeColumn);
            this.setupPopupListener();
        }

        private void setupPopupListener() {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    LiveObject lObj = (LiveObject)BlueLiveTopComponent.this.liveObjectsTable.getValueAt(BlueLiveTopComponent.this.mouseRow, BlueLiveTopComponent.this.mouseColumn);
                    boolean objectAvailable = lObj != null;
                    BufferMenu.this.cutMenuItem.setEnabled(objectAvailable);
                    BufferMenu.this.copyMenuItem.setEnabled(objectAvailable);
                    BufferMenu.this.removeInstrumentMenuItem.setEnabled(objectAvailable);
                    BufferMenu.this.removeRow.setEnabled(BlueLiveTopComponent.this.liveObjectsTable.getRowCount() > 1);
                    BufferMenu.this.removeColumn.setEnabled(BlueLiveTopComponent.this.liveObjectsTable.getColumnCount() > 1);
                    ScoreController.ScoreObjectBuffer buffer = ScoreController.getInstance().getScoreObjectBuffer();
                    if (buffer.scoreObjects.size() == 1) {
                        BufferMenu.this.pasteMenuItem.setEnabled(BlueLiveTopComponent.this.liveSoundObjectTemplates.containsKey(buffer.scoreObjects.get(0).getClass()));
                    } else {
                        BufferMenu.this.pasteMenuItem.setEnabled(false);
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    class SetsBufferMenu
    extends JPopupMenu {
        Action renameAction;
        Action removeAction;

        public SetsBufferMenu() {
            this.renameAction = new AbstractAction("Rename"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LiveObjectSetList liveObjectSets = BlueLiveTopComponent.this.data.getLiveData().getLiveObjectSets();
                    if (BlueLiveTopComponent.this.mouseRow >= 0 && BlueLiveTopComponent.this.mouseRow < liveObjectSets.size()) {
                        LiveObjectSet set = (LiveObjectSet)liveObjectSets.get(BlueLiveTopComponent.this.mouseRow);
                        String retVal = JOptionPane.showInputDialog(WindowManager.getDefault().getMainWindow(), "Rename", set.getName());
                        if (retVal != null) {
                            set.setName(retVal);
                            BlueLiveTopComponent.this.liveObjectSetListTable.repaint();
                        }
                    }
                }
            };
            this.removeAction = new AbstractAction("Remove"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BlueLiveTopComponent.this.setModel.removeLiveObjectSet(BlueLiveTopComponent.this.mouseRow);
                }
            };
            this.add(this.renameAction);
            this.add(this.removeAction);
        }
    }

    class AddMenu
    extends JMenu
    implements ActionListener {
        HashMap<String, Class> sObjNameClassMap;

        public AddMenu() {
            super("Add SoundObject");
            this.sObjNameClassMap = new HashMap();
            for (Map.Entry<Class<? extends SoundObject>, String> entry : BlueLiveTopComponent.this.liveSoundObjectTemplates.entrySet()) {
                this.sObjNameClassMap.put(entry.getValue(), entry.getKey());
                JMenuItem temp = new JMenuItem();
                temp.setText(BlueSystem.getString((String)"soundLayerPopup.addNew") + " " + BlueSystem.getShortClassName((String)entry.getValue()));
                temp.putClientProperty("sObjClass", entry.getKey());
                temp.setActionCommand(entry.getValue());
                temp.addActionListener(this);
                this.add(temp);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                Class c = (Class)((JMenuItem)ae.getSource()).getClientProperty("sObjClass");
                SoundObject sObj = (SoundObject)c.newInstance();
                BlueLiveTopComponent.this.addSoundObject(BlueLiveTopComponent.this.mouseColumn, BlueLiveTopComponent.this.mouseRow, sObj);
            }
            catch (IllegalAccessException | InstantiationException cnfe) {
                JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"soundLayerPopup.soundObject.couldNotInstantiate") + "\n" + ae.getActionCommand());
            }
        }
    }
}

