/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.codeRepository;

import blue.tools.codeRepository.CodeRepositoryManager;
import blue.tools.codeRepository.ElementHolder;
import blue.utility.GUI;
import com.l2fprod.common.swing.BaseDialog;
import electric.xml.ParseException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.wonderly.awt.Packer;

public class AddToCodeRepositoryDialog
extends BaseDialog {
    JTextField nameText = new JTextField();
    JTree categoryTree = new JTree();

    public AddToCodeRepositoryDialog() {
        super((Frame)null, "Add to Code Repository", true);
        this.getBanner().setVisible(false);
        this.setDefaultCloseOperation(1);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        Packer p = new Packer((Container)panel);
        p.add((Component)new JLabel("Code Snippet Name")).gridx(0).padx(10).pady(10).west();
        p.add((Component)this.nameText).gridx(1).fillx();
        p.add((Component)new JLabel("Category")).gridx(0).gridy(1).gridw(2);
        p.add((Component)new JScrollPane(this.categoryTree)).gridx(0).gridy(2).fillboth().gridw(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)panel, "Center");
        this.setSize(400, 300);
        GUI.centerOnScreen((Component)((Object)this));
    }

    public void initTree() {
        try {
            TreeNode rootNode = CodeRepositoryManager.getCodeRepositoryTreeNode(false);
            this.categoryTree.setModel(new DefaultTreeModel(rootNode));
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error: There was an error trying to open or parse codeRepository.xml");
            e.printStackTrace();
        }
    }

    public boolean ask() {
        this.initTree();
        return super.ask();
    }

    public DefaultMutableTreeNode getUpdatedCodeRepository(String codeSnippet) throws ParseException {
        DefaultMutableTreeNode codeRoot;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.categoryTree.getModel().getRoot();
        TreePath path = this.categoryTree.getSelectionPath();
        if (path == null || this.nameText.getText().trim().length() == 0) {
            return null;
        }
        Object[] values = path.getPath();
        DefaultMutableTreeNode selected = codeRoot = (DefaultMutableTreeNode)CodeRepositoryManager.getCodeRepositoryTreeNode(true);
        if (values.length > 1) {
            for (int i = 1; i < values.length; ++i) {
                String key = values[i].toString();
                for (int j = 0; j < selected.getChildCount(); ++j) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getChildAt(j);
                    ElementHolder elem = (ElementHolder)node.getUserObject();
                    if (!elem.title.equals(key)) continue;
                    selected = node;
                }
            }
        }
        ElementHolder newElem = new ElementHolder();
        newElem.title = this.nameText.getText();
        newElem.text = codeSnippet;
        selected.add(new DefaultMutableTreeNode(newElem));
        System.out.println(selected);
        return codeRoot;
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        AddToCodeRepositoryDialog dlg = new AddToCodeRepositoryDialog();
        for (int i = 0; i < 3; ++i) {
            if (!dlg.ask()) continue;
        }
        System.exit(0);
    }
}

