/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.blueShare.instruments;

import blue.BlueSystem;
import blue.tools.blueShare.BlueShareRemoteCaller;
import blue.tools.blueShare.NamePasswordPanel;
import blue.tools.blueShare.instruments.InstrumentManagementTableModel;
import blue.tools.blueShare.instruments.InstrumentOption;
import blue.utility.GUI;
import electric.xml.ParseException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.xmlrpc.XmlRpcException;

public class InstrumentManagementPane
extends JComponent {
    NamePasswordPanel namePasswordPanel = new NamePasswordPanel();
    CardLayout cardLayout = new CardLayout();
    JTable instrumentTable = new JTable();
    InstrumentManagementTableModel iTableModel = new InstrumentManagementTableModel();
    JButton fetchInstrumentsButton = new JButton(BlueSystem.getString((String)"blueShare.fetch"));
    JButton removeInstrumentButton = new JButton(BlueSystem.getString((String)"blueShare.remove"));
    JButton updateInstrumentButton = new JButton(BlueSystem.getString((String)"blueShare.update"));
    JPanel cardPanel;

    public InstrumentManagementPane() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.namePasswordPanel, "North");
        this.instrumentTable.setModel(this.iTableModel);
        this.cardPanel = new JPanel(this.cardLayout);
        JScrollPane jsp = new JScrollPane();
        jsp.setViewportView(this.instrumentTable);
        this.cardPanel.add((Component)new JLabel(BlueSystem.getString((String)"blueShare.noInstrumentsForUser")), "none");
        this.cardPanel.add((Component)jsp, "instruments");
        this.add((Component)this.cardPanel, "Center");
        this.fetchInstrumentsButton.addActionListener(e -> this.fetchInstruments());
        this.removeInstrumentButton.addActionListener(e -> this.removeInstrument());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.fetchInstrumentsButton);
        buttonPanel.add(this.removeInstrumentButton);
        this.add((Component)buttonPanel, "South");
        this.cardLayout.show(this.cardPanel, "instruments");
    }

    protected void removeInstrument() {
        InstrumentOption iOption = this.iTableModel.getInstrumentOption(this.instrumentTable.getSelectedRow());
        if (iOption == null) {
            return;
        }
        int retVal = JOptionPane.showConfirmDialog(null, BlueSystem.getString((String)"blueShare.removeConfirm"));
        if (retVal != 0) {
            return;
        }
        String username = this.namePasswordPanel.getUsername();
        String password = this.namePasswordPanel.getPassword();
        try {
            boolean bl = BlueShareRemoteCaller.removeInstrument(username, password, iOption.getInstrumentId());
        }
        catch (IOException | XmlRpcException xre) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + xre.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setInstrumentOptions(null);
            return;
        }
        JOptionPane.showMessageDialog(null, "Instrument was successfully removed.", "Success", -1);
        this.fetchInstruments();
    }

    protected void updateInstrument() {
        InstrumentOption iOption = this.iTableModel.getInstrumentOption(this.instrumentTable.getSelectedRow());
        if (iOption == null) {
            return;
        }
        JOptionPane.showMessageDialog(null, "Diagram and figure out best implementation");
    }

    protected void fetchInstruments() {
        String username = this.namePasswordPanel.getUsername();
        String password = this.namePasswordPanel.getPassword();
        try {
            InstrumentOption[] iOptions = BlueShareRemoteCaller.getInstrumentOptionsForUser(username, password);
            this.iTableModel.setInstrumentOptions(iOptions);
            if (iOptions.length == 0) {
                this.cardLayout.show(this.cardPanel, "none");
            } else {
                this.cardLayout.show(this.cardPanel, "instruments");
            }
        }
        catch (ParseException pe) {
            String error = BlueSystem.getString((String)"blueShare.selectServer.couldNotReadResponse");
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setInstrumentOptions(null);
            return;
        }
        catch (XmlRpcException xre) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + xre.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setInstrumentOptions(null);
            return;
        }
        catch (IOException ioe) {
            String error = BlueSystem.getString((String)"message.errorLabel") + " " + ioe.getLocalizedMessage();
            JOptionPane.showMessageDialog(null, error, BlueSystem.getString((String)"message.error"), 0);
            this.iTableModel.setInstrumentOptions(null);
            return;
        }
    }

    public static void main(String[] args) {
        GUI.showComponentAsStandalone((Component)new InstrumentManagementPane(), (String)"InstrumentManagementPane", (boolean)true);
    }
}

