/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pianoRoll;

import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import blue.soundObject.PianoRoll;
import blue.soundObject.editor.pianoRoll.PianoNoteView;
import blue.soundObject.editor.pianoRoll.SelectedNoteHighlighter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JComponent;

public class PianoRollCanvasHeader
extends JComponent
implements PropertyChangeListener,
SelectionListener<PianoNoteView> {
    private static final Font labelFont = new Font("Dialog", 0, 10);
    private static final String[] NOTE_NAMES = new String[]{"C", "C#/Db", "D", "D#/Eb", "E", "F", "F#/Gb", "G", "G#/Ab", "A", "A#/Bb", "B"};
    int octaves = 16;
    int centerOctave = 8;
    private static Color OCTAVE_COLOR = new Color(198, 226, 255);
    private PianoRoll p;
    private HashMap<PianoNoteView, SelectedNoteHighlighter> noteHilightMap = new HashMap();

    public PianoRollCanvasHeader() {
        this.setSizeForScale();
        this.setLayout(null);
    }

    private void setSizeForScale() {
        if (this.p == null) {
            return;
        }
        int notesPerOctave = this.p.getScale().getNumScaleDegrees();
        int noteHeight = this.p.getNoteHeight();
        this.setSize(32, this.octaves * notesPerOctave * noteHeight);
        this.setPreferredSize(new Dimension(32, this.octaves * notesPerOctave * noteHeight));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(labelFont);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.p == null) {
            return;
        }
        if (this.p.getPchGenerationMethod() == 2) {
            this.drawMIDI(g);
        } else {
            this.drawScale(g);
        }
    }

    private void drawMIDI(Graphics g) {
        int notesPerOctave = 12;
        int noteHeight = this.p.getNoteHeight();
        int h = 128 * noteHeight;
        int w = this.getWidth();
        g.setColor(OCTAVE_COLOR);
        g.drawLine(w - 1, 0, w - 1, h);
        for (int i = 0; i < this.octaves; ++i) {
            int lineY = h - i * notesPerOctave * noteHeight;
            g.drawLine(0, lineY, w, lineY);
            String label = "C" + i;
            int labelW = g.getFontMetrics().stringWidth(label);
            int labelX = w - labelW - 2;
            g.setColor(OCTAVE_COLOR);
            g.drawString(label, labelX, lineY - 2);
            g.setColor(OCTAVE_COLOR.darker());
            for (int j = 1; j < notesPerOctave; ++j) {
                int noteY = lineY - j * noteHeight;
                g.drawLine(w - 4, noteY, w, noteY);
                String noteLabel = NOTE_NAMES[j];
                labelW = g.getFontMetrics().stringWidth(noteLabel);
                labelX = w - labelW - 2;
                g.drawString(noteLabel, labelX, noteY - 2);
            }
        }
    }

    private void drawScale(Graphics g) {
        int notesPerOctave = this.p.getScale().getNumScaleDegrees();
        int noteHeight = this.p.getNoteHeight();
        int h = this.octaves * notesPerOctave * noteHeight;
        int w = this.getWidth();
        g.setColor(OCTAVE_COLOR);
        g.drawLine(w - 1, 0, w - 1, h);
        for (int i = 0; i < this.octaves; ++i) {
            int lineY = h - i * notesPerOctave * noteHeight;
            g.drawLine(0, lineY, w, lineY);
            String label = i + ".00";
            int labelW = g.getFontMetrics().stringWidth(label);
            int labelX = w - labelW - 2;
            g.drawString(i + ".00", labelX, lineY - 2);
            for (int j = 1; j < notesPerOctave; ++j) {
                int noteY = lineY - j * noteHeight;
                g.drawLine(w - 4, noteY, w, noteY);
                String noteLabel = Integer.toString(j);
                if (noteLabel.length() == 1) {
                    noteLabel = "0" + noteLabel;
                }
                labelW = g.getFontMetrics().stringWidth(noteLabel);
                labelX = w - labelW - 2;
                g.drawString(noteLabel, labelX, noteY - 2);
            }
        }
    }

    public void editPianoRoll(PianoRoll p) {
        if (this.p != null) {
            this.p.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.p = p;
        this.p.addPropertyChangeListener((PropertyChangeListener)this);
        this.p = p;
        this.setSizeForScale();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName;
        if (evt.getSource() == this.p && ((propertyName = evt.getPropertyName()).equals("scale") || propertyName.equals("noteHeight"))) {
            this.setSizeForScale();
            this.revalidate();
            this.repaint();
        }
    }

    public void selectionPerformed(SelectionEvent<PianoNoteView> e) {
        PianoNoteView pnv = (PianoNoteView)e.getSelectedItem();
        switch (e.getSelectionType()) {
            case -1: {
                for (SelectedNoteHighlighter tempSnh : this.noteHilightMap.values()) {
                    tempSnh.cleanup();
                }
                this.noteHilightMap.clear();
                this.removeAll();
                this.repaint();
                break;
            }
            case 0: {
                for (SelectedNoteHighlighter tempSnh : this.noteHilightMap.values()) {
                    tempSnh.cleanup();
                }
                this.noteHilightMap.clear();
                this.removeAll();
                SelectedNoteHighlighter snh = new SelectedNoteHighlighter(pnv);
                snh.setLocation(0, pnv.getY());
                this.add(snh);
                this.noteHilightMap.put(pnv, snh);
                this.repaint();
                break;
            }
            case 1: {
                SelectedNoteHighlighter snh = new SelectedNoteHighlighter(pnv);
                snh.setLocation(0, pnv.getY());
                this.add(snh);
                this.noteHilightMap.put(pnv, snh);
                this.repaint();
                break;
            }
            case 2: {
                SelectedNoteHighlighter snh = this.noteHilightMap.get(pnv);
                this.remove(snh);
                if (snh == null) break;
                this.noteHilightMap.remove(pnv);
                snh.cleanup();
            }
        }
    }
}

