/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.BSBObject;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringEscapeUtils;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public class BSBCompletionItem
implements CompletionItem {
    private final BSBObject bsbObj;
    private final String replacementKey;
    private final String label;
    private final String objectType;

    public BSBCompletionItem(BSBObject bsbObj, String replacementKey) {
        this.bsbObj = bsbObj;
        this.replacementKey = "<" + replacementKey + ">";
        this.label = StringEscapeUtils.escapeHtml4((String)replacementKey);
        this.objectType = bsbObj.getClass().getSimpleName();
    }

    public void defaultAction(JTextComponent component) {
        this.replaceWordBeforeCaret(this.replacementKey, component);
        Completion.get().hideAll();
    }

    protected void replaceWordBeforeCaret(String replacementText, JTextComponent jtc) {
        int index1;
        String text = jtc.getText();
        for (index1 = Math.max(0, jtc.getCaretPosition() - 1); index1 > 0 && text.charAt(index1) != '<'; --index1) {
        }
        try {
            jtc.getDocument().remove(index1, jtc.getCaretPosition() - index1);
            jtc.getDocument().insertString(index1, replacementText, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.label, (String)this.objectType, (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml(null, (String)this.label, (String)this.objectType, (Graphics)g, (Font)defaultFont, (Color)(selected ? Color.orange : Color.white), (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public int getSortPriority() {
        return -5;
    }

    public CharSequence getSortText() {
        return this.replacementKey;
    }

    public CharSequence getInsertPrefix() {
        return this.replacementKey;
    }
}

