/*
 * Decompiled with CFR 0.152.
 */
package blue.gui;

import blue.BlueSystem;
import blue.gui.AlphabeticalFileComparator;
import blue.gui.DriveSelectorPopupMenu;
import blue.gui.FileListCellRenderer;
import blue.gui.FileTreeListener;
import blue.gui.FileTreePopup;
import blue.ui.utilities.UiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FileTree
extends JComponent {
    private static final Comparator<File> c = new AlphabeticalFileComparator();
    private ArrayList<FileTreeListener> listeners = new ArrayList();
    JList<File> directoryList = new JList();
    JScrollPane fileListScrollPane = new JScrollPane();
    JList<File> fileList = new JList();
    FileListCellRenderer flcRenderer = new FileListCellRenderer();
    JButton driveButton = new JButton("<");
    JComboBox<File> dirList = new JComboBox();
    boolean listUpdating = false;
    DriveSelectorPopupMenu drives = new DriveSelectorPopupMenu();
    String[] filenameExtensions = null;
    private FileTreePopup fileTreePopup;

    public FileTree() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addFileTreeListener(FileTreeListener fileTreeListener) {
        this.listeners.add(fileTreeListener);
    }

    public void addFileTreePopup(FileTreePopup fileTreePopup) {
        this.fileTreePopup = fileTreePopup;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FileTree.this.listUpdating) {
                    return;
                }
                FileTree.this.listUpdating = true;
                File f = FileTree.this.fileList.getSelectedValue();
                if (e.getClickCount() == 2) {
                    if (f.isDirectory()) {
                        if (!f.canRead()) {
                            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"soundfile.manager.error.noAccess"), BlueSystem.getString((String)"message.error"), -1);
                            FileTree.this.listUpdating = false;
                            return;
                        }
                        FileTree.this.populateDirectory(f);
                        FileTree.this.populateFiles(f);
                    } else if (f.isFile()) {
                        FileTree.this.fireFileSelected(f);
                    }
                } else if (UiUtilities.isRightMouseButton((MouseEvent)e) && FileTree.this.fileTreePopup != null) {
                    FileTree.this.fileTreePopup.show(f, e.getComponent(), e.getX(), e.getY());
                }
                FileTree.this.listUpdating = false;
            }
        });
        this.driveButton.addActionListener(e -> this.showDrivePopup());
        this.driveButton.setPreferredSize(new Dimension(26, 26));
        this.driveButton.setText("...");
        JPanel driveDirPanel = new JPanel();
        driveDirPanel.setLayout(new BorderLayout());
        driveDirPanel.add(this.dirList, "Center");
        driveDirPanel.add((Component)this.driveButton, "East");
        this.add((Component)driveDirPanel, "North");
        this.add((Component)this.fileListScrollPane, "Center");
        this.fileListScrollPane.getViewport().add(this.fileList);
        this.fileList.setCellRenderer(this.flcRenderer);
        this.dirList.addActionListener(e -> {
            if (!this.listUpdating) {
                this.listUpdating = true;
                File dir = (File)this.dirList.getSelectedItem();
                this.populateDirectory(dir);
                this.populateFiles(dir);
                this.listUpdating = false;
            }
        });
        this.listUpdating = true;
        File homeDir = new File(System.getProperty("user.home"));
        this.populateDirectory(homeDir);
        this.populateFiles(homeDir);
        this.listUpdating = false;
    }

    protected void fireFileSelected(File f) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            FileTreeListener ftl = this.listeners.get(i);
            ftl.fileSelected(f);
        }
    }

    public void setDrive(File drive) {
        this.listUpdating = true;
        this.populateDirectory(drive);
        this.populateFiles(drive);
        this.listUpdating = false;
    }

    private void populateDirectory(File dir) {
        this.flcRenderer.setSelectedDir(dir);
        Vector<File> parentList = new Vector<File>();
        File tempDir = dir;
        parentList.add(dir);
        while ((tempDir = tempDir.getParentFile()) != null) {
            parentList.add(0, tempDir);
        }
        this.dirList.setModel(new DefaultComboBoxModel(parentList));
        this.dirList.setSelectedIndex(parentList.size() - 1);
    }

    private boolean populateFiles(File dir) {
        File[] files = dir.listFiles();
        Arrays.sort(files, c);
        Vector<File> v = new Vector<File>();
        v.add(dir);
        if (dir.getParentFile() != null) {
            v.add(dir.getParentFile());
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().startsWith(".")) continue;
            if (files[i].isFile()) {
                String fileName = files[i].getName();
                if (!this.filter(fileName)) continue;
                v.add(files[i]);
                continue;
            }
            if (!files[i].isDirectory()) continue;
            v.add(files[i]);
        }
        this.fileList.setListData(v);
        return true;
    }

    private boolean filter(String fileName) {
        if (this.filenameExtensions == null) {
            return false;
        }
        for (int i = 0; i < this.filenameExtensions.length; ++i) {
            if (!fileName.toLowerCase().endsWith(this.filenameExtensions[i])) continue;
            return true;
        }
        return false;
    }

    public void setFilters(String[] filenameExtensions) {
        this.filenameExtensions = filenameExtensions;
    }

    public void showDrivePopup() {
        this.drives.show(this, this.driveButton.getX(), this.driveButton.getY() + this.driveButton.getHeight());
    }

    public static void main(String[] args) {
        JFrame mFrame = new JFrame();
        mFrame.setSize(800, 600);
        FileTree soundFileManager1 = new FileTree();
        mFrame.getContentPane().add(soundFileManager1);
        mFrame.setVisible(true);
        mFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }
}

