/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask.probability;

import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.probability.ProbabilityGenerator;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;

public class Beta
implements ProbabilityGenerator {
    private double a = 0.1;
    private double b = 0.1;
    private Table aTable;
    private Table bTable;
    private boolean aTableEnabled = false;
    private boolean bTableEnabled = false;

    public Beta() {
        this.aTable = new Table();
        this.bTable = new Table();
        this.aTable.getPoint(0).setValue(0.1);
        this.aTable.getPoint(1).setValue(0.1);
        this.bTable.getPoint(0).setValue(0.1);
        this.bTable.getPoint(1).setValue(0.1);
    }

    public Beta(Beta beta) {
        this.a = beta.a;
        this.b = beta.b;
        this.aTable = new Table(beta.aTable);
        this.bTable = new Table(beta.bTable);
        this.aTableEnabled = beta.aTableEnabled;
        this.bTableEnabled = beta.bTableEnabled;
    }

    public static ProbabilityGenerator loadFromXML(Element data) {
        Beta retVal = new Beta();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            block7 : switch (nodeName = node.getName()) {
                case "a": {
                    retVal.a = XMLUtilities.readDouble(node);
                    break;
                }
                case "b": {
                    retVal.b = XMLUtilities.readDouble(node);
                    break;
                }
                case "aTableEnabled": {
                    retVal.aTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "bTableEnabled": {
                    retVal.bTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "table": {
                    String tableId;
                    switch (tableId = node.getAttributeValue("tableId")) {
                        case "aTable": {
                            retVal.aTable = Table.loadFromXML(node);
                            break block7;
                        }
                        case "bTable": {
                            retVal.bTable = Table.loadFromXML(node);
                        }
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("probabilityGenerator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeDouble("a", this.a));
        retVal.addElement(XMLUtilities.writeDouble("b", this.b));
        retVal.addElement(XMLUtilities.writeBoolean("aTableEnabled", this.aTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("bTableEnabled", this.bTableEnabled));
        Element aTableNode = this.aTable.saveAsXML();
        aTableNode.setAttribute("tableId", "aTable");
        Element bTableNode = this.bTable.saveAsXML();
        bTableNode.setAttribute("tableId", "bTable");
        retVal.addElement(aTableNode);
        retVal.addElement(bTableNode);
        return retVal;
    }

    @Override
    public String getName() {
        return "Beta";
    }

    @Override
    public double getValue(double time, Random rnd) {
        double x2;
        double yps2;
        double x1;
        double yps1;
        double sum;
        double localA = this.aTableEnabled ? this.aTable.getValue(time) : this.a;
        double localB = this.bTableEnabled ? this.bTable.getValue(time) : this.b;
        do {
            x1 = rnd.nextDouble();
            x2 = rnd.nextDouble();
        } while ((sum = (yps1 = Math.pow(x1, 1.0 / localA)) + (yps2 = Math.pow(x2, 1.0 / localB))) > 1.0);
        return yps1 / sum;
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.a = a;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }

    public Table getATable() {
        return this.aTable;
    }

    public void setATable(Table aTable) {
        this.aTable = aTable;
    }

    public Table getBTable() {
        return this.bTable;
    }

    public void setBTable(Table bTable) {
        this.bTable = bTable;
    }

    public boolean isATableEnabled() {
        return this.aTableEnabled;
    }

    public void setATableEnabled(boolean aTableEnabled) {
        this.aTableEnabled = aTableEnabled;
    }

    public boolean isBTableEnabled() {
        return this.bTableEnabled;
    }

    public void setBTableEnabled(boolean bTableEnabled) {
        this.bTableEnabled = bTableEnabled;
    }

    @Override
    public Beta deepCopy() {
        return new Beta(this);
    }
}

