/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObjectEvent;
import blue.scripting.ScoreScriptEngine;
import blue.scripting.ScoreScriptEngineManager;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.HashMap;
import java.util.Map;

public class External
extends AbstractSoundObject {
    private NoteProcessorChain npc;
    private int timeBehavior;
    double repeatPoint = -1.0;
    private String commandLine = "";
    private String text = "";
    private String syntaxType = "Python";

    public External() {
        this.setName("External");
        this.npc = new NoteProcessorChain();
        this.timeBehavior = 0;
    }

    public External(External external) {
        super(external);
        this.timeBehavior = external.timeBehavior;
        this.npc = new NoteProcessorChain(external.getNoteProcessorChain());
        this.repeatPoint = external.repeatPoint;
        this.commandLine = external.commandLine;
        this.text = external.text;
        this.syntaxType = external.syntaxType;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain noteProcessorChain) {
        this.npc = noteProcessorChain;
    }

    @Override
    public double getObjectiveDuration() {
        return this.getSubjectiveDuration();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public final NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        if (this.commandLine.trim().length() == 0 && this.getText().trim().length() == 0) {
            return null;
        }
        NoteList nl = new NoteList();
        ScoreScriptEngine engine = ScoreScriptEngineManager.getInstance().getEngine("External");
        HashMap<String, Object> initVals = new HashMap<String, Object>();
        initVals.put("commandline", this.commandLine);
        try {
            String temp = engine.evalCode(this.text, initVals);
            nl = ScoreUtilities.getNotes(temp);
        }
        catch (Exception ex) {
            throw new SoundObjectException(this, this.getIOExceptionMessage(), ex);
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException npe) {
            throw new SoundObjectException((SoundObject)this, (Throwable)npe);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
        ScoreUtilities.setScoreStart(nl, this.getStartTime());
        return nl;
    }

    private String getIOExceptionMessage() {
        System.out.println("[Error] Score Generation failed in External soundObject labeled " + this.getName());
        String errorMessage = "External SoundObject Score Generation Error";
        errorMessage = errorMessage + "\n\nUnable to execute the command: " + this.commandLine;
        errorMessage = errorMessage + "\n\nPlease check that the command is either in your path\n";
        errorMessage = errorMessage + "or that the absolute path specified is correct.";
        return errorMessage;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        External external = new External();
        SoundObjectUtilities.initBasicFromXML(data, external);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "text": {
                    external.setText(node.getTextString());
                    break;
                }
                case "commandLine": {
                    external.setCommandLine(node.getTextString());
                    break;
                }
                case "syntaxType": {
                    external.setSyntaxType(node.getTextString());
                }
            }
        }
        return external;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("text").setText(this.getText());
        retVal.addElement("commandLine").setText(this.getCommandLine());
        retVal.addElement("syntaxType").setText(this.getSyntaxType());
        return retVal;
    }

    public String getSyntaxType() {
        return this.syntaxType;
    }

    public void setSyntaxType(String syntaxType) {
        this.syntaxType = syntaxType;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        NoteList retVal = this.generateNotes(startTime, endTime);
        return retVal;
    }

    @Override
    public External deepCopy() {
        return new External(this);
    }
}

