/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.flowGraph;

import blue.orchestra.editor.flowGraph.FlowGraphCanvas;
import blue.orchestra.flowGraph.FlowGraph;
import blue.orchestra.flowGraph.UnitLibrary;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;

public class FlowGraphPanel
extends JPanel {
    private UnitLibrary unitLibrary;
    private FlowGraph instrument;
    private FlowGraphCanvas flowGraphCanvas;
    private JLabel statusBar;
    private JSlider zoomSlider;
    private double scale;
    private JPopupMenu popupCanvas;
    private JPopupMenu popupUnit;
    private JPopupMenu popupPort;

    public FlowGraphPanel(FlowGraph instrument, UnitLibrary unitLibrary) {
        this.instrument = instrument;
        this.unitLibrary = unitLibrary;
        this.statusBar = new JLabel("...");
        this.zoomSlider = new JSlider(0, 150, 500, 350);
        this.zoomSlider.setPreferredSize(new Dimension(100, 10));
        this.flowGraphCanvas = new FlowGraphCanvas(this);
        this.setLayout(new BorderLayout());
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)this.statusBar, "West");
        bottom.add((Component)this.zoomSlider, "East");
        this.add((Component)bottom, "South");
        this.add((Component)this.flowGraphCanvas, "Center");
        this.popupCanvas = this.createCanvasPopupMenu();
        this.popupUnit = this.createUnitPopupMenu();
        this.popupPort = this.createPortPopupMenu();
        this.scale = 50.0;
    }

    private JPopupMenu createCanvasPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("add Unit");
        popup.add(item);
        return popup;
    }

    private JPopupMenu createUnitPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("add comment");
        popup.add(item);
        return popup;
    }

    private JPopupMenu createPortPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("connect to that port");
        popup.add(item);
        return popup;
    }

    public FlowGraph getFlowGraph() {
        return this.instrument;
    }

    public FlowGraphCanvas getFlowGraphCanvas() {
        return this.flowGraphCanvas;
    }

    public JLabel getStatusBar() {
        return this.statusBar;
    }

    public JSlider getZoomSlider() {
        return this.zoomSlider;
    }

    public UnitLibrary getUnitLibrary() {
        return this.unitLibrary;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double newScale) {
        this.scale = newScale;
    }

    public JPopupMenu getPopupCanvas() {
        return this.popupCanvas;
    }

    public JPopupMenu getPopupUnit() {
        return this.popupUnit;
    }

    public JPopupMenu getPopupPort() {
        return this.popupPort;
    }
}

