/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.noteProcessor.NoteProcessor;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import electric.xml.Element;

public class RetrogradeProcessor
implements NoteProcessor {
    public String toString() {
        return "[retrograde]";
    }

    @Override
    public final void processNotes(NoteList in) {
        in.sort();
        int size = in.size();
        Note temp = (Note)in.get(in.size() - 1);
        double totalTime = temp.getStartTime() + temp.getSubjectiveDuration();
        for (int i = 0; i < size; ++i) {
            temp = (Note)in.get(i);
            temp.setStartTime(totalTime - (temp.getStartTime() + temp.getSubjectiveDuration()));
        }
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i + " " + i + " 6." + i + " 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        RetrogradeProcessor retro = new RetrogradeProcessor();
        retro.processNotes(n);
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        return new RetrogradeProcessor();
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        return retVal;
    }

    @Override
    public NoteProcessor deepCopy() {
        return new RetrogradeProcessor();
    }
}

