/*
 * Decompiled with CFR 0.152.
 */
package blue.event;

import blue.event.GroupMovementListener;
import blue.event.SelectionList;
import blue.orchestra.blueSynthBuilder.GridSettings;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JComponent;

public class GroupMovementSelectionList<T>
extends SelectionList<T>
implements GroupMovementListener {
    ArrayList originPoints = new ArrayList();
    int minOffsetX = 0;
    int minOffsetY = 0;
    int gridOffsetX = 0;
    int gridOffsetY = 0;
    GridSettings gridSettings = null;

    public void setGridSettings(GridSettings gridSettings) {
        this.gridSettings = gridSettings;
    }

    @Override
    public void initiateMovement(JComponent source) {
        this.originPoints.clear();
        this.minOffsetX = Integer.MAX_VALUE;
        this.minOffsetY = Integer.MAX_VALUE;
        for (JComponent comp : this) {
            Point p = comp.getLocation();
            this.originPoints.add(p);
            if (p.x < this.minOffsetX) {
                this.minOffsetX = p.x;
            }
            if (p.y >= this.minOffsetY) continue;
            this.minOffsetY = p.y;
        }
        this.minOffsetX = -this.minOffsetX;
        this.minOffsetY = -this.minOffsetY;
        if (this.gridSettings != null && this.gridSettings.isSnapEnabled()) {
            this.gridOffsetX = source.getX() % this.gridSettings.getWidth();
            this.gridOffsetY = source.getY() % this.gridSettings.getHeight();
        } else {
            this.gridOffsetY = 0;
            this.gridOffsetX = 0;
        }
    }

    @Override
    public void move(int offsetX, int offsetY) {
        if (this.gridSettings != null && this.gridSettings.isSnapEnabled()) {
            int w = this.gridSettings.getWidth();
            int h = this.gridSettings.getHeight();
            offsetX = (int)(Math.round((double)offsetX / (double)w) * (long)w) - this.gridOffsetX;
            offsetY = (int)(Math.round((double)offsetY / (double)h) * (long)h) - this.gridOffsetY;
        }
        int xVal = offsetX < this.minOffsetX ? this.minOffsetX : offsetX;
        int yVal = offsetY < this.minOffsetY ? this.minOffsetY : offsetY;
        for (int i = 0; i < this.originPoints.size(); ++i) {
            JComponent comp = (JComponent)this.get(i);
            Point origin = (Point)this.originPoints.get(i);
            int newX = origin.x + xVal;
            int newY = origin.y + yVal;
            comp.setLocation(newX, newY);
        }
    }

    public void nudgeUp(int amount) {
        boolean canNudge = true;
        for (JComponent comp : this) {
            if (comp.getY() > amount) continue;
            canNudge = false;
            break;
        }
        if (canNudge) {
            for (JComponent comp : this) {
                comp.setLocation(comp.getX(), comp.getY() - amount);
            }
        }
    }

    public void nudgeDown(int amount) {
        for (JComponent comp : this) {
            comp.setLocation(comp.getX(), comp.getY() + amount);
        }
    }

    public void nudgeLeft(int amount) {
        boolean canNudge = true;
        for (JComponent comp : this) {
            if (comp.getX() >= amount) continue;
            canNudge = false;
            break;
        }
        if (canNudge) {
            for (JComponent comp : this) {
                comp.setLocation(comp.getX() - amount, comp.getY());
            }
        }
    }

    public void nudgeRight(int amount) {
        for (JComponent comp : this) {
            comp.setLocation(comp.getX() + amount, comp.getY());
        }
    }
}

