/*
 * Decompiled with CFR 0.152.
 */
package blue.components.lines;

import blue.components.lines.LinePoint;
import blue.components.lines.LineUtils;
import blue.utility.TextUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.text.StrBuilder;

public class Line
implements TableModel,
ChangeListener,
Iterable<LinePoint> {
    protected String varName = "";
    protected double max = 1.0;
    protected double min = 0.0;
    protected BigDecimal resolution = new BigDecimal(-1);
    protected java.awt.Color color = null;
    protected boolean isZak = false;
    protected boolean rightBound = false;
    protected int channel = 1;
    protected String uniqueID = "";
    protected boolean endPointsLinked = false;
    protected ObservableList<LinePoint> points;
    transient Vector<TableModelListener> listeners = null;

    public Line() {
        this(true);
    }

    public Line(boolean rightBound) {
        this(rightBound, true);
    }

    private Line(boolean rightBound, boolean init) {
        this.points = FXCollections.observableArrayList();
        if (init) {
            LinePoint point1 = new LinePoint();
            point1.setLocation(0.0, 0.5);
            this.points.add((Object)point1);
            if (rightBound) {
                LinePoint point2 = new LinePoint();
                point2.setLocation(1.0, 0.5);
                this.points.add((Object)point2);
            }
        }
        this.rightBound = rightBound;
        this.color = new java.awt.Color(128, 128, 128);
        this.uniqueID = Integer.toString(new VMID().hashCode());
    }

    public Line(Line line) {
        this.varName = line.varName;
        this.max = line.max;
        this.min = line.min;
        this.resolution = line.resolution;
        this.color = line.color;
        this.isZak = line.isZak;
        this.rightBound = line.rightBound;
        this.channel = line.channel;
        this.uniqueID = line.uniqueID;
        this.endPointsLinked = line.endPointsLinked;
        this.points = FXCollections.observableArrayList();
        for (LinePoint lp : line.points) {
            LinePoint newLp = new LinePoint(lp);
            this.points.add((Object)newLp);
            newLp.addChangeListener(this);
        }
    }

    public static Line loadFromXML(Element data) {
        String endLinked;
        String colorStr;
        Line line = new Line(false, false);
        switch (data.getName()) {
            case "line": {
                line.varName = data.getAttributeValue("name");
                line.setZak(false);
                break;
            }
            case "zakline": {
                line.channel = Integer.parseInt(data.getAttributeValue("channel"));
                line.setZak(true);
            }
        }
        int version = 1;
        String versionStr = data.getAttributeValue("version");
        if (versionStr != null) {
            version = Integer.parseInt(versionStr);
        }
        line.max = Double.parseDouble(data.getAttributeValue("max"));
        line.min = Double.parseDouble(data.getAttributeValue("min"));
        if (data.getAttributeValue("resolution") != null) {
            line.resolution = new BigDecimal(Double.parseDouble(data.getAttributeValue("resolution"))).setScale(5, RoundingMode.HALF_UP).stripTrailingZeros();
        }
        if (data.getAttributeValue("bdresolution") != null) {
            line.resolution = new BigDecimal(data.getAttributeValue("bdresolution"));
        }
        line.color = (colorStr = data.getAttributeValue("color")) != null && colorStr.length() > 0 ? new java.awt.Color(Integer.parseInt(colorStr)) : new java.awt.Color(128, 128, 128);
        String rBound = data.getAttributeValue("rightBound");
        if (rBound != null && rBound.length() > 0) {
            line.rightBound = Boolean.valueOf(rBound);
        }
        if ((endLinked = data.getAttributeValue("endPointsLinked")) != null && endLinked.length() > 0) {
            line.endPointsLinked = Boolean.valueOf(endLinked);
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            LinePoint lp = LinePoint.loadFromXML(node);
            line.addLinePoint(lp);
            if (version != 1) continue;
            lp.setLocation(lp.getX(), Line.migrateYValue(lp.getY(), line.max, line.min));
        }
        return line;
    }

    public Element saveAsXML() {
        Element retVal = null;
        if (this.isZak) {
            retVal = new Element("zakline");
            retVal.setAttribute("channel", Integer.toString(this.channel));
        } else {
            retVal = new Element("line");
            retVal.setAttribute("name", this.varName);
        }
        retVal.setAttribute("version", "2");
        retVal.setAttribute("max", Double.toString(this.max));
        retVal.setAttribute("min", Double.toString(this.min));
        retVal.setAttribute("bdresolution", this.resolution.toString());
        retVal.setAttribute("color", Integer.toString(this.color.getRGB()));
        retVal.setAttribute("rightBound", Boolean.toString(this.rightBound));
        retVal.setAttribute("endPointsLinked", Boolean.toString(this.endPointsLinked));
        for (LinePoint point : this.points) {
            retVal.addElement(point.saveAsXML());
        }
        return retVal;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void setZak(boolean isZak) {
        this.isZak = isZak;
    }

    public boolean isZak() {
        return this.isZak;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max, boolean truncate) {
        double oldMax = this.max;
        this.max = max;
        for (LinePoint point : this.points) {
            double newVal = truncate ? LineUtils.truncate(point.getY(), this.min, this.max) : LineUtils.rescale(point.getY(), this.min, oldMax, this.min, this.max, this.resolution);
            point.setLocation(point.getX(), newVal);
        }
        this.fireTableDataChanged();
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min, boolean truncate) {
        double oldMin = this.min;
        this.min = min;
        for (LinePoint point : this.points) {
            double newVal = truncate ? LineUtils.truncate(point.getY(), this.min, this.max) : LineUtils.rescale(point.getY(), oldMin, this.max, this.min, this.max, this.resolution);
            point.setLocation(point.getX(), newVal);
        }
        this.fireTableDataChanged();
    }

    public void setMinMax(double newMin, double newMax, boolean truncate) {
        if (this.min == newMin && this.max == newMax) {
            return;
        }
        for (LinePoint point : this.points) {
            double newVal = truncate ? LineUtils.truncate(point.getY(), newMin, newMax) : LineUtils.rescale(point.getY(), this.min, this.max, newMin, newMax, this.resolution);
            point.setLocation(point.getX(), newVal);
        }
        this.min = newMin;
        this.max = newMax;
        this.fireTableDataChanged();
    }

    @Override
    public Iterator<LinePoint> iterator() {
        return this.points.iterator();
    }

    public java.awt.Color getColor() {
        return this.color;
    }

    public Color getColorFX() {
        int r = this.color.getRed();
        int g = this.color.getGreen();
        int b = this.color.getBlue();
        int a = this.color.getAlpha();
        return Color.rgb((int)r, (int)g, (int)b, (double)((double)a / 255.0));
    }

    public void setColor(java.awt.Color color) {
        this.color = color;
        this.fireTableDataChanged();
    }

    public LinePoint getLinePoint(int index) {
        return (LinePoint)this.points.get(index);
    }

    public void addLinePoint(LinePoint linePoint) {
        this.points.add((Object)linePoint);
        linePoint.addChangeListener(this);
        int end = this.points.size() - 1;
        this.fireTableRowsInserted(end, end);
    }

    public void addLinePoint(int index, LinePoint linePoint) {
        this.points.add(index, (Object)linePoint);
        linePoint.addChangeListener(this);
        this.fireTableRowsInserted(index, index);
    }

    public void insertLinePoint(LinePoint lp) {
        for (int i = 0; i < this.points.size(); ++i) {
            LinePoint temp = (LinePoint)this.points.get(i);
            if (!(temp.getX() > lp.getX())) continue;
            this.addLinePoint(i, lp);
            return;
        }
        this.addLinePoint(lp);
    }

    public void removeLinePoint(int index) {
        LinePoint linePoint = (LinePoint)this.points.remove(index);
        linePoint.removeChangeListener(this);
        this.fireTableRowsDeleted(index, index);
    }

    public void removeLinePoint(LinePoint linePoint) {
        int index = this.points.indexOf((Object)linePoint);
        if (index >= 0) {
            this.points.remove((Object)linePoint);
            linePoint.removeChangeListener(this);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public int size() {
        return this.points.size();
    }

    public void clear() {
        this.points.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.points.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex == 0 && columnIndex == 0) {
            return false;
        }
        return !this.rightBound || rowIndex != this.size() - 1 || columnIndex != 0;
    }

    public Class getColumnClass(int columnIndex) {
        return Double.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LinePoint p = (LinePoint)this.points.get(rowIndex);
        if (columnIndex == 0) {
            return new Double(p.getX());
        }
        return new Double(p.getY());
    }

    private static double migrateYValue(double y, double max, double min) {
        double range = max - min;
        double yVal = y * range + min;
        return yVal;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LinePoint next;
        Double val = (Double)aValue;
        double newValue = val;
        LinePoint point = this.getLinePoint(rowIndex);
        boolean isLeft = rowIndex == 0;
        boolean isRight = rowIndex == this.size() - 1;
        LinePoint previous = isLeft ? null : this.getLinePoint(rowIndex - 1);
        LinePoint linePoint = next = isRight ? null : this.getLinePoint(rowIndex + 1);
        if (columnIndex == 0) {
            if (isLeft) {
                return;
            }
            if (this.rightBound && isRight) {
                return;
            }
            if (previous != null && newValue < previous.getX()) {
                newValue = previous.getX();
            }
            if (next != null && newValue > next.getX()) {
                newValue = next.getX();
            }
            double y = point.getY();
            point.setLocation(newValue, y);
        } else {
            if (newValue < this.getMin() || newValue > this.getMax()) {
                return;
            }
            double x = point.getX();
            point.setLocation(x, newValue);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "x" : "y";
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent e) {
        if (this.listeners != null) {
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(e);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        LinePoint lp = (LinePoint)e.getSource();
        int index = this.points.indexOf((Object)lp);
        if (index >= 0) {
            this.fireTableRowsUpdated(index, index);
        }
    }

    public double getValue(double time) {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        LinePoint a = this.getLinePoint(0);
        if (size == 1 || time == 0.0) {
            return a.getY();
        }
        LinePoint b = null;
        for (int i = 1; i < size; ++i) {
            b = this.getLinePoint(i);
            if (b.getX() == time) {
                LinePoint temp;
                if (i == size - 1) {
                    return b.getY();
                }
                while (i < size && (temp = this.getLinePoint(i)).getX() == time) {
                    b = temp;
                    ++i;
                }
                return b.getY();
            }
            if (!(b.getX() < time)) break;
            a = b;
        }
        if (b == a) {
            return b.getY();
        }
        double m = (b.getY() - a.getY()) / (b.getX() - a.getX());
        double x = time - a.getX();
        double y = m * x + a.getY();
        if (this.resolution.doubleValue() > 0.0) {
            if (b.getY() < a.getY()) {
                y += this.resolution.doubleValue() * 0.99;
            }
            BigDecimal v = new BigDecimal(y).setScale(this.resolution.scale(), RoundingMode.FLOOR);
            v = v.subtract(v.remainder(this.resolution));
            y = v.doubleValue();
        }
        return y;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public boolean isRightBound() {
        return this.rightBound;
    }

    public BigDecimal getResolution() {
        return this.resolution;
    }

    public void setResolution(BigDecimal resolution) {
        this.resolution = resolution;
        for (LinePoint point : this.points) {
            double newVal = LineUtils.snapToResolution(point.getY(), this.min, this.max, this.resolution);
            point.setLocation(point.getX(), newVal);
        }
    }

    public boolean isEndPointsLinked() {
        return this.endPointsLinked;
    }

    public void setEndPointsLinked(boolean endPointsLinked) {
        this.endPointsLinked = endPointsLinked;
    }

    public String exportBPF() {
        if (this.points.size() == 0) {
            return null;
        }
        StrBuilder builder = new StrBuilder();
        for (LinePoint point : this.points) {
            builder.append(point.getX()).append("\t").append(point.getY()).append("\n");
        }
        return builder.toString();
    }

    public boolean importBPF(File bpfFile) {
        String text = null;
        try {
            text = TextUtilities.getTextFromFile(bpfFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (text == null) {
            return false;
        }
        ArrayList<LinePoint> temp = new ArrayList<LinePoint>();
        StringTokenizer lines = new StringTokenizer(text, "\n");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line.trim().length() == 0) continue;
            String[] parts = line.split("\\s+");
            if (parts.length != 2) {
                System.err.println("parts length = " + parts.length);
                return false;
            }
            LinePoint lp = new LinePoint();
            lp.setLocation(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]));
            temp.add(lp);
        }
        this.points.clear();
        this.points.addAll(temp);
        this.fireTableDataChanged();
        return true;
    }

    public void sort() {
        Collections.sort(this.points);
    }

    public boolean isFirstLinePoint(LinePoint linePoint) {
        if (this.points == null || this.points.size() == 0) {
            return false;
        }
        return linePoint == this.points.get(0);
    }

    public ObservableList<LinePoint> getObservableList() {
        return this.points;
    }
}

