/*
 * Decompiled with CFR 0.152.
 */
package blue;

import electric.xml.Element;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Marker
implements Comparable<Marker> {
    private double time = 0.0;
    private String name;
    transient Vector listeners = null;

    public Marker() {
    }

    public Marker(Marker marker) {
        this.time = marker.time;
        this.name = marker.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = name;
        this.name = name;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "name", oldName, name);
        this.firePropertyChangeEvent(pce);
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        double oldVal = this.time;
        this.time = time;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "time", new Double(oldVal), new Double(time));
        this.firePropertyChangeEvent(pce);
    }

    public static Marker loadFromXML(Element data) {
        Marker m = new Marker();
        m.setTime(Double.parseDouble(data.getAttributeValue("time")));
        m.setName(data.getAttributeValue("name"));
        return m;
    }

    public Element saveAsXML() {
        Element retVal = new Element("marker");
        retVal.setAttribute("time", Double.toString(this.getTime()));
        retVal.setAttribute("name", this.getName());
        return retVal;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pcl);
    }

    @Override
    public int compareTo(Marker b) {
        if (this.time > b.time) {
            return 1;
        }
        if (this.time < b.time) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

