/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.ceciliaModule;

import blue.soundObject.ceciliaModule.CeciliaObject;
import electric.xml.Element;

public class CSlider
extends CeciliaObject {
    public static int REL_LINEAR = 0;
    public static int REL_LOGARITHMIC = 1;
    float min = 0.0f;
    float max = 100.0f;
    boolean isKrate = true;
    float resolution = 0.1f;
    boolean isHorizontal = true;
    String unit = "x";
    int rel = REL_LINEAR;
    boolean isInteger = false;
    float value = 0.0f;

    @Override
    public String processText(String ceciliaText) {
        return null;
    }

    @Override
    public void initialize(String[] tokens) {
        this.setObjectName(tokens[1]);
        boolean setInitValue = false;
        float initValue = Float.NaN;
        block18: for (int i = 2; i < tokens.length; i += 2) {
            switch (tokens[i]) {
                case "-label": {
                    this.setLabel(tokens[i + 1]);
                    continue block18;
                }
                case "-min": {
                    this.setMin(Float.parseFloat(tokens[i + 1]));
                    continue block18;
                }
                case "-max": {
                    this.setMax(Float.parseFloat(tokens[i + 1]));
                    continue block18;
                }
                case "-rel": {
                    if (tokens[i + 1].equals("lin")) {
                        this.setRel(REL_LINEAR);
                        continue block18;
                    }
                    if (!tokens[i + 1].equals("log")) continue block18;
                    this.setRel(REL_LOGARITHMIC);
                    continue block18;
                }
                case "-unit": {
                    this.setUnit(tokens[i + 1]);
                    continue block18;
                }
                case "-init": {
                    initValue = Float.parseFloat(tokens[i + 1]);
                    setInitValue = true;
                    continue block18;
                }
                case "-res": {
                    this.isInteger = tokens[i + 1].trim().equals("1");
                    float res = Float.parseFloat(tokens[i + 1].trim());
                    this.setResolution(res);
                    continue block18;
                }
            }
        }
        if (setInitValue) {
            System.out.println("INIT VALUE: " + initValue);
            this.setValue(initValue);
        } else {
            this.setValue(this.getMin());
        }
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public void setHorizontal(boolean isHorizonal) {
        this.isHorizontal = isHorizonal;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public int getRel() {
        return this.rel;
    }

    public void setRel(int rel) {
        this.rel = rel;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void setResolution(float resolution) {
        this.resolution = resolution;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public float getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.isInteger) {
            return Integer.toString((int)this.value);
        }
        return Float.toString(this.value);
    }

    public void setValue(float value) {
        this.value = value;
    }

    public boolean isKrate() {
        return this.isKrate;
    }

    public void setKrate(boolean isKrate) {
        this.isKrate = isKrate;
    }

    public static CeciliaObject loadFromXML(Element data) {
        CSlider cslider = new CSlider();
        CeciliaObject.initBasicFromXML(data, cslider);
        cslider.setMin(Float.parseFloat(data.getTextString("min")));
        cslider.setMax(Float.parseFloat(data.getTextString("max")));
        cslider.setUnit(data.getTextString("unit"));
        cslider.setRel(Integer.parseInt(data.getTextString("rel")));
        cslider.setResolution(Float.parseFloat(data.getTextString("resolution")));
        cslider.setValue(Float.parseFloat(data.getTextString("value")));
        cslider.setHorizontal(Boolean.valueOf(data.getTextString("isHorizontal")));
        cslider.setKrate(Boolean.valueOf(data.getTextString("isKrate")));
        cslider.isInteger = Boolean.valueOf(data.getTextString("isInteger"));
        return cslider;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = CeciliaObject.getBasicXML(this);
        retVal.addElement("min").setText(Float.toString(this.getMin()));
        retVal.addElement("max").setText(Float.toString(this.getMax()));
        retVal.addElement("unit").setText(this.getUnit());
        retVal.addElement("rel").setText(Integer.toString(this.getRel()));
        retVal.addElement("resolution").setText(Float.toString(this.getResolution()));
        retVal.addElement("value").setText(Float.toString(this.getValue()));
        retVal.addElement("isHorizontal").setText(Boolean.toString(this.isHorizontal()));
        retVal.addElement("isKrate").setText(Boolean.toString(this.isKrate()));
        retVal.addElement("isInteger").setText(Boolean.toString(this.isInteger));
        return retVal;
    }

    public String generateSliderText() {
        String val = Float.toString(this.getValue());
        String retVal = "gk" + this.getObjectName() + " init " + val + "\n";
        retVal = retVal + "gi" + this.getObjectName() + " init " + val + "\n";
        return retVal;
    }
}

