/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueGradientFactory;
import blue.plaf.BlueLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;

public class BlueButtonUI
extends MetalButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new BlueButtonUI();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        Graphics2D g2d = (Graphics2D)g;
        Dimension size = c.getSize();
        Color bgColor = c.getBackground();
        if (bgColor == null) {
            bgColor = BlueLookAndFeel.getControl();
        }
        GradientPaint gp = BlueGradientFactory.getGradientPaint(BlueLookAndFeel.getControl());
        Paint p = g2d.getPaint();
        g2d.setPaint(gp);
        g2d.fillRect(0, 0, size.width, size.height);
        g2d.setPaint(p);
        this.paint(g, c);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g.setColor(BlueLookAndFeel.getFocusColor());
        Dimension size = b.getSize();
        g.drawLine(1, 1, size.width - 2, 1);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = b.getSize();
            GradientPaint pressedGp = BlueGradientFactory.getGradientPaint(this.getSelectColor());
            Paint p = g2d.getPaint();
            g2d.setPaint(pressedGp);
            g2d.fillRect(0, 0, size.width, size.height);
            g2d.setPaint(p);
        }
    }
}

