/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.Lex;
import electric.util.Node;
import electric.util.Strings;
import electric.util.io.FastBufferedReader;
import electric.util.io.FastReader;
import electric.util.io.Streams;
import electric.xml.Child;
import electric.xml.Comment;
import electric.xml.DocType;
import electric.xml.Element;
import electric.xml.Instruction;
import electric.xml.NamespaceException;
import electric.xml.Parent;
import electric.xml.ParseException;
import electric.xml.XMLDecl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Document
extends Parent {
    public static final int MAJOR_VERSION = 3;
    public static final int MINOR_VERSION = 0;
    public static final XMLDecl DECLARATION;
    static final String[] NO_STRINGS;
    Hashtable context;

    public Document() {
    }

    public Document(String string) throws ParseException {
        this.parse(new FastReader(string), null);
    }

    public Document(byte[] byArray) throws ParseException {
        this(byArray, null);
    }

    public Document(byte[] byArray, Hashtable hashtable) throws ParseException {
        try {
            this.parse(new FastReader(Strings.toString(byArray)), hashtable);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ParseException(unsupportedEncodingException.toString());
        }
    }

    public Document(File file) throws ParseException {
        try {
            this.parse(new FastBufferedReader(Streams.getReader(file)), null);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    public Document(InputStream inputStream) throws ParseException {
        try {
            this.parse(new FastBufferedReader(Streams.getReader(inputStream)), null);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    public Document(Reader reader) throws ParseException {
        this.parse(reader, null);
    }

    public Document(Reader reader, Hashtable hashtable) throws ParseException {
        this.parse(reader, hashtable);
    }

    public Document(Document document) {
        super(document);
        this.context = document.context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parse(Reader reader, Hashtable hashtable) throws ParseException {
        Lex lex = new Lex(reader, "<>=/:", 1);
        try {
            try {
                this.parse(lex, hashtable);
            }
            catch (Throwable throwable) {
                throw new ParseException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(throwable.getMessage()))).append("\n").append(lex.getLocation()))));
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        reader.close();
        return;
    }

    void parse(Lex lex, Hashtable hashtable) throws NamespaceException, IOException {
        this.context = hashtable;
        int n = 0;
        while (true) {
            lex.skipWhitespace();
            lex.mark(2);
            int n2 = lex.peekRead();
            int n3 = lex.peekRead();
            lex.reset();
            if (n2 == -1) break;
            if (n3 == 33 && lex.peekString("<!--")) {
                new Comment(lex, this);
                continue;
            }
            if (n3 == 33 && lex.peekString("<!DOCTYPE")) {
                new DocType(lex, this);
                continue;
            }
            if (n3 == 63 && lex.peekString("<?xml ")) {
                new XMLDecl(lex, this);
                continue;
            }
            if (n3 == 63) {
                new Instruction(lex, this);
                continue;
            }
            new Element(lex, this);
            ++n;
        }
        if (n != 1) {
            throw new IOException("the document does not have exactly one root");
        }
        lex.skipWhitespace();
        if (lex.read() != -1) {
            throw new IOException("extra stuff at the end");
        }
    }

    public Object clone() {
        return new Document(this);
    }

    public Document getDocument() {
        return this;
    }

    public Element getRoot() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public Element newRoot() {
        return this.setRoot(new Element());
    }

    public Element setRoot(Element element) {
        Element element2 = this.getRoot();
        if (element2 != null) {
            element2.replaceWith(element);
        } else {
            this.addChild(element);
        }
        return element;
    }

    public Element setRoot(String string) {
        Element element = this.newRoot();
        element.setName(string);
        return element;
    }

    public Element setRoot(String string, String string2) {
        Element element = this.newRoot();
        element.setName(string, string2);
        return element;
    }

    public DocType getDocType() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof DocType) {
                return (DocType)node;
            }
            node = node.next;
        }
        return null;
    }

    public XMLDecl getXMLDecl() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof XMLDecl) {
                return (XMLDecl)node;
            }
            node = node.next;
        }
        return null;
    }

    public String getVersion() {
        XMLDecl xMLDecl = this.getXMLDecl();
        return xMLDecl != null ? xMLDecl.getVersion() : "1.0";
    }

    public String getEncoding() {
        XMLDecl xMLDecl = this.getXMLDecl();
        return xMLDecl != null ? xMLDecl.getEncoding() : "UTF-8";
    }

    public boolean getStandalone() {
        XMLDecl xMLDecl = this.getXMLDecl();
        return xMLDecl != null ? xMLDecl.getStandalone() : false;
    }

    public Hashtable getContext() {
        return this.context;
    }

    public void setContext(Hashtable hashtable) {
        this.context = hashtable;
    }

    public String getNamespace(String string) {
        return this.context == null ? null : (String)this.context.get(string);
    }

    protected void addNamespacePrefixes(String string, Vector vector, Vector vector2) {
        if (this.context == null) {
            return;
        }
        Enumeration enumeration = this.context.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (vector.contains(string2) || !this.context.get(string2).equals(string)) continue;
            vector2.addElement(string2);
        }
    }

    public void write(Writer writer, int n) throws IOException {
        Node node = this.children.first;
        while (node != null) {
            ((Child)node).write(writer, n);
            if (node.next != null) {
                writer.write("\r\n");
            }
            node = node.next;
        }
    }

    static {
        MAJOR_VERSION = 3;
        MINOR_VERSION = 0;
        DECLARATION = new XMLDecl("1.0", "UTF-8");
        NO_STRINGS = new String[0];
    }
}

