/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.script.jython;

import blue.scripting.PythonProxy;
import blue.ui.core.script.jython.Bundle;
import blue.ui.utilities.jconsole.JConsole;
import blue.ui.utilities.jconsole.JConsoleDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import javax.swing.JScrollPane;
import org.openide.windows.TopComponent;
import org.python.util.InteractiveInterpreter;

@TopComponent.Description(preferredID="JythonConsoleTopComponent", persistenceType=0)
public final class JythonConsoleTopComponent
extends TopComponent {
    JConsole jconsole = new JConsole();

    public JythonConsoleTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_JythonConsoleTopComponent());
        this.setToolTipText(Bundle.HINT_JythonConsoleTopComponent());
        this.add(new JScrollPane((Component)this.jconsole), "Center");
        PythonProxy.addPythonProxyListener(() -> this.jconsole.setText(">>>"));
        this.jconsole.setDelegate(new JConsoleDelegate(){

            public String getPrompt() {
                return ">>> ";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processCommands(String commands, Reader stdin, Writer stdout, Writer stderr) {
                InteractiveInterpreter interp = PythonProxy.getInterpreter();
                try {
                    interp.setIn(stdin);
                    interp.setOut(stdout);
                    interp.setErr(stderr);
                    interp.runsource(commands);
                }
                finally {
                    interp.setIn(System.in);
                    interp.setOut((OutputStream)System.out);
                    interp.setErr((OutputStream)System.err);
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

