/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.undo.MoveScoreObjectsEdit;
import blue.undo.BlueUndoManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.undo.UndoableEdit;

public final class NudgeUpAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<? extends ScoreObject> selected = ScoreController.getInstance().getSelectedScoreObjects();
        if (!selected.isEmpty()) {
            ScorePath path = ScoreController.getInstance().getScorePath();
            ScoreObject[] scoreObjects = selected.toArray(new ScoreObject[selected.size()]);
            List<Layer> layers = path.getAllLayers();
            int[] indexes = new int[selected.size()];
            for (int i = 0; i < scoreObjects.length; ++i) {
                int index = path.getGlobalLayerIndexForScoreObject(scoreObjects[i]);
                if (index < 1) {
                    return;
                }
                Layer layer = layers.get(index - 1);
                if (!layer.accepts(scoreObjects[i])) {
                    return;
                }
                indexes[i] = index;
            }
            int len = scoreObjects.length;
            ScoreObjectLayer[] startLayers = new ScoreObjectLayer[len];
            ScoreObjectLayer[] endLayers = new ScoreObjectLayer[len];
            for (int i = 0; i < scoreObjects.length; ++i) {
                startLayers[i] = (ScoreObjectLayer)layers.get(indexes[i]);
                endLayers[i] = (ScoreObjectLayer)layers.get(indexes[i] - 1);
                startLayers[i].remove(scoreObjects[i]);
                endLayers[i].add((Object)scoreObjects[i]);
            }
            MoveScoreObjectsEdit edit = new MoveScoreObjectsEdit(scoreObjects, startLayers, endLayers, null, null);
            BlueUndoManager.setUndoManager((String)"score");
            BlueUndoManager.addEdit((UndoableEdit)edit);
        }
    }
}

