/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.manager;

import blue.BlueSystem;
import blue.score.layers.LayerGroup;
import blue.ui.core.score.manager.LayersTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openide.util.NbBundle;

public class LayerGroupManagerDialog
extends JDialog {
    private final DefaultTableModel emptyList = new DefaultTableModel();
    private LayerGroup layerGroup;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane4;
    private JButton layersAddButton;
    private JButton layersMinusButton;
    private JButton layersPushDownButton;
    private JButton layersPushUpButton;
    private JTable layersTable;

    public LayerGroupManagerDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        TableColumn col = this.layersTable.getTableHeader().getColumnModel().getColumn(0);
        col.setMaxWidth(50);
        col.setMinWidth(50);
        col.setPreferredWidth(50);
    }

    public void setLayerGroup(LayerGroup layerGroup) {
        this.layerGroup = layerGroup;
        this.layersTable.setModel(new LayersTableModel(layerGroup));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.layersTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return this.getPreferredSize().height < this.getParent().getHeight();
            }
        };
        this.jPanel2 = new JPanel();
        this.layersPushUpButton = new JButton();
        this.layersPushDownButton = new JButton();
        this.layersAddButton = new JButton();
        this.layersMinusButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(LayerGroupManagerDialog.class, (String)"LayerGroupManagerDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(LayerGroupManagerDialog.class, (String)"LayerGroupManagerDialog.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.layersTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.layersTable.setSelectionMode(1);
        this.jScrollPane4.setViewportView(this.layersTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.getContentPane().add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel2.setMinimumSize(new Dimension(30, 20));
        this.jPanel2.setPreferredSize(new Dimension(160, 20));
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.layersPushUpButton.setText(NbBundle.getMessage(LayerGroupManagerDialog.class, (String)"LayerGroupManagerDialog.layersPushUpButton.text"));
        this.layersPushUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerGroupManagerDialog.this.layersPushUpButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.layersPushUpButton);
        this.layersPushDownButton.setText(NbBundle.getMessage(LayerGroupManagerDialog.class, (String)"LayerGroupManagerDialog.layersPushDownButton.text"));
        this.layersPushDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerGroupManagerDialog.this.layersPushDownButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.layersPushDownButton);
        this.layersAddButton.setText(NbBundle.getMessage(LayerGroupManagerDialog.class, (String)"LayerGroupManagerDialog.layersAddButton.text"));
        this.layersAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerGroupManagerDialog.this.layersAddButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.layersAddButton);
        this.layersMinusButton.setText(NbBundle.getMessage(LayerGroupManagerDialog.class, (String)"LayerGroupManagerDialog.layersMinusButton.text"));
        this.layersMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayerGroupManagerDialog.this.layersMinusButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.layersMinusButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void layersPushUpButtonActionPerformed(ActionEvent evt) {
        LayersTableModel model = this.getLayersListModel();
        if (model == null) {
            return;
        }
        ListSelectionModel selection = this.layersTable.getSelectionModel();
        int start = selection.getMinSelectionIndex();
        int end = selection.getMaxSelectionIndex();
        if (end < 0 || start == 0) {
            return;
        }
        model.pushUpLayers(start, end);
        selection.setSelectionInterval(start - 1, end - 1);
    }

    private void layersPushDownButtonActionPerformed(ActionEvent evt) {
        LayersTableModel model = this.getLayersListModel();
        if (model == null) {
            return;
        }
        ListSelectionModel selection = this.layersTable.getSelectionModel();
        int start = selection.getMinSelectionIndex();
        int end = selection.getMaxSelectionIndex();
        if (end < 0 || end >= model.getRowCount() - 1) {
            return;
        }
        model.pushDownLayers(start, end);
        selection.setSelectionInterval(start + 1, end + 1);
    }

    private void layersAddButtonActionPerformed(ActionEvent evt) {
        LayersTableModel model = this.getLayersListModel();
        if (model == null) {
            return;
        }
        ListSelectionModel selection = this.layersTable.getSelectionModel();
        int end = selection.getMaxSelectionIndex();
        end = end < 0 ? model.getRowCount() : ++end;
        model.newLayerAt(end);
        selection.setSelectionInterval(end, end);
    }

    private void layersMinusButtonActionPerformed(ActionEvent evt) {
        LayersTableModel model = this.getLayersListModel();
        if (model == null) {
            return;
        }
        ListSelectionModel selection = this.layersTable.getSelectionModel();
        int start = selection.getMinSelectionIndex();
        int end = selection.getMaxSelectionIndex();
        if (end < 0 || model.getRowCount() < 2) {
            return;
        }
        int len = end - start + 1;
        String message = BlueSystem.getString((String)"soundLayerEditPanel.delete.message1") + " " + len + " " + BlueSystem.getString((String)"soundLayerEditPanel.delete.message2");
        if (JOptionPane.showConfirmDialog(null, message) == 0) {
            model.removeLayers(start, end);
            selection.clearSelection();
        }
    }

    private LayersTableModel getLayersListModel() {
        if (this.layersTable.getModel() == this.emptyList) {
            return null;
        }
        return (LayersTableModel)this.layersTable.getModel();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(LayerGroupManagerDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(() -> {
            LayerGroupManagerDialog dialog = new LayerGroupManagerDialog((Frame)new JFrame(), true);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dialog.setVisible(true);
        });
    }
}

