/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.noteProcessor.NoteProcessorChain;
import blue.score.Score;
import blue.score.layers.LayerGroup;
import blue.ui.components.IconFactory;
import blue.ui.core.score.NoteProcessorDialog;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreControllerListener;
import blue.ui.core.score.ScorePath;
import blue.ui.utilities.UiUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public final class ScoreObjectBar
extends JComponent
implements ActionListener,
ScoreControllerListener {
    MouseListener popupListener;
    private final JPopupMenu popup = new ScoreObjectBarPopup();
    ScorePath currentPath = null;

    public ScoreObjectBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.popupListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    ScoreObjectBar.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
    }

    protected void resetNames() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            LayerGroupButton btn = (LayerGroupButton)this.getComponent(i);
            btn.resetName();
        }
    }

    private LayerGroupButton findLayerGroup(LayerGroup layerGroup) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            LayerGroupButton btn = (LayerGroupButton)this.getComponent(i);
            if (btn.layerGroup != layerGroup) continue;
            return btn;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LayerGroupButton btn = (LayerGroupButton)e.getSource();
        ScoreController.getInstance().editLayerGroup(btn.getLayerGroup());
    }

    @Override
    public void scorePathChanged(ScorePath path) {
        if (path != this.currentPath) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                LayerGroupButton btn = (LayerGroupButton)this.getComponent(i);
                btn.removeActionListener(this);
                btn.removeMouseListener(this.popupListener);
            }
            this.removeAll();
            LayerGroupButton btn = new LayerGroupButton(path.getScore());
            btn.addActionListener(this);
            btn.addMouseListener(this.popupListener);
            this.add(btn);
            for (LayerGroup layerGroup : path.getLayerGroups()) {
                btn = new LayerGroupButton(layerGroup);
                btn.addActionListener(this);
                btn.addMouseListener(this.popupListener);
                this.add(btn);
            }
        } else {
            List<LayerGroup> layerGroups;
            int pathSize;
            int layerGroupsCount = this.getComponentCount() - 1;
            if (layerGroupsCount > (pathSize = (layerGroups = path.getLayerGroups()).size())) {
                while (this.getComponentCount() - 1 > pathSize) {
                    this.remove(this.getComponentCount() - 1);
                }
            } else if (layerGroupsCount < pathSize) {
                for (int i = layerGroupsCount; i < pathSize; ++i) {
                    LayerGroupButton btn = new LayerGroupButton(layerGroups.get(i));
                    btn.addActionListener(this);
                    btn.addMouseListener(this.popupListener);
                    this.add(btn);
                }
            }
        }
        this.currentPath = path;
        this.repaint();
    }

    class ScoreObjectBarPopup
    extends JPopupMenu {
        ScoreObjectBarPopup() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            LayerGroupButton b = (LayerGroupButton)invoker;
            Score score = b.getScore();
            LayerGroup layerGroup = b.getLayerGroup();
            this.removeAll();
            if (score != null) {
                this.add(this.createLayerGroupMenuItem(score.getNoteProcessorChain()));
                this.addSeparator();
                for (int i = 0; i < score.size(); ++i) {
                    LayerGroup group = (LayerGroup)score.get(i);
                    NoteProcessorChain npc = group.getNoteProcessorChain();
                    if (npc == null) continue;
                    String name = "";
                    if (npc != null && npc.size() > 0) {
                        name = name + "*";
                    }
                    name = name + (i + 1) + ") " + group.getName();
                    JMenu menu = new JMenu(name);
                    menu.add(this.createLayerGroupMenuItem(group.getNoteProcessorChain()));
                    this.add(menu);
                }
            } else if (layerGroup != null) {
                this.add(this.createLayerGroupMenuItem(layerGroup.getNoteProcessorChain()));
            }
            super.show(invoker, x, y);
        }

        private Action createLayerGroupMenuItem(final NoteProcessorChain npc) {
            AbstractAction editProperties = new AbstractAction("Edit NoteProcessors"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (npc != null) {
                        NoteProcessorDialog npcDialog = NoteProcessorDialog.getInstance();
                        npcDialog.setNoteProcessorChain(npc);
                        npcDialog.show(true);
                        ScoreObjectBar.this.resetNames();
                    }
                }
            };
            return editProperties;
        }
    }

    class LayerGroupButton
    extends JButton {
        int xVal = 0;
        int yVal = 0;
        private LayerGroup layerGroup = null;
        private Score score = null;

        private LayerGroupButton() {
            this.setFocusable(false);
            this.setIcon(IconFactory.getRightArrowIcon());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setBorderPainted(false);
        }

        public LayerGroupButton(LayerGroup layerGroup) {
            this();
            this.layerGroup = layerGroup;
            this.resetName();
        }

        public LayerGroupButton(Score score) {
            this();
            this.score = score;
            this.resetName();
        }

        public void resetName() {
            String name = null;
            if (this.score != null) {
                name = "root";
                if (this.score.getNoteProcessorChain().size() > 0) {
                    name = "*" + name;
                }
                for (LayerGroup group : this.score) {
                    NoteProcessorChain npc = group.getNoteProcessorChain();
                    if (npc == null || npc.size() <= 0) continue;
                    name = name + " [*]";
                    break;
                }
            } else if (this.layerGroup != null) {
                name = this.layerGroup.getName();
                NoteProcessorChain npc = this.layerGroup.getNoteProcessorChain();
                if (npc != null && npc.size() > 0) {
                    name = "*" + name;
                }
            }
            String finalName = name;
            SwingUtilities.invokeLater(() -> this.setText(finalName));
        }

        public void setXVal(int xVal) {
            this.xVal = xVal;
        }

        public int getXVal() {
            return this.xVal;
        }

        public void setYVal(int yVal) {
            this.yVal = yVal;
        }

        public int getYVal() {
            return this.yVal;
        }

        public LayerGroup getLayerGroup() {
            return this.layerGroup;
        }

        public Score getScore() {
            return this.score;
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            this.removeMouseListener(ScoreObjectBar.this.popupListener);
        }
    }
}

