/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.score.Score;
import blue.score.ScoreObject;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import blue.score.layers.ScoreObjectLayer;
import blue.ui.core.score.ScoreControllerListener;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.undo.RemoveScoreObjectEdit;
import blue.undo.BlueUndoManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.JScrollPane;
import org.openide.util.Lookup;
import org.openide.util.lookup.InstanceContent;

public class ScoreController {
    private static ScoreController INSTANCE = null;
    private Lookup lookup;
    private final ScoreObjectBuffer buffer = new ScoreObjectBuffer();
    private InstanceContent content;
    private Score score = null;
    WeakHashMap<Score, ScorePath> scorePaths = new WeakHashMap();
    private List<ScoreControllerListener> listeners = new ArrayList<ScoreControllerListener>();
    JScrollPane scrollPane = null;

    public static synchronized ScoreController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScoreController();
        }
        return INSTANCE;
    }

    private ScoreController() {
    }

    public void setLookupAndContent(Lookup lookup, InstanceContent content) {
        this.lookup = lookup;
        this.content = content;
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    protected Lookup getLookup() {
        return this.lookup;
    }

    public void setScore(Score score) {
        ScorePath path = this.scorePaths.get(this.score);
        if (path != null) {
            path.setScrollX(this.scrollPane.getHorizontalScrollBar().getValue());
            path.setScrollY(this.scrollPane.getVerticalScrollBar().getValue());
        }
        this.score = score;
        path = this.scorePaths.get(score);
        if (path == null) {
            path = new ScorePath(score);
            this.scorePaths.put(score, path);
        }
        this.fireScorePathChanged();
        ScorePath fPath = path;
        this.scrollPane.getHorizontalScrollBar().setValue(fPath.getScrollX());
        this.scrollPane.getVerticalScrollBar().setValue(fPath.getScrollY());
    }

    public void editLayerGroup(LayerGroup layerGroup) {
        ScorePath path = this.scorePaths.get(this.score);
        if (path == null) {
            throw new RuntimeException("Error: LayerGroup passed in without a Score");
        }
        if (!path.containsLayerGroup(layerGroup)) {
            int scrollX = this.scrollPane.getHorizontalScrollBar().getValue();
            int scrollY = this.scrollPane.getVerticalScrollBar().getValue();
            path.setScrollX(scrollX);
            path.setScrollY(scrollY);
        }
        if (path.editLayerGroup(layerGroup)) {
            this.fireScorePathChanged();
            this.scrollPane.getHorizontalScrollBar().setValue(path.getScrollX());
            this.scrollPane.getVerticalScrollBar().setValue(path.getScrollY());
        }
    }

    public Score getScore() {
        return this.score;
    }

    public ScorePath getScorePath() {
        return this.scorePaths.get(this.score);
    }

    public void addScoreControllerListener(ScoreControllerListener listener) {
        this.listeners.add(listener);
    }

    public void removeScoreControllerListener(ScoreControllerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireScorePathChanged() {
        ScorePath path = this.scorePaths.get(this.score);
        if (path != null) {
            for (ScoreControllerListener listener : this.listeners) {
                listener.scorePathChanged(path);
            }
        }
    }

    public void copyScoreObjects() {
        if (this.lookup == null || this.content == null) {
            return;
        }
        Collection scoreObjects = this.lookup.lookupAll(ScoreObject.class);
        if (scoreObjects.isEmpty()) {
            return;
        }
        this.buffer.clear();
        List<Layer> layers = this.getScorePath().getAllLayers();
        int layerMin = Integer.MAX_VALUE;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (ScoreObject scoreObject : scoreObjects) {
            Layer foundLayer = null;
            for (Layer layer : layers) {
                if (!layer.contains(scoreObject)) continue;
                foundLayer = layer;
                break;
            }
            if (foundLayer == null) {
                throw new RuntimeException("Error: Trying to copy a ScoreObject without a layer: Internal Error");
            }
            int layerIndex = layers.indexOf(foundLayer);
            this.buffer.scoreObjects.add(scoreObject);
            indexes.add(layerIndex);
            if (layerIndex >= layerMin) continue;
            layerMin = layerIndex;
        }
        for (Integer layerIndex : indexes) {
            this.buffer.layerIndexes.add(layerIndex - layerMin);
        }
    }

    public void deleteScoreObjects() {
        if (this.lookup == null || this.content == null) {
            return;
        }
        Collection<? extends ScoreObject> scoreObjects = ScoreController.getInstance().getSelectedScoreObjects();
        Score score = (Score)this.lookup.lookup(Score.class);
        if (score == null) {
            throw new RuntimeException("Score object not set in ScoreController: internal error");
        }
        if (scoreObjects.isEmpty()) {
            return;
        }
        List<Layer> layers = this.getScorePath().getAllLayers();
        RemoveScoreObjectEdit top = null;
        for (ScoreObject scoreObject : scoreObjects) {
            RemoveScoreObjectEdit edit = null;
            for (Layer layer : layers) {
                if (!layer.remove(scoreObject)) continue;
                edit = new RemoveScoreObjectEdit((ScoreObjectLayer)layer, scoreObject);
                break;
            }
            if (edit == null) {
                throw new RuntimeException("Error: Unable to find Layer to remove ScoreObject: Internal Error");
            }
            if (top == null) {
                top = edit;
            } else {
                top.appendNextEdit(edit);
            }
            this.content.remove((Object)scoreObject);
        }
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit(top);
    }

    public void cutScoreObjects() {
        if (this.lookup == null || this.content == null) {
            return;
        }
        this.copyScoreObjects();
        this.deleteScoreObjects();
    }

    public ScoreObjectBuffer getScoreObjectBuffer() {
        return this.buffer;
    }

    public void setSelectedScoreObjects(Collection<? extends ScoreObject> scoreObjects) {
        if (this.lookup == null || this.content == null) {
            return;
        }
        for (ScoreObject scoreObject : this.lookup.lookupAll(ScoreObject.class)) {
            this.content.remove((Object)scoreObject);
        }
        if (scoreObjects != null) {
            for (ScoreObject scoreObject : scoreObjects) {
                this.content.add((Object)scoreObject);
            }
        }
    }

    public void addSelectedScoreObject(ScoreObject scoreObj) {
        if (this.lookup == null || this.content == null) {
            return;
        }
        this.content.add((Object)scoreObj);
    }

    public void removeSelectedScoreObject(ScoreObject scoreObj) {
        if (this.lookup == null || this.content == null) {
            return;
        }
        this.content.remove((Object)scoreObj);
    }

    public Collection<? extends ScoreObject> getSelectedScoreObjects() {
        if (this.lookup == null || this.content == null) {
            return null;
        }
        return this.lookup.lookupAll(ScoreObject.class);
    }

    public static class ScoreObjectBuffer {
        public final List<ScoreObject> scoreObjects = new ArrayList<ScoreObject>();
        public final List<Integer> layerIndexes = new ArrayList<Integer>();

        public void clear() {
            this.scoreObjects.clear();
            this.layerIndexes.clear();
        }
    }
}

