/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.ui.core.score.ModeManager;
import blue.ui.core.score.ScoreMode;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ModeSelectionPanel
extends JPanel {
    boolean updating = false;
    private ButtonGroup modeButtonGroup;
    private JToggleButton modeMultiLineToggle;
    private JToggleButton modeScoreToggle;
    private JToggleButton modeSingleLineToggle;

    public ModeSelectionPanel() {
        this.initComponents();
        this.modeScoreToggle.setSelected(true);
        ModeManager.getInstance().addModeListener(mode -> {
            this.updating = true;
            switch (mode) {
                case SCORE: {
                    this.modeScoreToggle.setSelected(true);
                    break;
                }
                case SINGLE_LINE: {
                    this.modeSingleLineToggle.setSelected(true);
                    break;
                }
                case MULTI_LINE: {
                    this.modeMultiLineToggle.setSelected(true);
                }
            }
            this.updating = false;
        });
    }

    private void initComponents() {
        this.modeButtonGroup = new ButtonGroup();
        this.modeScoreToggle = new JToggleButton();
        this.modeSingleLineToggle = new JToggleButton();
        this.modeMultiLineToggle = new JToggleButton();
        this.setLayout(new BoxLayout(this, 2));
        this.modeButtonGroup.add(this.modeScoreToggle);
        this.modeScoreToggle.setText("Score");
        this.modeScoreToggle.setFocusPainted(false);
        this.modeScoreToggle.setFocusable(false);
        this.modeScoreToggle.setMargin(new Insets(0, 3, 0, 3));
        this.modeScoreToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModeSelectionPanel.this.modeScoreToggleActionPerformed(evt);
            }
        });
        this.add(this.modeScoreToggle);
        this.modeButtonGroup.add(this.modeSingleLineToggle);
        this.modeSingleLineToggle.setText("Single Line");
        this.modeSingleLineToggle.setFocusPainted(false);
        this.modeSingleLineToggle.setFocusable(false);
        this.modeSingleLineToggle.setMargin(new Insets(0, 3, 0, 3));
        this.modeSingleLineToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModeSelectionPanel.this.modeSingleLineToggleActionPerformed(evt);
            }
        });
        this.add(this.modeSingleLineToggle);
        this.modeButtonGroup.add(this.modeMultiLineToggle);
        this.modeMultiLineToggle.setText("Multi Line");
        this.modeMultiLineToggle.setFocusPainted(false);
        this.modeMultiLineToggle.setFocusable(false);
        this.modeMultiLineToggle.setMargin(new Insets(0, 3, 0, 3));
        this.modeMultiLineToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModeSelectionPanel.this.modeMultiLineToggleActionPerformed(evt);
            }
        });
        this.add(this.modeMultiLineToggle);
    }

    private void modeMultiLineToggleActionPerformed(ActionEvent evt) {
        if (!this.updating) {
            ModeManager.getInstance().setMode(ScoreMode.MULTI_LINE);
        }
    }

    private void modeSingleLineToggleActionPerformed(ActionEvent evt) {
        if (!this.updating) {
            ModeManager.getInstance().setMode(ScoreMode.SINGLE_LINE);
        }
    }

    private void modeScoreToggleActionPerformed(ActionEvent evt) {
        if (!this.updating) {
            ModeManager.getInstance().setMode(ScoreMode.SCORE);
        }
    }
}

