/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.BlueSystem;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.ui.core.score.ScoreController;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;

public class LayerHeightWheelListener
implements MouseWheelListener {
    MouseWheelListener[] listeners;
    private final Component source;

    public LayerHeightWheelListener(Component source) {
        this.source = source;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int shortcutKey = BlueSystem.getMenuShortcutKey();
        if ((e.getModifiers() & shortcutKey) == shortcutKey) {
            int value = e.getWheelRotation();
            value = value > 0 ? 1 : -1;
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.source);
            Layer layer = ScoreController.getInstance().getScorePath().getGlobalLayerForY(p.y);
            if (layer instanceof ScoreObjectLayer) {
                ScoreObjectLayer sLayer = (ScoreObjectLayer)layer;
                int index = sLayer.getHeightIndex();
                int newIndex = index + value;
                if (newIndex >= 0 && newIndex <= 9) {
                    sLayer.setHeightIndex(newIndex);
                }
                e.consume();
            }
        } else {
            this.source.getParent().dispatchEvent(e);
        }
    }
}

