/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.render;

import blue.BlueData;
import blue.BlueSystem;
import blue.automation.Parameter;
import blue.event.PlayModeListener;
import blue.noteProcessor.TempoMapper;
import blue.score.ScoreGenerationException;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import blue.services.render.DiskRenderJob;
import blue.services.render.DiskRenderService;
import blue.services.render.RenderTimeManager;
import blue.utility.FileUtilities;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.Exceptions;
import org.openide.windows.IOColors;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class ProcessConsole
implements DiskRenderService {
    private RenderTimeManager renderTimeManager = null;
    private InputOutput io = null;
    transient OutputThread stdoutThread = null;
    transient OutputThread stderrThread = null;
    transient BufferedReader bufferedReaderStdout = null;
    transient BufferedReader bufferedReaderStderr = null;
    public transient Process process = null;
    String commandLine = null;
    transient PrintWriter stdin = null;
    ArrayList<PlayModeListener> listeners = new ArrayList();
    StringBuffer buffer = null;
    private int lastExitValue = 0;

    public String toString() {
        return "Commmandline Runner";
    }

    public void addPlayModeListener(PlayModeListener listener) {
        this.listeners.add(listener);
    }

    public void removePlayModeListener(PlayModeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyPlayModeListeners(int playMode) {
        for (PlayModeListener listener : this.listeners) {
            listener.playModeChanged(playMode);
        }
    }

    public void execWait(String commandLine, File currentWorkingDirectory) throws IOException {
        try {
            this.exec(commandLine, currentWorkingDirectory, false);
            this.process.waitFor();
            this.destroy(true, false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void execWaitAndCollect(String commandLine, File currentWorkingDirectory) throws IOException {
        try {
            this.exec(commandLine, currentWorkingDirectory, true);
            this.process.waitFor();
            while (this.stderrThread != null && this.stderrThread.isCollecting || this.stdoutThread != null && this.stdoutThread.isCollecting) {
                Thread.yield();
                Thread.sleep(50L);
            }
            this.destroy(true, false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void renderToDisk(DiskRenderJob job) {
        if (this.io != null) {
            try {
                this.io.getOut().reset();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        try {
            this.io = IOProvider.getDefault().getIO("Csound (Disk)", false);
            IOColors.setColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.OUTPUT, (Color)Color.WHITE);
            this.io.select();
            String commandLine = StringUtils.join((Object[])job.getArgs(), (String)" ");
            BlueData data = job.getData();
            double startTime = data.getRenderStartTime();
            double endTime = data.getRenderEndTime();
            if (data.getProjectProperties().diskAlwaysRenderEntireProject) {
                startTime = 0.0;
                endTime = -1.0;
            }
            CsdRenderResult result = CSDRenderService.getDefault().generateCSD(data, startTime, endTime, false, false);
            String csd = result.getCsdText();
            File temp = FileUtilities.createTempTextFile((String)"tempCsd", (String)".csd", (File)BlueSystem.getCurrentProjectDirectory(), (String)csd);
            commandLine = commandLine + " \"" + temp.getAbsolutePath() + "\"";
            commandLine = commandLine + " -L stdin";
            this.execDisk(commandLine, job.getCurrentWorkingDirectory());
            this.process.waitFor();
            this.destroy(true, true);
        }
        catch (ScoreGenerationException | IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] splitCommandString(String in) {
        int mode = 0;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        block5: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (mode) {
                case 0: {
                    if (c == '\n' || c == '\t' || c == ' ') continue block5;
                    if (c == '\"') {
                        mode = 2;
                        continue block5;
                    }
                    buffer.append(c);
                    mode = 1;
                    continue block5;
                }
                case 1: {
                    if (c == '\n' || c == '\t' || c == ' ') {
                        parts.add(buffer.toString());
                        buffer = new StringBuffer();
                        mode = 0;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case 2: {
                    if (c == '\"') {
                        parts.add(buffer.toString());
                        buffer = new StringBuffer();
                        mode = 0;
                        continue block5;
                    }
                    buffer.append(c);
                }
            }
        }
        if (buffer.length() != 0) {
            parts.add(buffer.toString());
        }
        String[] retVal = new String[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            retVal[i] = (String)parts.get(i);
        }
        return retVal;
    }

    private void exec(String commandLine, File currentWorkingdirectory, boolean collecting) throws IOException {
        this.destroy(false);
        this.buffer = collecting ? new StringBuffer() : null;
        if (this.io != null) {
            try {
                this.io.getOut().reset();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.io = IOProvider.getDefault().getIO("Csound", false);
        IOColors.setColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.OUTPUT, (Color)Color.WHITE);
        this.io.getOut().append((CharSequence)"[CommandlineRunner] - ").append(BlueSystem.getString((String)"processConsole.start") + "(" + commandLine + ").").append("\n");
        this.notifyPlayModeListeners(1);
        this.commandLine = commandLine;
        if (System.getProperty("os.name").contains("Windows")) {
            this.process = Runtime.getRuntime().exec(commandLine, null, currentWorkingdirectory);
        } else {
            this.commandLine = this.commandLine + " -L stdin";
            String[] cmdArray = ProcessConsole.splitCommandString(this.commandLine);
            this.process = Runtime.getRuntime().exec(cmdArray, null, currentWorkingdirectory);
        }
        this.bufferedReaderStderr = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        this.stderrThread = new OutputThread(this.bufferedReaderStderr);
        this.bufferedReaderStdout = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.stdoutThread = new OutputThread(this.bufferedReaderStdout);
        this.stderrThread.start();
        this.stdoutThread.start();
        this.stdin = new PrintWriter(this.process.getOutputStream());
    }

    private void execDisk(String commandLine, File currentWorkingdirectory) throws IOException {
        this.destroy(false);
        if (this.io != null) {
            try {
                this.io.getOut().reset();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.io.getOut().append((CharSequence)"[CommandlineRunner] - ").append(BlueSystem.getString((String)"processConsole.start") + "(" + commandLine + ").").append("\n");
        this.commandLine = commandLine;
        if (System.getProperty("os.name").contains("Windows")) {
            this.process = Runtime.getRuntime().exec(commandLine, null, currentWorkingdirectory);
        } else {
            String[] cmdArray = ProcessConsole.splitCommandString(this.commandLine);
            this.process = Runtime.getRuntime().exec(cmdArray, null, currentWorkingdirectory);
        }
        this.bufferedReaderStderr = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        this.stderrThread = new OutputThread(this.bufferedReaderStderr);
        this.bufferedReaderStdout = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.stdoutThread = new OutputThread(this.bufferedReaderStdout);
        this.stderrThread.start();
        this.stdoutThread.start();
        this.stdin = new PrintWriter(this.process.getOutputStream());
    }

    public boolean isRunning() {
        return this.process != null;
    }

    public void stop() {
        if (this.isRunning()) {
            this.destroy(false, true);
        }
    }

    public void destroy(boolean notifyListeners) {
        this.destroy(notifyListeners, true);
    }

    public void destroy(boolean notifyListeners, boolean killProcess) {
        if (killProcess) {
            if (System.getProperty("os.name").contains("Windows")) {
                try {
                    if (this.stderrThread != null) {
                        this.stderrThread.killThread = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.stdoutThread != null) {
                        this.stdoutThread.killThread = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.process != null) {
                        this.process.destroy();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            } else {
                try {
                    if (this.process != null) {
                        this.passToStdin("e");
                        this.process.waitFor();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        } else if (this.process != null) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        if (this.process != null) {
            try {
                this.setLastExitValue(this.process.exitValue());
            }
            catch (IllegalThreadStateException itse) {
                this.setLastExitValue(0);
            }
        }
        this.stderrThread = null;
        this.stdoutThread = null;
        this.process = null;
        this.stdin = null;
        if (this.commandLine != null) {
            this.io.getOut().append((CharSequence)(BlueSystem.getString((String)"processConsole.stop") + "(" + this.commandLine + ").")).append("\n");
        }
        this.commandLine = null;
        if (notifyListeners) {
            if (this.renderTimeManager != null) {
                this.renderTimeManager.endRender();
            }
            this.notifyPlayModeListeners(0);
        }
    }

    public void passToStdin(String text) {
        if (this.stdin != null) {
            this.stdin.print(text + "\n");
            this.stdin.flush();
        }
    }

    public String getCollectedOutput() {
        if (this.buffer == null) {
            return null;
        }
        return this.buffer.toString();
    }

    public void execWait(String[] args, File currentWorkingDirectory, double startTime, TempoMapper mapper, ArrayList<Parameter> parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String execWaitAndCollect(String[] args, File currentWorkingDirectory) {
        String command = StringUtils.join((Object[])args, (String)" ");
        try {
            this.execWaitAndCollect(command, currentWorkingDirectory);
        }
        catch (IOException ex) {
            return null;
        }
        return this.getCollectedOutput();
    }

    public int getCsoundVersion(String csoundCommand) {
        String[] lines;
        String val = this.execWaitAndCollect(new String[]{csoundCommand}, null);
        for (String line : lines = val.split("\\r?\\n")) {
            if (!line.trim().startsWith("Csound version")) continue;
            String[] parts = line.split("\\s+");
            try {
                return Integer.parseInt("" + parts[2].charAt(0));
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return -1;
    }

    public void setRenderTimeManager(RenderTimeManager renderTimeManager) {
        this.renderTimeManager = renderTimeManager;
    }

    private void setLastExitValue(int lastExitValue) {
        this.lastExitValue = lastExitValue;
    }

    public int getLastExitValue() {
        return this.lastExitValue;
    }

    public class OutputThread
    extends Thread {
        BufferedReader reader = null;
        volatile boolean killThread = false;
        public boolean isCollecting = true;

        OutputThread(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            try {
                String line = null;
                int counter = 100;
                while ((line = this.reader.readLine()) != null && counter >= 0) {
                    if (this.killThread) {
                        --counter;
                    }
                    if (line.startsWith("blueTimePointer")) {
                        double time = Double.parseDouble(line.substring(line.indexOf("=") + 1));
                        if (ProcessConsole.this.renderTimeManager != null) {
                            ProcessConsole.this.renderTimeManager.updateTimePointer(time);
                        }
                    } else if (ProcessConsole.this.buffer != null) {
                        ProcessConsole.this.buffer.append(line).append("\n");
                    } else if (ProcessConsole.this.io == null) {
                        System.out.println(line);
                        System.out.flush();
                    } else {
                        ProcessConsole.this.io.getOut().append((CharSequence)line).append("\n");
                    }
                    OutputThread.yield();
                }
            }
            catch (IOException | NullPointerException exception) {
                // empty catch block
            }
            this.isCollecting = false;
        }
    }
}

